/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.ScrollColorProducer;
import com.intellij.ui.components.ScrollPainter;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

class DefaultScrollBarUI
extends ScrollBarUI {
    static final Key<RegionPainter<Object>> LEADING_AREA = Key.create((String)"PLAIN_SCROLL_BAR_UI_LEADING_AREA");
    private final Listener myListener = new Listener();
    private final Timer myScrollTimer = UIUtil.createNamedTimer((String)"ScrollBarThumbScrollTimer", (int)60, (ActionListener)this.myListener);
    final TwoWayAnimator myTrackAnimator = new TwoWayAnimator("ScrollBarTrack", 11, 150, 125, 300, 125){

        @Override
        void onValueUpdate() {
            DefaultScrollBarUI.this.repaint();
        }
    };
    final TwoWayAnimator myThumbAnimator = new TwoWayAnimator("ScrollBarThumb", 11, 150, 125, 300, 125){

        @Override
        void onValueUpdate() {
            DefaultScrollBarUI.this.repaint();
        }
    };
    private final Rectangle myThumbBounds = new Rectangle();
    private final Rectangle myTrackBounds = new Rectangle();
    private final Rectangle myLeadingBounds = new Rectangle();
    private final int myThickness;
    private final int myThicknessMax;
    private final int myThicknessMin;
    JScrollBar myScrollBar;
    private boolean isValueCached;
    private int myCachedValue;
    private int myOldValue;

    DefaultScrollBarUI() {
        this(13, 14, 10);
    }

    DefaultScrollBarUI(int thickness, int thicknessMax, int thicknessMin) {
        this.myThickness = thickness;
        this.myThicknessMax = thicknessMax;
        this.myThicknessMin = thicknessMin;
    }

    int getThickness() {
        return this.scale(this.myScrollBar == null || this.myScrollBar.isOpaque() ? this.myThickness : this.myThicknessMax);
    }

    int getMinimalThickness() {
        return this.scale(this.myThicknessMin);
    }

    boolean isAbsolutePositioning(MouseEvent event) {
        return SwingUtilities.isMiddleMouseButton(event);
    }

    boolean isBorderNeeded(JComponent c) {
        return c.isOpaque() && Registry.is((String)"ide.scroll.track.border.paint");
    }

    boolean isTrackClickable() {
        return this.myScrollBar.isOpaque() || this.myTrackAnimator.myValue > 0.0f;
    }

    boolean isTrackExpandable() {
        return Registry.is((String)"ide.scroll.bar.expand.animation");
    }

    boolean isTrackContains(int x, int y) {
        return this.myTrackBounds.contains(x, y);
    }

    boolean isThumbContains(int x, int y) {
        return this.myThumbBounds.contains(x, y);
    }

    void onTrackHover(boolean hover) {
        this.myTrackAnimator.start(hover);
    }

    void onThumbHover(boolean hover) {
        this.myThumbAnimator.start(hover);
    }

    void paintTrack(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        RegionPainter<Float> p;
        RegionPainter<Float> regionPainter = p = ScrollColorProducer.isDark(c) ? ScrollPainter.Track.DARCULA : ScrollPainter.Track.DEFAULT;
        if (!this.isTrackExpandable() && Registry.is((String)"ide.scroll.background.wide")) {
            p.paint(g, x, y, width, height, Float.valueOf(this.myTrackAnimator.myValue));
            return;
        }
        this.paint(p, g, x, y, width, height, c, this.myTrackAnimator.myValue, false);
    }

    void paintThumb(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        RegionPainter<Float> p = ScrollColorProducer.isDark(c) ? ScrollPainter.Thumb.DARCULA : ScrollPainter.Thumb.DEFAULT;
        this.paint(p, g, x, y, width, height, c, this.myThumbAnimator.myValue, Registry.is((String)"ide.scroll.thumb.small.if.opaque"));
    }

    void onThumbMove() {
    }

    void paint(RegionPainter<Float> p, Graphics2D g, int x, int y, int width, int height, JComponent c, float value, boolean small) {
        if (!c.isOpaque()) {
            JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                int offset = this.getTrackOffset(width - this.getMinimalThickness());
                if (offset > 0) {
                    width -= offset;
                    if (alignment == JBScrollPane.Alignment.RIGHT) {
                        x += offset;
                    }
                }
            } else {
                int offset = this.getTrackOffset(height - this.getMinimalThickness());
                if (offset > 0) {
                    height -= offset;
                    if (alignment == JBScrollPane.Alignment.BOTTOM) {
                        y += offset;
                    }
                }
            }
        } else if (small) {
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        p.paint(g, x, y, width, height, Float.valueOf(value));
    }

    private int getTrackOffset(int offset) {
        if (!this.isTrackExpandable()) {
            return offset;
        }
        float value = this.myTrackAnimator.myValue;
        if (value <= 0.0f) {
            return offset;
        }
        if (value >= 1.0f) {
            return 0;
        }
        return (int)(0.5f + (float)offset * (1.0f - value));
    }

    void repaint() {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint();
        }
    }

    void repaint(int x, int y, int width, int height) {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint(x, y, width, height);
        }
    }

    private int scale(int value) {
        value = JBUI.scale((int)value);
        switch (UIUtil.getComponentStyle((Component)this.myScrollBar)) {
            case LARGE: {
                return (int)((double)value * 1.15);
            }
            case SMALL: {
                return (int)((double)value * 0.857);
            }
            case MINI: {
                return (int)((double)value * 0.714);
            }
        }
        return value;
    }

    @Override
    public void installUI(JComponent c) {
        this.myScrollBar = (JScrollBar)c;
        ScrollColorProducer.setBackground(c);
        ScrollColorProducer.setForeground(c);
        this.myScrollBar.setFocusable(false);
        this.myScrollBar.addMouseListener(this.myListener);
        this.myScrollBar.addMouseMotionListener(this.myListener);
        this.myScrollBar.getModel().addChangeListener(this.myListener);
        this.myScrollBar.addPropertyChangeListener(this.myListener);
        this.myScrollBar.addFocusListener(this.myListener);
        this.myScrollTimer.setInitialDelay(300);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myScrollTimer.stop();
        this.myTrackAnimator.stop();
        this.myThumbAnimator.stop();
        this.myScrollBar.removeFocusListener(this.myListener);
        this.myScrollBar.removePropertyChangeListener(this.myListener);
        this.myScrollBar.getModel().removeChangeListener(this.myListener);
        this.myScrollBar.removeMouseMotionListener(this.myListener);
        this.myScrollBar.removeMouseListener(this.myListener);
        this.myScrollBar.setForeground(null);
        this.myScrollBar.setBackground(null);
        this.myScrollBar = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int thickness = this.getThickness();
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        return alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment != null && g instanceof Graphics2D) {
            int size;
            RegionPainter leading;
            Color foreground;
            Color background;
            Container parent = c.getParent();
            Color color = background = !c.isOpaque() ? null : c.getBackground();
            if (background != null) {
                g.setColor(background);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            Rectangle bounds = new Rectangle(c.getWidth(), c.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)c.getInsets());
            if (parent instanceof JScrollPane && (foreground = c.getForeground()) != null && !foreground.equals(background) && this.isBorderNeeded(c)) {
                g.setColor(foreground);
                switch (alignment) {
                    case TOP: {
                        --bounds.height;
                        g.drawLine(bounds.x, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
                        break;
                    }
                    case LEFT: {
                        --bounds.width;
                        g.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height);
                        break;
                    }
                    case RIGHT: {
                        g.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
                        --bounds.width;
                        ++bounds.x;
                        break;
                    }
                    case BOTTOM: {
                        g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
                        --bounds.height;
                        ++bounds.y;
                    }
                }
            }
            if (!c.isOpaque() && this.myTrackAnimator.myValue > 0.0f) {
                this.paintTrack((Graphics2D)g, bounds.x, bounds.y, bounds.width, bounds.height, c);
            }
            if ((leading = (RegionPainter)UIUtil.getClientProperty((Object)c, LEADING_AREA)) == null) {
                this.myLeadingBounds.setSize(0, 0);
            } else if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                size = bounds.width;
                this.myLeadingBounds.setBounds(bounds.x, bounds.y, size, size);
                leading.paint((Graphics2D)g, bounds.x, bounds.y, size, size, null);
                bounds.height -= size;
                bounds.y += size;
            } else {
                size = bounds.height;
                this.myLeadingBounds.setBounds(bounds.x, bounds.y, size, size);
                leading.paint((Graphics2D)g, bounds.x, bounds.y, size, size, null);
                bounds.width -= size;
                bounds.x += size;
            }
            this.myTrackBounds.setBounds(bounds);
            this.updateThumbBounds();
            RegionPainter track = (RegionPainter)UIUtil.getClientProperty((Object)c, JBScrollBar.TRACK);
            if (track != null && this.myTrackBounds.width > 0 && this.myTrackBounds.height > 0) {
                track.paint((Graphics2D)g, this.myTrackBounds.x, this.myTrackBounds.y, this.myTrackBounds.width, this.myTrackBounds.height, null);
            }
            if (this.myThumbBounds.width > 0 && this.myThumbBounds.height > 0) {
                this.paintThumb((Graphics2D)g, this.myThumbBounds.x, this.myThumbBounds.y, this.myThumbBounds.width, this.myThumbBounds.height, c);
            }
        }
    }

    private void updateThumbBounds() {
        int value = 0;
        int min = this.myScrollBar.getMinimum();
        int max = this.myScrollBar.getMaximum();
        int range = max - min;
        if (range <= 0) {
            this.myThumbBounds.setBounds(0, 0, 0, 0);
        } else if (1 == this.myScrollBar.getOrientation()) {
            int extent = this.myScrollBar.getVisibleAmount();
            int height = Math.max(DefaultScrollBarUI.convert(this.myTrackBounds.height, extent, range), 2 * this.getThickness());
            if (this.myTrackBounds.height <= height) {
                this.myThumbBounds.setBounds(0, 0, 0, 0);
            } else {
                value = this.getValue();
                int maxY = this.myTrackBounds.y + this.myTrackBounds.height - height;
                int y = value < max - extent ? DefaultScrollBarUI.convert(this.myTrackBounds.height - height, value - min, range - extent) : maxY;
                this.myThumbBounds.setBounds(this.myTrackBounds.x, DefaultScrollBarUI.adjust(y, this.myTrackBounds.y, maxY), this.myTrackBounds.width, height);
                if (this.myOldValue != value) {
                    this.onThumbMove();
                }
            }
        } else {
            int extent = this.myScrollBar.getVisibleAmount();
            int width = Math.max(DefaultScrollBarUI.convert(this.myTrackBounds.width, extent, range), 2 * this.getThickness());
            if (this.myTrackBounds.width <= width) {
                this.myThumbBounds.setBounds(0, 0, 0, 0);
            } else {
                int x;
                value = this.getValue();
                int maxX = this.myTrackBounds.x + this.myTrackBounds.width - width;
                int n = x = value < max - extent ? DefaultScrollBarUI.convert(this.myTrackBounds.width - width, value - min, range - extent) : maxX;
                if (!this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                    x = this.myTrackBounds.x - x + maxX;
                }
                this.myThumbBounds.setBounds(DefaultScrollBarUI.adjust(x, this.myTrackBounds.x, maxX), this.myTrackBounds.y, width, this.myTrackBounds.height);
                if (this.myOldValue != value) {
                    this.onThumbMove();
                }
            }
        }
        this.myOldValue = value;
    }

    private int getValue() {
        return this.isValueCached ? this.myCachedValue : this.myScrollBar.getValue();
    }

    private static int convert(double newRange, double oldValue, double oldRange) {
        return (int)(0.5 + newRange * oldValue / oldRange);
    }

    private static int adjust(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private final class Listener
    extends MouseAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener,
    PropertyChangeListener {
        private int myOffset;
        private int myMouseX;
        private int myMouseY;
        private boolean isReversed;
        private boolean isDragging;
        private boolean isOverTrack;
        private boolean isOverThumb;

        private Listener() {
        }

        private void updateMouse(int x, int y) {
            if (DefaultScrollBarUI.this.isTrackContains(x, y)) {
                boolean hover;
                if (!this.isOverTrack) {
                    this.isOverTrack = true;
                    DefaultScrollBarUI.this.onTrackHover(true);
                }
                if (this.isOverThumb != (hover = DefaultScrollBarUI.this.isThumbContains(x, y))) {
                    this.isOverThumb = hover;
                    DefaultScrollBarUI.this.onThumbHover(this.isOverThumb);
                }
            } else {
                this.updateMouseExit();
            }
        }

        private void updateMouseExit() {
            if (this.isOverThumb) {
                this.isOverThumb = false;
                DefaultScrollBarUI.this.onThumbHover(false);
            }
            if (this.isOverTrack) {
                this.isOverTrack = false;
                DefaultScrollBarUI.this.onTrackHover(false);
            }
        }

        private boolean redispatchIfTrackNotClickable(MouseEvent event) {
            JScrollPane pane;
            Component view;
            if (DefaultScrollBarUI.this.isTrackClickable()) {
                return false;
            }
            Container parent = DefaultScrollBarUI.this.myScrollBar.getParent();
            if (parent instanceof JScrollPane && (view = (pane = (JScrollPane)parent).getViewport().getView()) != null) {
                view.dispatchEvent(MouseEventAdapter.convert((MouseEvent)event, (Component)view));
            }
            return true;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean vertical;
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (this.redispatchIfTrackNotClickable(event)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.myCachedValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            DefaultScrollBarUI.this.myScrollBar.setValueIsAdjusting(true);
            this.myMouseX = event.getX();
            this.myMouseY = event.getY();
            boolean bl = vertical = 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation();
            if (DefaultScrollBarUI.this.isThumbContains(this.myMouseX, this.myMouseY)) {
                this.myOffset = vertical ? this.myMouseY - ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y : this.myMouseX - ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x;
                this.isDragging = true;
            } else if (DefaultScrollBarUI.this.isTrackContains(this.myMouseX, this.myMouseY)) {
                if (DefaultScrollBarUI.this.isAbsolutePositioning(event)) {
                    this.myOffset = (vertical ? ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.height : ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.width) / 2;
                    this.isDragging = true;
                    this.setValueFrom(event);
                } else {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                    this.isDragging = false;
                    if (1 == DefaultScrollBarUI.this.myScrollBar.getOrientation()) {
                        int y = DefaultScrollBarUI.this.myThumbBounds.isEmpty() ? DefaultScrollBarUI.this.myScrollBar.getHeight() / 2 : ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y;
                        this.isReversed = this.myMouseY < y;
                    } else {
                        int x = DefaultScrollBarUI.this.myThumbBounds.isEmpty() ? DefaultScrollBarUI.this.myScrollBar.getWidth() / 2 : ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x;
                        boolean bl2 = this.isReversed = this.myMouseX < x;
                        if (!DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                            this.isReversed = !this.isReversed;
                        }
                    }
                    this.scroll(this.isReversed);
                    this.startScrollTimerIfNecessary();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (this.redispatchIfTrackNotClickable(event)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.isDragging = false;
            this.myOffset = 0;
            DefaultScrollBarUI.this.myScrollTimer.stop();
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.myCachedValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            DefaultScrollBarUI.this.myScrollBar.setValueIsAdjusting(false);
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (DefaultScrollBarUI.this.myThumbBounds.isEmpty() || SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (this.isDragging) {
                this.setValueFrom(event);
            } else {
                this.myMouseX = event.getX();
                this.myMouseY = event.getY();
                this.updateMouse(this.myMouseX, this.myMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            this.redispatchIfTrackNotClickable(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouseExit();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null) {
                DefaultScrollBarUI.this.myScrollTimer.stop();
            } else {
                this.scroll(this.isReversed);
                if (!DefaultScrollBarUI.this.myThumbBounds.isEmpty() && (this.isReversed ? !this.isMouseBeforeThumb() : !this.isMouseAfterThumb())) {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                }
                int value = DefaultScrollBarUI.this.myScrollBar.getValue();
                if (this.isReversed ? value <= DefaultScrollBarUI.this.myScrollBar.getMinimum() : value >= DefaultScrollBarUI.this.myScrollBar.getMaximum() - DefaultScrollBarUI.this.myScrollBar.getVisibleAmount()) {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            DefaultScrollBarUI.this.updateThumbBounds();
            DefaultScrollBarUI.this.isValueCached = false;
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if ("model" == name) {
                BoundedRangeModel oldModel = (BoundedRangeModel)event.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)event.getNewValue();
                oldModel.removeChangeListener(this);
                newModel.addChangeListener(this);
            }
            if ("model" == name || "orientation" == name || "componentOrientation" == name) {
                DefaultScrollBarUI.this.repaint();
            }
            if ("opaque" == name || "visible" == name) {
                DefaultScrollBarUI.this.myTrackAnimator.rewind(false);
                DefaultScrollBarUI.this.myThumbAnimator.rewind(false);
                DefaultScrollBarUI.this.myTrackBounds.setBounds(0, 0, 0, 0);
                DefaultScrollBarUI.this.myThumbBounds.setBounds(0, 0, 0, 0);
            }
        }

        private void setValueFrom(MouseEvent event) {
            boolean isDefaultOrientation;
            int thumbPos;
            int thumbMin;
            int thumbMax;
            int x = event.getX();
            int y = event.getY();
            if (1 == DefaultScrollBarUI.this.myScrollBar.getOrientation()) {
                thumbMax = ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.y + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.height - ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.height;
                thumbMin = ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.y;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, y - this.myOffset));
                if (((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y != thumbPos) {
                    int minY = Math.min(((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y, thumbPos);
                    int maxY = Math.max(((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y, thumbPos) + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.height;
                    ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y = thumbPos;
                    DefaultScrollBarUI.this.onThumbMove();
                    DefaultScrollBarUI.this.repaint(((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x, minY, ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.width, maxY - minY);
                }
            } else {
                thumbMax = ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.x + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.width - ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.width;
                thumbMin = ((DefaultScrollBarUI)DefaultScrollBarUI.this).myTrackBounds.x;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, x - this.myOffset));
                if (((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x != thumbPos) {
                    int minX = Math.min(((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x, thumbPos);
                    int maxX = Math.max(((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x, thumbPos) + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.width;
                    ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x = thumbPos;
                    DefaultScrollBarUI.this.onThumbMove();
                    DefaultScrollBarUI.this.repaint(minX, ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y, maxX - minX, ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.height);
                }
            }
            int valueMin = DefaultScrollBarUI.this.myScrollBar.getMinimum();
            int valueMax = DefaultScrollBarUI.this.myScrollBar.getMaximum() - DefaultScrollBarUI.this.myScrollBar.getVisibleAmount();
            boolean bl = isDefaultOrientation = 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() || DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight();
            if (thumbPos == thumbMax) {
                DefaultScrollBarUI.this.myScrollBar.setValue(isDefaultOrientation ? valueMax : valueMin);
            } else {
                int valueRange = valueMax - valueMin;
                int thumbRange = thumbMax - thumbMin;
                int thumbValue = isDefaultOrientation ? thumbPos - thumbMin : thumbMax - thumbPos;
                DefaultScrollBarUI.this.isValueCached = true;
                DefaultScrollBarUI.this.myCachedValue = valueMin + DefaultScrollBarUI.convert(valueRange, thumbValue, thumbRange);
                DefaultScrollBarUI.this.myScrollBar.setValue(DefaultScrollBarUI.this.myCachedValue);
            }
            if (!this.isDragging) {
                this.updateMouse(x, y);
            }
        }

        private void startScrollTimerIfNecessary() {
            if (!DefaultScrollBarUI.this.myScrollTimer.isRunning() && (this.isReversed ? this.isMouseBeforeThumb() : this.isMouseAfterThumb())) {
                DefaultScrollBarUI.this.myScrollTimer.start();
            }
        }

        private boolean isMouseBeforeThumb() {
            return 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnTop() : (DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnLeft() : this.isMouseOnRight());
        }

        private boolean isMouseAfterThumb() {
            return 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnBottom() : (DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnRight() : this.isMouseOnLeft());
        }

        private boolean isMouseOnTop() {
            return this.myMouseY < ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y;
        }

        private boolean isMouseOnLeft() {
            return this.myMouseX < ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x;
        }

        private boolean isMouseOnRight() {
            return this.myMouseX > ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.x + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.width;
        }

        private boolean isMouseOnBottom() {
            return this.myMouseY > ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.y + ((DefaultScrollBarUI)DefaultScrollBarUI.this).myThumbBounds.height;
        }

        private void scroll(boolean reversed) {
            int delta = DefaultScrollBarUI.this.myScrollBar.getBlockIncrement(reversed ? -1 : 1);
            if (reversed) {
                delta = -delta;
            }
            int oldValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = DefaultScrollBarUI.this.myScrollBar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = DefaultScrollBarUI.this.myScrollBar.getMinimum();
            }
            if (oldValue != newValue) {
                DefaultScrollBarUI.this.myScrollBar.setValue(newValue);
            }
        }
    }
}

