/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WavePainter;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.ConcurrentHashMap;

public enum EffectPainter implements RegionPainter<Paint>
{
    LINE_UNDERSCORE{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (!Registry.is((String)"ide.text.effect.new")) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                g.drawLine(x, y + 1, x + width, y + 1);
            } else if (width > 0 && height > 0) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                EffectPainter.drawLineUnderscore(g, x, y, width, height, 1, (EffectPainter)this);
            }
        }
    }
    ,
    BOLD_LINE_UNDERSCORE{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (!Registry.is((String)"ide.text.effect.new")) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                int h = JBUI.scale((int)Registry.intValue((String)"editor.bold.underline.height", (int)2));
                g.fillRect(x, y, width, h);
            } else if (width > 0 && height > 0) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                EffectPainter.drawLineUnderscore(g, x, y, width, height, 2, (EffectPainter)this);
            }
        }
    }
    ,
    BOLD_DOTTED_UNDERSCORE{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (!Registry.is((String)"ide.text.effect.new")) {
                UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x, (int)(x + width), (int)(SystemInfo.isMac ? y : y + 1), (Color)g.getColor(), (Color)((Color)paint), (boolean)false);
            } else if (width > 0 && height > 0) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                EffectPainter.drawLineUnderscore(g, x, y, width, height, 2, (EffectPainter)this);
            }
        }
    }
    ,
    WAVE_UNDERSCORE{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (!Registry.is((String)"ide.text.effect.new")) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                WavePainter.forColor((Color)g.getColor()).paint(g, x, x + width, y + height);
            } else if (width > 0 && height > 0) {
                Cached.WAVE_UNDERSCORE.paint(g, x, y, width, height, paint);
            }
        }
    }
    ,
    STRIKE_THROUGH{

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (width > 0 && height > 0) {
                if (paint != null) {
                    g.setPaint(paint);
                }
                EffectPainter.drawLineCentered(g, x, y - height, width, height, 1, (EffectPainter)this);
            }
        }
    };


    private static int getMaxHeight(int height) {
        return height > 7 && Registry.is((String)"ide.text.effect.new.scale") ? height >> 1 : 3;
    }

    private static void drawLineUnderscore(Graphics2D g, int x, int y, int width, int height, int thickness, EffectPainter painter) {
        if (height > 3) {
            int max = EffectPainter.getMaxHeight(height);
            y += height - max;
            height = max;
            if (thickness > 1 && height > 3) {
                thickness = JBUI.scale((int)thickness);
            }
        }
        EffectPainter.drawLineCentered(g, x, y, width, height, thickness, painter);
    }

    private static void drawLineCentered(Graphics2D g, int x, int y, int width, int height, int thickness, EffectPainter painter) {
        int offset = height - thickness;
        if (offset > 0) {
            y += offset - (offset >> 1);
            height = thickness;
        }
        if (painter == BOLD_DOTTED_UNDERSCORE) {
            int dx;
            int w = width + (dx = (x % height + height) % height);
            int dw = (w % height + height) % height;
            Cached.BOLD_DOTTED_UNDERSCORE.paint(g, x - dx, y, dw == 0 ? w : w - dw + height, height, null);
        } else {
            g.fillRect(x, y, width, height);
        }
    }

    private static enum Cached implements RegionPainter<Paint>
    {
        BOLD_DOTTED_UNDERSCORE{

            @Override
            int getPeriod(int height) {
                return height;
            }

            @Override
            void paintImage(Graphics2D g, int width, int height, int period) {
                Integer round = period <= 2 && !UIUtil.isRetina((Graphics2D)g) ? null : Integer.valueOf(period);
                for (int dx = 0; dx < width; dx += period + period) {
                    RectanglePainter.FILL.paint(g, dx, 0, period, period, round);
                }
            }
        }
        ,
        WAVE_UNDERSCORE{
            private final BasicStroke THIN_STROKE = new BasicStroke(0.7f);

            @Override
            int getPeriod(int height) {
                return EffectPainter.getMaxHeight(height) - 1;
            }

            @Override
            void paintImage(Graphics2D g, int width, int height, int period) {
                double dx = 0.0;
                double lower = height - 1;
                double upper = lower - (double)period;
                Path2D.Double path2 = new Path2D.Double();
                ((Path2D)path2).moveTo(dx, lower);
                if (height < 6) {
                    g.setStroke(this.THIN_STROKE);
                    while (dx < (double)width) {
                        ((Path2D)path2).lineTo(dx += (double)period, upper);
                        ((Path2D)path2).lineTo(dx += (double)period, lower);
                    }
                } else {
                    double size = (double)period / 2.0;
                    double prev = dx - size / 2.0;
                    double center = (upper + lower) / 2.0;
                    while (dx < (double)width) {
                        ((Path2D)path2).quadTo(prev += size, lower, dx += size, center);
                        ((Path2D)path2).quadTo(prev += size, upper, dx += size, upper);
                        ((Path2D)path2).quadTo(prev += size, upper, dx += size, center);
                        ((Path2D)path2).quadTo(prev += size, lower, dx += size, lower);
                    }
                }
                ((Path2D)path2).lineTo(width, lower);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.draw(path2);
            }
        };

        private final ConcurrentHashMap<Long, BufferedImage> myCache = new ConcurrentHashMap();

        abstract int getPeriod(int var1);

        abstract void paintImage(Graphics2D var1, int var2, int var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void paintImage(Graphics2D g, Paint paint, int width, int height, int period) {
            try {
                g.setPaint(paint);
                this.paintImage(g, width, height, period);
            }
            finally {
                g.dispose();
            }
        }

        BufferedImage getImage(Graphics2D g, Color color, int height) {
            Long key = (long)color.getRGB() ^ (long)height << 32;
            BufferedImage image = this.myCache.get(key);
            if (image == null || UIUtil.isRetina((Graphics2D)g) != image instanceof JBHiDPIScaledImage) {
                int period = this.getPeriod(height);
                image = UIUtil.createImageForGraphics((Graphics2D)g, (int)(period << 8), (int)height, (int)2);
                this.paintImage(image.createGraphics(), color, image.getWidth(), image.getHeight(), period);
                this.myCache.put(key, image);
            }
            return image;
        }

        BufferedImage createImage(Graphics2D g, Paint paint, int height) {
            int period = this.getPeriod(height);
            BufferedImage image = UIUtil.createImageForGraphics((Graphics2D)g, (int)(period << 1), (int)height, (int)2);
            this.paintImage(image.createGraphics(), paint, image.getWidth(), image.getHeight(), period);
            return image;
        }

        @Override
        public void paint(Graphics2D g, int x, int y, int width, int height, Paint paint) {
            if (paint == null) {
                paint = g.getPaint();
            }
            g = (Graphics2D)g.create(x, y, width, height);
            g.setComposite(AlphaComposite.SrcOver);
            BufferedImage image = paint instanceof Color ? this.getImage(g, (Color)paint, height) : this.createImage(g, paint, height);
            int period = image.getWidth(null);
            int offset = (x % period + period) % period;
            for (int dx = -offset; dx < width; dx += period) {
                UIUtil.drawImage((Graphics)g, (Image)image, (int)dx, (int)0, null);
            }
            g.dispose();
        }
    }
}

