/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromise$WhenMappings;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.CompoundConsumer;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006H\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0006H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u0000H\u0016J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0016JB\u0010\u001e\u001a\f\u0012\u0006\b\u0000\u0012\u0002H\u0001\u0018\u00010\u0006\"\u0004\b\u0001\u0010\u00012\u0010\u0010\u001f\u001a\f\u0012\u0006\b\u0000\u0012\u0002H\u0001\u0018\u00010\u00062\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u00010\u00062\u0006\u0010!\u001a\u00020\rH\u0002J\u0015\u0010\"\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010#J,\u0010$\u001a\b\u0012\u0004\u0012\u0002H%0\u0002\"\u0004\b\u0001\u0010%2\u0016\u0010\u0019\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u0002H%0&H\u0016J0\u0010'\u001a\b\u0012\u0004\u0012\u0002H%0\u0002\"\u0004\b\u0001\u0010%2\u001a\u0010\u0019\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H%0\u00020&H\u0016R\u001c\u0010\u0005\u001a\f\u0012\u0006\b\u0000\u0012\u00028\u0000\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\f\u0012\u0006\b\u0000\u0012\u00020\b\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/concurrency/AsyncPromise;", "T", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/util/Getter;", "()V", "done", "Lcom/intellij/util/Consumer;", "rejected", "", "result", "", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/concurrency/Promise$State;", "kotlin.jvm.PlatformType", "addHandlers", "", "cancel", "clearHandlers", "get", "()Ljava/lang/Object;", "getState", "notify", "child", "processed", "fulfilled", "setError", "", "error", "", "setHandler", "oldConsumer", "newConsumer", "targetState", "setResult", "(Ljava/lang/Object;)V", "then", "SUB_RESULT", "Lcom/intellij/util/Function;", "thenAsync", "projectModel-api"})
public class AsyncPromise<T>
extends Promise<T>
implements Getter<T> {
    private volatile Consumer<? super T> done;
    private volatile Consumer<? super Throwable> rejected;
    private final AtomicReference<Promise.State> state = new AtomicReference<Promise.State>(Promise.State.PENDING);
    private volatile Object result;

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        return state;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done2) {
        Intrinsics.checkParameterIsNotNull(done2, (String)"done");
        if (AsyncPromiseKt.isObsolete(done2)) {
            return this;
        }
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                this.done = this.setHandler(this.done, done2, Promise.State.FULFILLED);
                break;
            }
            case 2: {
                done2.consume(this.result);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        Intrinsics.checkParameterIsNotNull(rejected2, (String)"rejected");
        if (AsyncPromiseKt.isObsolete(rejected2)) {
            return this;
        }
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
            case 1: {
                this.rejected = this.setHandler(this.rejected, rejected2, Promise.State.REJECTED);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                rejected2.consume((Object)((Throwable)this.result));
            }
        }
        return this;
    }

    @Nullable
    public T get() {
        return (T)(Intrinsics.areEqual((Object)((Object)this.state.get()), (Object)((Object)Promise.State.FULFILLED)) ? this.result : null);
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> fulfilled) {
        Intrinsics.checkParameterIsNotNull(fulfilled, (String)"fulfilled");
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$2[state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                return new DonePromise<Object>(fulfilled.fun(this.result));
            }
            case 3: {
                Object object = this.result;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return AsyncPromiseKt.rejectedPromise((Throwable)object);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        this.addHandlers((Consumer)new Consumer<T>(promise, fulfilled){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $fulfilled;

            public final void consume(T result) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    if (this.$fulfilled instanceof Obsolescent && ((Obsolescent)this.$fulfilled).isObsolete()) {
                        this.$promise.cancel();
                    } else {
                        this.$promise.setResult(this.$fulfilled.fun(result));
                    }
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$fulfilled = function;
            }
        }, (Consumer<Throwable>)((Consumer)new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        }));
        return promise;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        Intrinsics.checkParameterIsNotNull(child, (String)"child");
        AsyncPromiseKt.access$getLOG$p().assertTrue(child != this);
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$3[state.ordinal()]) {
            case 1: {
                this.addHandlers((Consumer)new Consumer<T>(child){
                    final /* synthetic */ AsyncPromise $child;

                    public final void consume(T it) {
                        AsyncPromise $receiver$iv = this.$child;
                        try {
                            this.$child.setResult(it);
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv.setError(e$iv);
                        }
                    }
                    {
                        this.$child = asyncPromise;
                    }
                }, (Consumer<Throwable>)((Consumer)new Consumer<Throwable>(child){
                    final /* synthetic */ AsyncPromise $child;

                    public final void consume(Throwable it) {
                        Throwable throwable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                        this.$child.setError(throwable);
                    }
                    {
                        this.$child = asyncPromise;
                    }
                }));
                break;
            }
            case 2: {
                child.setResult(this.result);
                break;
            }
            case 3: {
                Throwable throwable = (Throwable)this.result;
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                child.setError(throwable);
            }
        }
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> fulfilled) {
        Intrinsics.checkParameterIsNotNull(fulfilled, (String)"fulfilled");
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$4[state.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Promise promise = (Promise)fulfilled.fun(this.result);
                Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"fulfilled.`fun`(result as T?)");
                return promise;
            }
            case 3: {
                Object object = this.result;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
                }
                return AsyncPromiseKt.rejectedPromise((Throwable)object);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        AsyncPromise<T> promise = new AsyncPromise<T>();
        Consumer rejectedHandler2 = (Consumer)new Consumer<Throwable>(promise){
            final /* synthetic */ AsyncPromise $promise;

            public final void consume(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                this.$promise.setError(throwable);
            }
            {
                this.$promise = asyncPromise;
            }
        };
        this.addHandlers((Consumer)new Consumer<T>(promise, fulfilled, rejectedHandler2){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Function $fulfilled;
            final /* synthetic */ Consumer $rejectedHandler;

            public final void consume(T it) {
                AsyncPromise $receiver$iv = this.$promise;
                try {
                    ((Promise)this.$fulfilled.fun(it)).done((Consumer)new Consumer<SUB_RESULT>(this, it){
                        final /* synthetic */ thenAsync.1 this$0;
                        final /* synthetic */ Object $it$inlined;

                        public final void consume(SUB_RESULT it) {
                            AsyncPromise $receiver$iv = this.this$0.$promise;
                            try {
                                this.this$0.$promise.setResult(it);
                            }
                            catch (Throwable e$iv) {
                                $receiver$iv.setError(e$iv);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$it$inlined = object;
                        }
                    }).rejected((Consumer<Throwable>)this.$rejectedHandler);
                }
                catch (Throwable e$iv) {
                    $receiver$iv.setError(e$iv);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$fulfilled = function;
                this.$rejectedHandler = consumer;
            }
        }, (Consumer<Throwable>)rejectedHandler2);
        return promise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        Intrinsics.checkParameterIsNotNull(fulfilled, (String)"fulfilled");
        Promise.State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (AsyncPromise$WhenMappings.$EnumSwitchMapping$5[state.ordinal()]) {
            case 1: {
                this.addHandlers((Consumer)new Consumer<T>(fulfilled){
                    final /* synthetic */ AsyncPromise $fulfilled;

                    public final void consume(T result) {
                        AsyncPromise $receiver$iv = this.$fulfilled;
                        try {
                            this.$fulfilled.setResult(result);
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv.setError(e$iv);
                        }
                    }
                    {
                        this.$fulfilled = asyncPromise;
                    }
                }, (Consumer<Throwable>)((Consumer)new Consumer<Throwable>(fulfilled){
                    final /* synthetic */ AsyncPromise $fulfilled;

                    public final void consume(Throwable it) {
                        Throwable throwable = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                        this.$fulfilled.setError(throwable);
                    }
                    {
                        this.$fulfilled = asyncPromise;
                    }
                }));
                break;
            }
            case 2: {
                fulfilled.setResult(this.result);
                break;
            }
            case 3: {
                Throwable throwable = (Throwable)this.result;
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                fulfilled.setError(throwable);
            }
        }
        return this;
    }

    private final void addHandlers(Consumer<T> done2, Consumer<Throwable> rejected2) {
        this.done = this.setHandler(this.done, done2, Promise.State.FULFILLED);
        this.rejected = this.setHandler(this.rejected, rejected2, Promise.State.REJECTED);
    }

    public final void setResult(@Nullable T result) {
        if (!this.state.compareAndSet(Promise.State.PENDING, Promise.State.FULFILLED)) {
            return;
        }
        this.result = result;
        Consumer<? super T> done2 = this.done;
        this.clearHandlers();
        if (done2 != null && !AsyncPromiseKt.isObsolete(done2)) {
            done2.consume(result);
        }
    }

    public final boolean setError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        Throwable throwable = Promise.createError(error);
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"Promise.createError(error)");
        return this.setError(throwable);
    }

    public final void cancel() {
        Throwable throwable = AsyncPromiseKt.access$getOBSOLETE_ERROR$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"OBSOLETE_ERROR");
        this.setError(throwable);
    }

    public boolean setError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        if (!this.state.compareAndSet(Promise.State.PENDING, Promise.State.REJECTED)) {
            return false;
        }
        this.result = error;
        Consumer<? super Throwable> rejected2 = this.rejected;
        this.clearHandlers();
        if (rejected2 == null) {
            Promise.logError(AsyncPromiseKt.access$getLOG$p(), error);
        } else if (!AsyncPromiseKt.isObsolete(rejected2)) {
            rejected2.consume((Object)error);
        }
        return true;
    }

    private final void clearHandlers() {
        this.done = null;
        this.rejected = null;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Consumer<? super T> processed2) {
        Intrinsics.checkParameterIsNotNull(processed2, (String)"processed");
        this.done(processed2);
        this.rejected((Consumer<Throwable>)((Consumer)new Consumer<Throwable>(processed2){
            final /* synthetic */ Consumer $processed;

            public final void consume(Throwable it) {
                this.$processed.consume(null);
            }
            {
                this.$processed = consumer;
            }
        }));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> Consumer<? super T> setHandler(Consumer<? super T> oldConsumer, Consumer<? super T> newConsumer, Promise.State targetState) {
        Consumer consumer;
        Consumer<? super T> consumer2 = oldConsumer;
        if (Intrinsics.areEqual(consumer2, null)) {
            consumer = newConsumer;
        } else {
            if (consumer2 instanceof CompoundConsumer) {
                Consumer<? super T> consumer3 = oldConsumer;
                if (consumer3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.CompoundConsumer<T>");
                }
                CompoundConsumer compoundConsumer = (CompoundConsumer)consumer3;
                synchronized (compoundConsumer) {
                    List it;
                    block9: {
                        List list = compoundConsumer.getConsumers();
                        it = list;
                        if (it != null) break block9;
                        if (Intrinsics.areEqual((Object)((Object)this.state.get()), (Object)((Object)targetState))) {
                            newConsumer.consume(this.result);
                        }
                        Consumer consumer4 = null;
                        return consumer4;
                    }
                    it.add(newConsumer);
                    Consumer consumer5 = compoundConsumer;
                    return consumer5;
                }
            }
            consumer = new CompoundConsumer<T>(oldConsumer, newConsumer);
        }
        return consumer;
    }
}

