/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CountDownConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u0012\u0012\u000e\b\u0001\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u00012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0005\u001a3\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u00062\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\b\u001a.\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0001\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0001\u001a,\u0010\f\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u0001H\u0006H\u00060\u0001\u00a2\u0006\u0002\b\r\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u000e\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"all", "Lorg/jetbrains/concurrency/Promise;", "", "kotlin.jvm.PlatformType", "promises", "", "T", "totalResult", "(Ljava/util/Collection;Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "any", "totalError", "", "resolvedPromise", "Lorg/jetbrains/annotations/NotNull;", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "projectModel-api"})
@JvmName(name="Promises")
public final class Promises {
    @NotNull
    public static final Promise<?> resolvedPromise() {
        Promise<Void> promise = Promise.DONE;
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"Promise.DONE");
        return promise;
    }

    @NotNull
    public static final <T> Promise<T> resolvedPromise(T result) {
        return Promise.resolve(result);
    }

    @NotNull
    public static final Promise<? extends Object> all(@NotNull Collection<? extends Promise<?>> promises) {
        Intrinsics.checkParameterIsNotNull(promises, (String)"promises");
        return promises.size() == 1 ? (Promise)CollectionsKt.first((Iterable)promises) : Promises.all(promises, null);
    }

    @NotNull
    public static final <T> Promise<T> all(@NotNull Collection<? extends Promise<?>> promises, @Nullable T totalResult) {
        Intrinsics.checkParameterIsNotNull(promises, (String)"promises");
        if (promises.isEmpty()) {
            Promise<Object> promise = Promises.resolvedPromise(null);
            Intrinsics.checkExpressionValueIsNotNull(promise, (String)"resolvedPromise(null)");
            return promise;
        }
        AsyncPromise totalPromise = new AsyncPromise();
        CountDownConsumer done2 = new CountDownConsumer(promises.size(), totalPromise, totalResult);
        Consumer rejected2 = (Consumer)new Consumer<Throwable>(totalPromise){
            final /* synthetic */ AsyncPromise $totalPromise;

            public final void consume(Throwable error) {
                Throwable throwable = error;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"error");
                this.$totalPromise.setError(throwable);
            }
            {
                this.$totalPromise = asyncPromise;
            }
        };
        for (Promise<?> promise : promises) {
            promise.done(done2);
            promise.rejected((Consumer<Throwable>)rejected2);
        }
        return totalPromise;
    }

    @NotNull
    public static final <T> Promise<T> any(@NotNull Collection<? extends Promise<T>> promises, @NotNull String totalError) {
        Intrinsics.checkParameterIsNotNull(promises, (String)"promises");
        Intrinsics.checkParameterIsNotNull((Object)totalError, (String)"totalError");
        if (promises.isEmpty()) {
            Promise<Object> promise = Promises.resolvedPromise(null);
            Intrinsics.checkExpressionValueIsNotNull(promise, (String)"resolvedPromise(null)");
            return promise;
        }
        if (promises.size() == 1) {
            return (Promise)CollectionsKt.first((Iterable)promises);
        }
        AsyncPromise totalPromise = new AsyncPromise();
        Consumer done2 = new Consumer<T>(totalPromise){
            final /* synthetic */ AsyncPromise $totalPromise;

            public final void consume(T result) {
                this.$totalPromise.setResult(result);
            }
            {
                this.$totalPromise = asyncPromise;
            }
        };
        Consumer<Throwable> rejected2 = new Consumer<Throwable>(totalPromise, totalError, promises){
            private volatile int toConsume;
            final /* synthetic */ AsyncPromise $totalPromise;
            final /* synthetic */ String $totalError;
            final /* synthetic */ Collection $promises;

            public void consume(@NotNull Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                any.rejected.1 v0 = this;
                v0.toConsume += -1;
                if (v0.toConsume <= 0) {
                    this.$totalPromise.setError(this.$totalError);
                }
            }
            {
                this.$totalPromise = $captured_local_variable$0;
                this.$totalError = $captured_local_variable$1;
                this.$promises = $captured_local_variable$2;
                this.toConsume = $captured_local_variable$2.size();
            }
        };
        for (Promise<T> promise : promises) {
            promise.done(done2);
            promise.rejected((Consumer<Throwable>)((Consumer)rejected2));
        }
        return totalPromise;
    }
}

