/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.CharSequenceBackedByChars;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u00a8\u0006\b"}, d2={"readCharSequence", "", "Ljava/io/InputStreamReader;", "length", "", "toByteArray", "", "Ljava/nio/ByteBuffer;", "platform-api"})
public final class UtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader $receiver, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Closeable closeable = $receiver;
        boolean bl = false;
        try {
            int count;
            int n;
            InputStreamReader it = (InputStreamReader)closeable;
            char[] chars = new char[length];
            for (count = 0; count < chars.length && (n = $receiver.read(chars, count, chars.length - count)) > 0; count += n) {
            }
            CharSequence charSequence = (CharSequence)((Object)new CharSequenceBackedByChars(chars, 0, count));
            return charSequence;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.hasArray()) {
            int offset = $receiver.arrayOffset();
            if (offset == 0 && $receiver.array().length == $receiver.limit()) {
                byte[] byArray = $receiver.array();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"array()");
                return byArray;
            }
            byte[] byArray = Arrays.copyOfRange($receiver.array(), offset, offset + $receiver.limit());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOfRange(array\u2026offset, offset + limit())");
            return byArray;
        }
        byte[] bytes = new byte[$receiver.limit()];
        $receiver.get(bytes);
        return bytes;
    }
}

