/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Named;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

enum Modifier implements Named
{
    PUBLIC("public"),
    PRIVATE("private"),
    PROTECTED("protected"),
    STATIC("static"),
    FINAL("final"),
    SYNCHRONIZED("synchronized"),
    ABSTRACT("abstract"),
    SYNTHETIC("synthetic"),
    BRIDGE("bridge");

    private static final Map<String, Modifier> NAME_TO_MODIFIER;
    private String myName;

    private Modifier(String name) {
        this.myName = name;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public String toString() {
        return this.getName();
    }

    static Modifier parse(String name) {
        Modifier modifier = NAME_TO_MODIFIER.get(name);
        if (modifier == null) {
            throw new IllegalArgumentException("Unknown modifier: " + name);
        }
        return modifier;
    }

    static {
        NAME_TO_MODIFIER = Arrays.stream(Modifier.values()).collect(Collectors.toMap(Named::getName, Function.identity()));
    }
}

