/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.unscramble.UnscrambleSupport;
import com.intellij.zkm.bytecode.BytecodeImpl;
import com.intellij.zkm.bytecode.Changelog;
import com.intellij.zkm.bytecode.ChangelogReader;
import com.intellij.zkm.bytecode.ClassProvider;
import com.intellij.zkm.bytecode.InvocationReaderImpl;
import com.intellij.zkm.bytecode.JarArchive;
import com.intellij.zkm.bytecode.ProjectClasses;
import com.intellij.zkm.bytecode.SignatureReaderImpl;
import com.intellij.zkm.bytecode.TranslationException;
import com.intellij.zkm.bytecode.TranslatorImpl;
import com.intellij.zkm.bytecode.TypeFactoryImpl;
import com.intellij.zkm.bytecode.UnscramblingSettings;
import com.intellij.zkm.bytecode.ZKMBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZKMBytecodeUnscrambleSupport
implements UnscrambleSupport<UnscramblingSettings> {
    @NotNull
    public String getPresentableName() {
        String string = ZKMBundle.message("zkm.scrambler.presentable.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public UnscramblingSettings createSettingsComponent() {
        return new UnscramblingSettings();
    }

    @Nullable
    public String unscramble(@NotNull Project project, @NotNull String text, @NotNull String logName, UnscramblingSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "unscramble"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "unscramble"));
        }
        if (logName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logName", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "unscramble"));
        }
        String bytecodeFilePath = settings.getSelectedJarFilePath();
        try {
            TranslatorImpl translator = ZKMBytecodeUnscrambleSupport.createTranslator(new File(logName), bytecodeFilePath == null ? null : new File(bytecodeFilePath), project);
            return translator.translate(text);
        }
        catch (TranslationException | IOException e) {
            Messages.showMessageDialog((Project)project, (String)(e.getMessage() + "\n" + e.toString()), (String)ZKMBundle.message("zkm.error.unscrambling.stacktrace", new Object[0]), (Icon)Messages.getErrorIcon());
            return null;
        }
    }

    @NotNull
    private static TranslatorImpl createTranslator(@NotNull File logFile, @Nullable File bytecodeFile, @NotNull Project project) throws IOException {
        Changelog changelog;
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "createTranslator"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "createTranslator"));
        }
        TypeFactoryImpl typeFactory = new TypeFactoryImpl();
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            changelog = new ChangelogReader(typeFactory).read(reader);
        }
        ClassProvider classProvider = bytecodeFile == null ? new ProjectClasses(project) : new JarArchive(bytecodeFile);
        BytecodeImpl bytecode = new BytecodeImpl(classProvider, new SignatureReaderImpl(typeFactory), new InvocationReaderImpl(typeFactory));
        TranslatorImpl translatorImpl = new TranslatorImpl(changelog, bytecode);
        if (translatorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/ZKMBytecodeUnscrambleSupport", "createTranslator"));
        }
        return translatorImpl;
    }
}

