/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.css.CSSParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.lexer.LESSLexer;
import org.jetbrains.plugins.less.parser.LESSParser;
import org.jetbrains.plugins.less.psi.impl.LESSFileImpl;

public class LESSParserDefinition
extends CSSParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        LESSLexer lESSLexer = new LESSLexer();
        if (lESSLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/parser/LESSParserDefinition", "createLexer"));
        }
        return lESSLexer;
    }

    public IFileElementType getFileNodeType() {
        return LESSElementTypes.LESS_FILE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = LESSElementTypes.LESS_COMMENTS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/parser/LESSParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new LESSFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                ASTNode aSTNode = new LESSParser(builder).parse(root);
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/parser/LESSParserDefinition$1", "parse"));
                }
                return aSTNode;
            }
        };
        if (psiParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/parser/LESSParserDefinition", "createParser"));
        }
        return psiParser;
    }
}

