/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.SynchronizeHandler;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SynchronizeSchemaAction
extends AnAction
implements DumbAware {
    public SynchronizeSchemaAction() {
        super("Synchronize", null, PlatformIcons.SYNCHRONIZE_ICON);
    }

    public void update(AnActionEvent e) {
        boolean enabled;
        JBIterable selection = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
        boolean visible = enabled = !selection.isEmpty();
        for (DbElement o : selection) {
            DatabaseSystem delegate = o.getDataSource().getDelegate();
            visible &= delegate instanceof LocalDataSource;
            enabled &= DbImplUtil.canConnectTo(o);
        }
        e.getPresentation().setVisible(visible || ActionPlaces.isToolbarPlace((String)e.getPlace()));
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        JBIterable selection = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filter(DbElement.class);
        Map map = ContainerUtil.classify((Iterator)selection.iterator(), (Convertor)new Convertor<DbElement, DbDataSource>(){

            public DbDataSource convert(DbElement o) {
                return o.getDataSource();
            }
        });
        HashSet dataSourceElements = new HashSet();
        dataSourceElements.addAll(map.keySet());
        Project project = e.getProject();
        if (project != null) {
            for (SynchronizeHandler handler : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
                handler.synchronizationStarted(project, (Set)dataSourceElements);
            }
        }
        for (DbDataSource element : dataSourceElements) {
            Set elements = (Set)map.get(element);
            if (elements.contains(element) && elements.size() > 1) {
                elements.retainAll(Collections.singletonList(element));
            }
            SynchronizeSchemaAction.refresh(element, elements);
        }
    }

    private static void refresh(DbDataSource element, Collection<DbElement> selection) {
        DatabaseSystem delegate = element.getDelegate();
        if (!(delegate instanceof LocalDataSource)) {
            return;
        }
        LocalDataSource dataSource = (LocalDataSource)delegate;
        LoaderContext context = SynchronizeSchemaAction.createLoaderContext(element, selection, dataSource);
        DataSourceUiUtil.performManualSyncTask(element.getProject(), context);
    }

    static LoaderContext createLoaderContext(@NotNull DbDataSource dataSourceElement, @NotNull Collection<? extends DbElement> selection, @NotNull LocalDataSource dataSource) {
        if (dataSourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceElement", "com/intellij/database/actions/SynchronizeSchemaAction", "createLoaderContext"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/actions/SynchronizeSchemaAction", "createLoaderContext"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/SynchronizeSchemaAction", "createLoaderContext"));
        }
        LoaderContext context = new LoaderContext(dataSource);
        boolean loadEverything = selection.contains(dataSourceElement);
        if (loadEverything) {
            context.includeAllSchemas().includeAllEntities();
        }
        if (selection.size() > 1 || !loadEverything) {
            for (DbElement dbElement : selection) {
                if (dbElement == dataSourceElement || dbElement.getDataSource() != dataSourceElement) continue;
                DbElement parent = dbElement.getDbParent();
                if (parent instanceof DbTable) {
                    context.include(parent);
                    continue;
                }
                if (dbElement instanceof DbPackage) {
                    context.include(parent).includeProcedures();
                    continue;
                }
                if (dbElement instanceof DasNamespace) {
                    context.include(dbElement).includeAllEntities();
                    continue;
                }
                context.include(dbElement);
            }
        }
        return context;
    }
}

