/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.settings.DatabaseSettingsConfigurable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.dbm.db2.Db2Model;
import com.intellij.dbm.derby.DerbyModel;
import com.intellij.dbm.factories.RdbmsDefinition;
import com.intellij.dbm.factories.RdbmsRegistry;
import com.intellij.dbm.hsqldb.HsqldbModel;
import com.intellij.dbm.sqlite.SqliteModel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.UI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.SyncDateFormat;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;

public class DataSourceUiUtil {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.DataSourceUiUtil");
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    private DataSourceUiUtil() {
    }

    @Nullable
    public static Rdbms getRdbmsForIntrospection(@Nullable DatabaseFamilyId familyId) {
        boolean useNative;
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        boolean bl = useNative = Registry.is((String)"database.native.loading") || testMode;
        if (!useNative) {
            return null;
        }
        if (familyId == DatabaseFamilyId.ORACLE) {
            return Oracle.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MYSQL) {
            return Mysql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.POSTGRES) {
            return Postgres.RDBMS;
        }
        if (familyId == DatabaseFamilyId.MSSQL) {
            return Mssql.RDBMS;
        }
        if (familyId == DatabaseFamilyId.SYBASE) {
            return Sybase.RDBMS;
        }
        if (familyId == DatabaseFamilyId.DB2) {
            return Db2Model.RDBMS;
        }
        if (familyId == DatabaseFamilyId.DERBY) {
            return DerbyModel.RDBMS;
        }
        if (familyId == DatabaseFamilyId.H2) {
            return H2db.RDBMS;
        }
        if (familyId == DatabaseFamilyId.HSQLDB) {
            return HsqldbModel.RDBMS;
        }
        if (familyId == DatabaseFamilyId.SQLITE) {
            return SqliteModel.RDBMS;
        }
        return null;
    }

    public static boolean supportedByModernIntrospector(@Nullable Rdbms rdbms) {
        if (rdbms == null) {
            return false;
        }
        RdbmsDefinition def = RdbmsRegistry.instance().findDefinitionByRdbms(rdbms);
        return def != null && def.introspectorClass != DBIntrospector.class;
    }

    public static boolean hasModernIntrospector(@Nullable DatabaseFamilyId familyId) {
        return DataSourceUiUtil.supportedByModernIntrospector(DataSourceUiUtil.getRdbmsForIntrospection(familyId));
    }

    public static void performAutoSyncTask(Project project, LocalDataSource dataSource) {
        if (!DbImplUtil.canConnectTo(dataSource) || !dataSource.isAutoSynchronize()) {
            return;
        }
        new RefreshTask(project, LoaderContext.loadAll(dataSource), false){

            @Override
            protected void onTaskCompleted(LoaderContext context, long elapsedTime) {
                if (context.getErrorHandler().hasErrors()) {
                    this.showNotification(context, elapsedTime);
                }
            }
        }.perform();
    }

    @NotNull
    public static ActionCallback performManualSyncTask(Project project, LoaderContext context) {
        ActionCallback actionCallback = new RefreshTask(project, context, false){

            @Override
            protected void onTaskCompleted(LoaderContext context, long elapsedTime) {
                this.showNotification(context, elapsedTime);
            }
        }.perform();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "performManualSyncTask"));
        }
        return actionCallback;
    }

    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        String string = MessageFormat.format("Database: {0} (ver. {1})\nIdentifier case sensitivity: {5} (plain), {6} (delimited)\nDriver (JDBC{4}): {2} (ver. {3})", o.getDatabaseProductName(), o.getDatabaseProductVersion(), o.getDriverName(), o.getDriverVersion(), o.getJDBCVersion(), Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "formatDataSourceInfoString"));
        }
        return string;
    }

    public static boolean isMsSql2008(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionString", "com/intellij/database/dataSource/DataSourceUiUtil", "isMsSql2008"));
        }
        Version version = Version.parseVersion((String)versionString);
        return version == null || version.major > 10 || version.major == 10 && version.minor >= 50;
    }

    public static void showNotification(@Nullable Project project, String title, String message, boolean error) {
        final Pair<String, HyperlinkListener> pair = DataSourceUiUtil.truncatePopupMessageIfNeeded(message, error ? DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]) : title, error ? Messages.getErrorIcon() : Messages.getInformationIcon());
        NotificationGroup group = error ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group.createNotification(title, (String)pair.first, error ? NotificationType.WARNING : NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/dataSource/DataSourceUiUtil$3", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dataSource/DataSourceUiUtil$3", "hyperlinkUpdate"));
                }
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }
        }).notify(project);
    }

    public static Pair<String, HyperlinkListener> truncatePopupMessageIfNeeded(String text, final String dialogTitle, final Icon icon) {
        boolean truncate;
        boolean bl = truncate = text.length() > 120;
        if (!truncate) {
            return Pair.create((Object)text, null);
        }
        String balloonMessage = text.substring(0, 120) + " ... <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        final String message = text.replace("\t", "  ");
        return Pair.create((Object)balloonMessage, (Object)new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Messages.showIdeaMessageDialog(null, (String)message, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
                }
            }
        });
    }

    public static void showErrorBalloon(Throwable error, Component component, Point point, boolean showArrow, boolean showConfig) {
        if (!component.isVisible() || !component.isShowing()) {
            return;
        }
        String errorText = StringUtil.notNullize((String)error.getMessage(), (String)error.getClass().getSimpleName());
        errorText = DataSourceUiUtil.wrap(errorText, 50, "\n", true);
        errorText = StringUtil.trimLog((String)errorText, (int)200);
        errorText = StringUtil.trimTrailing((String)errorText);
        final String errorFullText = ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij.");
        String imgURL = "";
        URL resource = AllIcons.class.getClassLoader().getResource("/general/settings.png");
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String detailsLinkMessage = " <a href=\"more\">" + DatabaseMessages.message((String)"message.hyperlink.click.for.more", (Object[])new Object[0]) + "</a>";
        String balloonContent = showConfig ? "<table border=0 cellspacing=0 cellpadding=0><tr valign=top><td>" + errorText + detailsLinkMessage + "</td><td align=right>&nbsp;&nbsp;<a href=\"config\"><img alt=\"Disable error balloons\" hspace=0 vspace=0 border=0 width=16 height=16 src=\"" + imgURL + "\"></a></td></tr></table>" : errorText + detailsLinkMessage;
        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if ("more".equals(e.getDescription())) {
                        Messages.showIdeaMessageDialog(null, (String)errorFullText, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
                    } else if ("config".equals(e.getDescription())) {
                        ShowSettingsUtilImpl.showSettingsDialog(null, (String)DatabaseSettingsConfigurable.CONFIGURABLE_ID, (String)"");
                    }
                }
            }
        };
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(balloonContent, MessageType.ERROR, hyperlinkListener).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceUiUtil$6", "actionPerformed"));
                }
            }
        }, true).setShowCallout(showArrow).setHideOnAction(true).setHideOnClickOutside(true);
        Balloon balloon = builder.createBalloon();
        balloon.show(new RelativePoint(component, point), Balloon.Position.below);
    }

    public static String wrap(@NotNull String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/dataSource/DataSourceUiUtil", "wrap"));
        }
        if (newLineStr == null) {
            newLineStr = "\n";
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str.length();
        int offset = 0;
        StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str.substring(offset));
        return wrappedLine.toString();
    }

    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "currentTime"));
        }
        return string;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable DatabaseSystem database) throws PatternSyntaxException {
        DatabaseSystem delegate = database instanceof DbElement ? ((DbElement)database).getDelegate() : database;
        String filterText = delegate instanceof AbstractDataSource ? ((AbstractDataSource)delegate).getTablePattern() : null;
        Condition<DasObject> condition = DataSourceUiUtil.buildObjectFilter(filterText);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
        }
        return condition;
    }

    @NotNull
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        THashMap map = ContainerUtil.newTroveMap();
        for (String s : StringUtil.split((String)filterText, (String)"||")) {
            ObjectKind kind;
            String part = s.trim();
            if (part.length() == 0) continue;
            int idx = part.indexOf(58);
            boolean exclude = part.charAt(idx + 1) == '-';
            String patternText = part.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == part.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = part.substring(0, idx);
                ObjectKind objectKind = Comparing.strEqual((String)k, (String)"table") ? ObjectKind.TABLE : (Comparing.strEqual((String)k, (String)"view") ? ObjectKind.VIEW : (Comparing.strEqual((String)k, (String)"mview") ? ObjectKind.MAT_VIEW : (Comparing.strEqual((String)k, (String)"routine") ? ObjectKind.ROUTINE : (Comparing.strEqual((String)k, (String)"package") ? ObjectKind.PACKAGE : (Comparing.strEqual((String)k, (String)"sequence") ? ObjectKind.SEQUENCE : (kind = Comparing.strEqual((String)k, (String)"synonym") ? ObjectKind.SYNONYM : ObjectKind.NONE))))));
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = part;
                }
            }
            Couple prev = (Couple)map.get(kind);
            Pattern pattern = Pattern.compile("(?i)" + patternText);
            Condition c = s1 -> pattern.matcher((CharSequence)s1).matches();
            Couple next = prev == null ? Couple.of((Object)(exclude ? null : c), (Object)(!exclude ? null : c)) : Couple.of((Object)(exclude ? (Condition)prev.first : (prev.first == null ? c : Conditions.or2((Condition)((Condition)prev.first), (Condition)c))), (Object)(!exclude ? (Condition)prev.second : (prev.second == null ? c : Conditions.or2((Condition)((Condition)prev.second), (Condition)c))));
            map.put(kind, next);
        }
        if (map.size() == 1 && ContainerUtil.getFirstItem(map.keySet()) == ObjectKind.NONE) {
            Couple couple = (Couple)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(map.values()));
            Condition first = (Condition)ObjectUtils.notNull((Object)couple.first, (Object)Conditions.alwaysTrue());
            Condition second = (Condition)ObjectUtils.notNull((Object)couple.second, (Object)Conditions.alwaysFalse());
            Condition condition = Conditions.compose((Function)DasUtil.TO_NAME, (Condition)Conditions.and((Condition)first, (Condition)Conditions.not((Condition)second)));
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
            }
            return condition;
        }
        Condition condition = arg_0 -> DataSourceUiUtil.lambda$buildObjectFilter$1((Map)map, arg_0);
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildObjectFilter"));
        }
        return condition;
    }

    public static void runAsyncWithCorrectModality(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runAsyncWithCorrectModality"));
        }
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task), null, ModalityState.current());
    }

    public static void runSynchronously(@NotNull Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/database/dataSource/DataSourceUiUtil", "runSynchronously"));
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        try {
            task.run(indicator);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            if (indicator.isCanceled()) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
    }

    @Nullable
    public static Pattern getDefaultSchemasPattern(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DataSourceUiUtil", "getDefaultSchemasPattern"));
        }
        if (scope == IntrospectionScopes.ALL_SCOPE || scope == IntrospectionScopes.EMPTY_SCOPE) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String d : scope.databases()) {
            for (String s : scope.schemas(d)) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(PatternUtil.convertToRegex((String)(d + "." + s)));
            }
        }
        return PatternUtil.compileSafe((String)sb.toString(), null);
    }

    @NotNull
    public static JBPopup buildHiddenNamespacesPopup(@NotNull DbElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DataSourceUiUtil", "buildHiddenNamespacesPopup"));
        }
        final DbDataSource dataSource = context.getDataSource();
        List<BasicNamespace> namespaces = DataSourceUiUtil.getNamespaces(DatabaseStructure.getModel((DatabaseSystem)dataSource, BasicModModel.class));
        final CollectionListModel model = new CollectionListModel(namespaces);
        final JBList list = new JBList((ListModel)model);
        list.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int[] indices = list.getSelectedIndices();
                if (indices.length > 1 || UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                    return;
                }
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                list.setSelectedIndex(index);
            }
        });
        final JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Add To View").setAutoselectOnMouseMove(false).setMovable(true).setItemChoosenCallback(() -> {
            BasicModModel basicModel = DatabaseStructure.getModel((DatabaseSystem)dataSource, BasicModModel.class);
            if (basicModel != null) {
                DataSourceUiUtil.setNamespacesVisible(dataSource, basicModel, JBIterable.from((Iterable)list.getSelectedValuesList()).filter(BasicNamespace.class).toList());
            }
        }).createPopup();
        list.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter<BasicNamespace>(){

            public Icon getIconFor(BasicNamespace value) {
                return DbPresentation.getIcon((DasObject)value);
            }

            @NotNull
            public String getTextFor(@NotNull BasicNamespace value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/DataSourceUiUtil$8", "getTextFor"));
                }
                BasicElement parent = value.getDbParent();
                String string = parent != null && parent instanceof BasicNamedElement && parent.getKind() != ObjectKind.ROOT ? parent.getName() + "\u2006.\u2006" + value.getName() : value.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$8", "getTextFor"));
                }
                return string;
            }
        }));
        final LocalDataSource local = DatabaseStructure.getLocalDataSource((DatabaseSystem)dataSource);
        final Project project = context.getProject();
        if (local != null) {
            new Task.Backgroundable(context.getProject(), "Updating Schemas List", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceUiUtil$9", "run"));
                    }
                    if (project.isDisposed() || popup.isDisposed()) {
                        return;
                    }
                    try {
                        list.setPaintBusy(true);
                        local.refreshMetaData(project, new LoaderContext(local).setNamespacesOnly(true));
                    }
                    finally {
                        list.setPaintBusy(false);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        HashSet selected = ContainerUtil.newHashSet((Iterable)list.getSelectedValuesList());
                        model.replaceAll(DataSourceUiUtil.getNamespaces(DatabaseStructure.getModel((DatabaseSystem)dataSource, BasicModModel.class)));
                        ListSelectionModel selectionModel = list.getSelectionModel();
                        selectionModel.clearSelection();
                        for (int i = 0; i < model.getSize(); ++i) {
                            if (!selected.contains(model.getElementAt(i))) continue;
                            selectionModel.addSelectionInterval(i, i);
                        }
                        popup.pack(true, true);
                    }, ModalityState.current(), x -> project.isDisposed() || popup.isDisposed());
                }
            }.queue();
        }
        JBPopup jBPopup = popup;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "buildHiddenNamespacesPopup"));
        }
        return jBPopup;
    }

    @NotNull
    private static List<BasicNamespace> getNamespaces(@Nullable BasicModModel model) {
        if (model == null) {
            List<BasicNamespace> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "getNamespaces"));
            }
            return list;
        }
        List list = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(model.getRoot().getNamespaces())).expand(Conditions.instanceOf(BasicNamespaceOwner.class))).traverse().filter(BasicNamespace.class).filter(namespace -> !namespace.isVisible()).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil", "getNamespaces"));
        }
        return list;
    }

    public static void setNamespacesVisible(DbDataSource dataSource, BasicModModel model, Iterable<? extends BasicNamespace> selectedValues) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            model.modify(BasicModRoot.class, r -> {
                for (BasicNamespace n : selectedValues) {
                    r.mod(n).setVisible(true);
                }
            });
            DataSourceUiUtil.performAutoSyncTask(dataSource.getProject(), DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource));
        });
    }

    private static /* synthetic */ boolean lambda$buildObjectFilter$1(Map map, DasObject object) {
        Couple couple = (Couple)map.get(object.getKind());
        if (couple == null) {
            return true;
        }
        String name = object.getName();
        return !(couple.first != null && !((Condition)couple.first).value((Object)name) || couple.second != null && ((Condition)couple.second).value((Object)name));
    }

    public static class Status {
        @NotNull
        private final Color color;
        @NotNull
        private final String text;
        @Nullable
        private final String details;

        private Status(@NotNull Color color, @NotNull String text, @Nullable String details) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "<init>"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "<init>"));
            }
            this.color = color;
            this.text = text;
            this.details = details;
        }

        public static Status failed() {
            return new Status((Color)new JBColor(10944523, 12864337), "Failed", "");
        }

        public static Status successful(@NotNull String details) {
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/database/dataSource/DataSourceUiUtil$Status", "successful"));
            }
            return new Status((Color)new JBColor(1011716, 3440685), "Successful", details);
        }
    }

    public static class StatusPanel
    extends JPanel {
        @NotNull
        private final JBLabel statusLabel = new JBLabel();
        @NotNull
        private final ActionLink link = new ActionLink("Details", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                String details;
                String string = details = status == null ? null : status.details;
                if (details == null) {
                    return;
                }
                RelativePoint of = RelativePoint.getSouthOf((JComponent)link);
                JComponent label = HintUtil.createInformationLabel((String)details);
                label.setBorder(IdeBorderFactory.createEmptyBorder((int)1, (int)2, (int)1, (int)2));
                JBPopupFactory.getInstance().createBalloonBuilder(label).setFillColor(HintUtil.INFORMATION_COLOR).setHideOnClickOutside(true).createBalloon().show(of, Balloon.Position.below);
            }
        });
        private Status status;

        public StatusPanel() {
            super(new BorderLayout());
            Box box = new Box(0);
            box.setAlignmentX(0.0f);
            this.link.setNormalColor((Color)new JBColor(0x898989, 0x898989));
            this.link.setActiveColor(UI.getColor((String)"link.foreground"));
            this.link.setPaintUnderline(true);
            box.add((Component)this.statusLabel, "Center");
            box.add(Box.createHorizontalStrut(5));
            box.add((Component)this.link, "East");
            this.add(box);
            this.setStatus(null);
        }

        public void setStatus(@Nullable Status status) {
            this.status = status;
            boolean visible = status != null;
            this.setVisible(visible);
            if (visible) {
                this.statusLabel.setForeground(status.color);
                this.statusLabel.setText(status.text);
            }
            this.link.setVisible(status != null && StringUtil.isNotEmpty((String)status.details));
        }
    }

    public static class RefreshTask
    extends Task.Backgroundable {
        private final ActionCallback callback;
        private long myStartTime;
        private final boolean myForceModal;
        private boolean myIsInModalContext;
        private final LoaderContext myContext;

        public RefreshTask(Project project, LoaderContext context, boolean forceModal) {
            super(project, context.getDataSource().getName(), true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
            this.myContext = context;
            this.myForceModal = forceModal;
            this.callback = new ActionCallback();
        }

        @NotNull
        public final ActionCallback perform() {
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (!this.getProject().isOpen()) {
                    throw new ProcessCanceledException();
                }
                this.myIsInModalContext = ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL;
                this.myStartTime = System.currentTimeMillis();
                ProgressManager.getInstance().run((Task)this);
            });
            ActionCallback actionCallback = this.callback;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$RefreshTask", "perform"));
            }
            return actionCallback;
        }

        public boolean isConditionalModal() {
            return this.myForceModal || this.myIsInModalContext;
        }

        public boolean shouldStartInBackground() {
            return !this.isConditionalModal();
        }

        public void onSuccess() {
            long elapsedTime = (System.currentTimeMillis() - this.myStartTime) / 1000L * 1000L;
            this.onTaskCompleted(this.myContext, elapsedTime);
            this.callback.setDone();
        }

        public void onCancel() {
            this.callback.setRejected();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DataSourceUiUtil$RefreshTask", "run"));
            }
            this.myContext.getDataSource().refreshMetaData(this.myProject, this.myContext);
        }

        protected void onTaskCompleted(LoaderContext context, long elapsedTime) {
            this.showNotification(context, elapsedTime);
        }

        protected void showNotification(LoaderContext context, long elapsedTime) {
            boolean isError = context.getErrorHandler().hasErrors();
            String message = StringUtil.notNullize((String)StringUtil.nullize((String)this.computeMessage(context)), (String)"Connection successful");
            DataSourceUiUtil.showNotification(this.getProject(), this.getTitle(), message + this.getElapsedString(elapsedTime), isError);
        }

        @NotNull
        protected String computeMessage(LoaderContext context) {
            boolean isError = context.getErrorHandler().hasErrors();
            String summary = context.getErrorHandler().getSummary();
            if (isError) {
                String string = summary;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$RefreshTask", "computeMessage"));
                }
                return string;
            }
            if (!context.getSelection().isEmpty()) {
                List objects = ContainerUtil.filter(this.myContext.getSelection(), (Condition)Conditions.notInstanceOf(Class.class));
                int size = objects.size();
                Object item = ContainerUtil.getFirstItem((Collection)objects);
                String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
                String string = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? itemName + " synchronized" : "Synchronization successful";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$RefreshTask", "computeMessage"));
                }
                return string;
            }
            String string = DataSourceUiUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\nConnection successful";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceUiUtil$RefreshTask", "computeMessage"));
            }
            return string;
        }

        protected String getElapsedString(long elapsedTime) {
            return elapsedTime > 1L ? " (" + StringUtil.formatDuration((long)elapsedTime) + ")" : "";
        }
    }
}

