/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseArtifactManager {
    private static final DatabaseArtifactManager INSTANCE = new DatabaseArtifactManager();
    private static final int UPDATE_LIST_TIMEOUT_MSEC = 18000000;
    private volatile Map<String, DownloadableFileSetDescription> myArtifacts = ContainerUtil.newHashMap();
    private volatile long myLastUpdated = 0L;
    private final EventDispatcher<ArtifactListener> myDispatcher = EventDispatcher.create(ArtifactListener.class);

    public static DatabaseArtifactManager getInstance() {
        INSTANCE.checkForUpdates();
        return INSTANCE;
    }

    @Nullable
    private DownloadableFileSetDescription getArtifact(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifact"));
        }
        this.checkForUpdates();
        return this.myArtifacts.get(name);
    }

    private void checkForUpdates() {
        if (System.currentTimeMillis() - this.myLastUpdated > 18000000L) {
            this.updateLists();
        }
    }

    @NotNull
    public List<DownloadableFileSetDescription> getArtifacts() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myArtifacts.values());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getArtifacts"));
        }
        return arrayList;
    }

    public void updateLists() {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        this.myLastUpdated = System.currentTimeMillis();
        new Task.Backgroundable(null, "Loading Database Drivers List", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseArtifactManager$1", "run"));
                }
                List versions = DataSourceConfigUtil.getDriverVersionsFetcher().fetchVersions();
                HashMap newArtifacts = ContainerUtil.newHashMap();
                for (DownloadableFileSetDescription version : versions) {
                    if (!SystemInfo.isWindows) {
                        version.getFiles().removeIf(d -> d.getPresentableFileName().contains("win"));
                    }
                    newArtifacts.put(version.getName(), version);
                }
                DatabaseArtifactManager.this.myArtifacts = newArtifacts;
                ApplicationManager.getApplication().invokeLater(() -> {
                    DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByPath(DatabaseDriverImpl.getDriverDownloadDirectory()));
                    DatabaseArtifactManager.this.fireChanged(null, null);
                }, ModalityState.current());
            }
        }.queue();
    }

    public void addListener(@NotNull ArtifactListener listener, @Nullable Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/DatabaseArtifactManager", "addListener"));
        }
        if (parent != null) {
            this.myDispatcher.addListener((EventListener)listener, parent);
        } else {
            this.myDispatcher.addListener((EventListener)listener);
        }
    }

    private void fireChanged(@Nullable String name, @Nullable String version) {
        ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged(name, version);
    }

    @NotNull
    private static String getBasePath(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        String string = DatabaseDriverImpl.getDriverDownloadDirectory() + "/" + name + "/" + version;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getBasePath"));
        }
        return string;
    }

    @Nullable
    public String getActualVersion(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getActualVersion"));
        }
        DownloadableFileSetDescription artifact = this.getArtifact(name);
        return artifact == null ? null : artifact.getVersionString();
    }

    public boolean isValid(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValid"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValid"));
        }
        DownloadableFileSetDescription desc = this.myArtifacts.get(name);
        if (desc != null && Comparing.equal((String)version, (String)desc.getVersionString())) {
            return DatabaseArtifactManager.isValidFileList(name, desc);
        }
        String path = DatabaseArtifactManager.getBasePath(name, version);
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        return folder != null && folder.getChildren().length > 0;
    }

    public boolean isFreshFiles(@NotNull String name, @NotNull Set<String> fileNames) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isFreshFiles"));
        }
        if (fileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNames", "com/intellij/database/dataSource/DatabaseArtifactManager", "isFreshFiles"));
        }
        DownloadableFileSetDescription desc = this.myArtifacts.get(name);
        return desc == null || DatabaseArtifactManager.isAllDownloaded(desc, fileNames);
    }

    public boolean isLastVersionValid(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isLastVersionValid"));
        }
        DownloadableFileSetDescription desc = this.myArtifacts.get(name);
        if (desc == null) {
            return true;
        }
        return DatabaseArtifactManager.isValidFileList(name, desc);
    }

    private static boolean isValidFileList(@NotNull String name, @NotNull DownloadableFileSetDescription desc) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValidFileList"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/DatabaseArtifactManager", "isValidFileList"));
        }
        String path = DatabaseArtifactManager.getBasePath(name, desc.getVersionString());
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        HashSet existing = ContainerUtil.newHashSet();
        if (folder == null) {
            return false;
        }
        for (VirtualFile file : folder.getChildren()) {
            existing.add(file.getName());
        }
        return DatabaseArtifactManager.isAllDownloaded(desc, existing);
    }

    private static boolean isAllDownloaded(@NotNull DownloadableFileSetDescription desc, Set<String> existing) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/DatabaseArtifactManager", "isAllDownloaded"));
        }
        for (DownloadableFileDescription file : desc.getFiles()) {
            if (file.getDefaultFileName().endsWith(".txt") || existing.contains(file.getDefaultFileName())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String downloadLatest(@NotNull String name, @Nullable Consumer<String> onFinish) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "downloadLatest"));
        }
        DownloadableFileSetDescription download = this.getArtifact(name);
        if (download == null) {
            return null;
        }
        String path = DatabaseArtifactManager.getBasePath(name, download.getVersionString());
        FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(download);
        File dir = new File(path);
        downloader.download(dir);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "lambda$downloadLatest$0"));
            }
            DatabaseArtifactManager.refreshRecursively(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir));
            if (onFinish != null) {
                onFinish.consume((Object)download.getVersionString());
            }
            this.fireChanged(name, download.getVersionString());
        }, ModalityState.current());
        return download.getVersionString();
    }

    private static void refreshRecursively(@Nullable VirtualFile file) {
        if (file != null) {
            VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
            RefreshQueue.getInstance().refresh(false, true, null, ModalityState.current(), new VirtualFile[]{file});
        }
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull String name, @NotNull String version) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        String path = DatabaseArtifactManager.getBasePath(name, version);
        VirtualFile folder = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile[] virtualFileArray = folder == null ? VirtualFile.EMPTY_ARRAY : folder.getChildren();
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseArtifactManager", "getFiles"));
        }
        return virtualFileArray;
    }

    public static interface ArtifactListener
    extends EventListener {
        public void artifactChanged(String var1, String var2);
    }
}

