/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverImpl
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    private final boolean myPredefined;
    private final String myId;
    private String myName;
    private String myDriverClass;
    private String myDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    @NotNull
    private Map<String, String> myVmEnv = ContainerUtil.newLinkedHashMap();
    private final List<UrlTemplate> myUrlTemplates = ContainerUtil.newArrayList();
    private final List<Pair<UrlTemplate, String>> myTemplatesErrors = ContainerUtil.newArrayList();
    private final Map<String, String> myDriverProperties = ContainerUtil.newLinkedHashMap();
    private final Map<DatabaseDriver.Option, String> myOptions = ContainerUtil.newLinkedHashMap();
    private ArtifactRef myArtifactRef;
    private final List<SimpleClasspathElement> myAdditionalClasspathElements = ContainerUtil.newArrayList();
    private List<StatelessJdbcUrlParser> myJdbcUrlParsers = Collections.emptyList();
    private final EnumSet<StatelessJdbcUrlParser.LocationType> mySupportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, false);
        this.myName = name;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.myTemplatesErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getTemplatesErrors"));
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !StringUtil.isEmpty((String)this.myName) ? this.myName : "?";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getFullName"));
        }
        return string;
    }

    @NotNull
    public List<DataSourceTemplate> getSubConfigurations() {
        List<DataSourceTemplate> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSubConfigurations"));
        }
        return list;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.myJdbcUrlParsers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getJDBCUrlParsers"));
        }
        return list;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.mySupportedLocations;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSupportedLocations"));
        }
        return enumSet;
    }

    @NotNull
    public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        LocalDataSource result = copyFrom instanceof LocalDataSource ? ((LocalDataSource)copyFrom).copy(project) : new LocalDataSource(this, this.getSampleUrl());
        if (copyFrom == null) {
            this.setDefaultProperties(result);
        } else {
            result.setFirstSync(ThreeState.NO);
            DatabaseCredentials.getInstance().copyCredentials(copyFrom, (DatabaseSystem)result);
        }
        result.setName(StringUtil.notNullize((String)newName, (String)""));
        LocalDataSource localDataSource = result;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        return localDataSource;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/DatabaseDriverImpl", "setDefaultProperties"));
        }
        result.getDriverProperties().putAll(this.myDriverProperties);
        result.setDriverClass(this.myDriverClass);
        result.setVmOptions(this.myVmOptions);
        result.setVmEnv(this.myVmEnv);
        result.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
    }

    @Override
    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = driverClass;
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getUrlTemplates"));
        }
        return list;
    }

    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/database/dataSource/DatabaseDriverImpl", "setURLTemplates"));
        }
        this.myUrlTemplates.clear();
        this.myTemplatesErrors.clear();
        this.myUrlTemplates.addAll(templates);
        this.myJdbcUrlParsers = ContainerUtil.newArrayListWithCapacity((int)templates.size());
        for (UrlTemplate template : templates) {
            try {
                StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.INSTANCE);
                this.myJdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
            }
            catch (StatelessTextDecomposition.InvalidTemplateException e) {
                this.myTemplatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e.getMessage()));
            }
        }
        this.mySupportedLocations.clear();
        for (StatelessJdbcUrlParser p : this.myJdbcUrlParsers) {
            this.mySupportedLocations.addAll(p.getPossibleLocations());
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/DatabaseDriverImpl", "matchesUrl"));
        }
        return JdbcUrlParserUtil.select(this.myJdbcUrlParsers, url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser : this.myJdbcUrlParsers) {
            if (!parser.getName().equals("default")) continue;
            sparser = parser;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.myJdbcUrlParsers);
        }
        if (sparser == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
            }
            return "";
        }
        JdbcUrlParser parser = sparser.createStatefull();
        for (String p : parser.getParameters()) {
            String def = parser.getParameterDefValue(p);
            parser.setParameter(p, StringUtil.notNullize((String)def));
        }
        String string = parser.getUrlText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
        }
        return string;
    }

    @Override
    public String getDialect() {
        return this.myDialect;
    }

    public void setDialect(String dialect) {
        if (Comparing.equal((String)dialect, (String)this.getDialect())) {
            return;
        }
        this.myDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getIcon"));
        }
        return icon;
    }

    @Override
    public String getIconName() {
        return this.myIconName;
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriver.Option<T> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "getOption"));
        }
        String value = this.myOptions.get(option);
        return option.fromString(value);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriver.Option<T> option, T value) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "setOption"));
        }
        if (value == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value));
        }
    }

    @Override
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmEnv", "com/intellij/database/dataSource/DatabaseDriverImpl", "setVmEnv"));
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Override
    public boolean isDownloaded() {
        return this.myArtifactRef == null || this.myArtifactRef.isDownloaded();
    }

    @Override
    public String getArtifactName() {
        return this.myArtifactRef == null ? null : this.myArtifactRef.getName();
    }

    @Override
    @Nullable
    public String getArtifactVersion() {
        return this.myArtifactRef == null ? null : this.myArtifactRef.getVersion();
    }

    @Override
    public boolean isUseArtifact() {
        return this.myArtifactRef != null && this.myArtifactRef.isUseArtifact();
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myArtifactRef == null || !this.myArtifactRef.isUseArtifact()) {
            return Collections.unmodifiableList(this.myAdditionalClasspathElements);
        }
        return JBIterable.from(this.myArtifactRef.getElements()).append(this.myAdditionalClasspathElements).toList();
    }

    public DatabaseDriverImpl loadState(@NotNull Element config, boolean merge, boolean overrideName, int format) {
        String optionName;
        Element env;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/dataSource/DatabaseDriverImpl", "loadState"));
        }
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge);
        }
        this.myDriverClass = DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge);
        this.myDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.myDialect, merge);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge);
        if (!StringUtil.isEmpty((String)this.myIconName)) {
            this.myIcon = IconLoader.findIcon((String)this.myIconName);
        }
        ArrayList templates = ContainerUtil.newArrayList();
        if (merge) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Object element : config.getChildren("url-template")) {
            String name = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("template"), element.getValue());
            if (StringUtil.isEmpty((String)template)) continue;
            templates.add(new UrlTemplate(name, template));
        }
        this.setURLTemplates(templates);
        if (!merge) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        for (Element element : config.getChildren("vm-options")) {
            this.myVmOptions = DatabaseDriverImpl.getOverride(element.getTextTrim(), this.myVmOptions, merge);
        }
        for (Element element : config.getChildren("artifact")) {
            String name = DatabaseDriverImpl.getOverride(element.getAttributeValue("name"), this.myArtifactRef == null ? null : this.myArtifactRef.getName(), merge);
            String version = DatabaseDriverImpl.getOverride(element.getAttributeValue("version"), this.myArtifactRef == null ? null : this.myArtifactRef.getVersion(), merge);
            this.myArtifactRef = ArtifactRef.update(this.myArtifactRef, merge, name, version);
            if (this.myArtifactRef == null) continue;
            if (Boolean.TRUE.toString().equals(element.getAttributeValue("use"))) {
                this.myArtifactRef.setUseArtifact(true);
            }
            for (Element lib : element.getChildren("library")) {
                this.myArtifactRef.appendLegacy(SimpleClasspathElementFactory.createElements(null, (Element)lib));
            }
        }
        if (!merge) {
            this.myOptions.clear();
        }
        for (Element element : config.getChildren("option")) {
            optionName = element.getAttributeValue("name");
            String value = element.getAttributeValue("value");
            DatabaseDriver.Option option = DatabaseDriver.Option.byName(optionName);
            if (option == null) continue;
            this.myOptions.put(option, value);
        }
        if (!merge) {
            this.myDriverProperties.clear();
        }
        for (Element element : config.getChildren("property")) {
            optionName = element.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element.getAttributeValue("value"));
        }
        if (!merge) {
            this.myAdditionalClasspathElements.clear();
        }
        String downloadRoot = VfsUtilCore.pathToUrl((String)DatabaseDriverImpl.getDriverDownloadDirectory());
        Application app = ApplicationManager.getApplication();
        PathMacroManager pathMacroManager = app == null ? null : PathMacroManager.getInstance((ComponentManager)app);
        for (Element element : config.getChildren("library")) {
            ArrayList artifact = ContainerUtil.newArrayList();
            ArrayList additional = ContainerUtil.newArrayList();
            for (SimpleClasspathElement e : SimpleClasspathElementFactory.createElements(null, (Element)element)) {
                boolean downloaded;
                if (format < 163) {
                    downloaded = true;
                    for (String root : e.getClassesRootUrls()) {
                        if (pathMacroManager != null) {
                            root = pathMacroManager.expandPath(root);
                        }
                        if (this.myArtifactRef == null || root.startsWith(downloadRoot)) continue;
                        downloaded = false;
                        break;
                    }
                } else {
                    downloaded = false;
                }
                (downloaded ? artifact : additional).add(e);
            }
            if (this.myArtifactRef != null && !artifact.isEmpty()) {
                this.myArtifactRef.appendLegacy(artifact);
            }
            this.myAdditionalClasspathElements.addAll(additional);
        }
        return this;
    }

    public Element getState(boolean includePredefined) {
        boolean allOptions;
        Element result = new Element("driver");
        result.setAttribute("id", this.myId);
        result.setAttribute("name", StringUtil.notNullize((String)this.myName));
        if (this.myDialect != null) {
            result.setAttribute("dialect", this.myDialect);
        }
        boolean bl = allOptions = !this.myPredefined || includePredefined;
        if (allOptions) {
            if (StringUtil.isNotEmpty((String)this.myDriverClass)) {
                result.setAttribute("driver-class", this.myDriverClass);
            }
            if (StringUtil.isNotEmpty((String)this.myIconName)) {
                result.setAttribute("icon", this.myIconName);
            }
            for (UrlTemplate urlTemplate : this.myUrlTemplates) {
                Element tplElement = new Element("url-template");
                tplElement.setAttribute("name", urlTemplate.getName());
                tplElement.setAttribute("template", urlTemplate.getTemplate());
                result.addContent(tplElement);
            }
        }
        if (this.myArtifactRef != null) {
            Element artifactElement = new Element("artifact");
            artifactElement.setAttribute("name", this.myArtifactRef.getName());
            if (this.myArtifactRef.isUseArtifact()) {
                artifactElement.setAttribute("use", Boolean.TRUE.toString());
            }
            if (this.myArtifactRef.getVersion() != null) {
                artifactElement.setAttribute("version", this.myArtifactRef.getVersion());
            } else {
                DatabaseDriverImpl.serializeClassPathElements(artifactElement, this.myArtifactRef.getElements());
            }
            result.addContent(artifactElement);
        }
        for (DatabaseDriver.Option option : this.myOptions.keySet()) {
            if (!allOptions && option.isFixed()) continue;
            Element e = new Element("option");
            e.setAttribute("name", option.getName());
            e.setAttribute("value", this.myOptions.get(option));
            result.addContent(e);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e = new Element("vm-options");
            e.setText(this.myVmOptions);
            result.addContent(e);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String name : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", name);
                prop.setAttribute("value", this.myVmEnv.get(name));
                env.addContent(prop);
            }
            result.addContent(env);
        }
        for (Map.Entry entry : this.myDriverProperties.entrySet()) {
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", (String)entry.getKey());
            optionElement.setAttribute("value", (String)entry.getValue());
            result.addContent(optionElement);
        }
        DatabaseDriverImpl.serializeClassPathElements(result, this.myAdditionalClasspathElements);
        return result;
    }

    private static void serializeClassPathElements(Element result, List<SimpleClasspathElement> classpathElements) {
        for (SimpleClasspathElement cpe : classpathElements) {
            Element libraryElement = new Element("library");
            try {
                cpe.serialize(libraryElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            result.addContent(libraryElement);
        }
    }

    private static String getIfNotNull(String value, String defaultValue) {
        return StringUtil.isEmpty((String)value) ? defaultValue : value;
    }

    private static String getOverride(String value, String oldValue, boolean merge) {
        return merge ? DatabaseDriverImpl.getIfNotNull(value, oldValue) : value;
    }

    public void setAdditionalClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myAdditionalClasspathElements.clear();
        this.myAdditionalClasspathElements.addAll(classpathElements);
    }

    @Override
    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements() {
        List<SimpleClasspathElement> list = this.myAdditionalClasspathElements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getAdditionalClasspathElements"));
        }
        return list;
    }

    public static String getDriverDownloadDirectory() {
        String configPath = PathManager.getConfigPath();
        File config = new File(configPath + "/jdbc-drivers");
        if (!config.exists() && !config.mkdirs()) {
            LOG.warn("Unable to create directory: " + config.getAbsolutePath());
        }
        return config.getPath();
    }

    public DatabaseDriverImpl copy(@Nullable String newName, boolean withId) {
        DatabaseDriverImpl result = new DatabaseDriverImpl(withId ? this.myId : null, StringUtil.notNullize((String)newName, (String)this.myName), null, null);
        return result.loadState(this.getState(true), false, false, Integer.MAX_VALUE);
    }

    public boolean equalConfiguration(DatabaseDriverImpl o, boolean ignoreClassPath) {
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myName), (String)StringUtil.nullize((String)o.myName))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myArtifactRef, (Object)o.myArtifactRef)) {
            return false;
        }
        if (!ignoreClassPath && !this.myAdditionalClasspathElements.equals(o.myAdditionalClasspathElements)) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDialect), (String)StringUtil.nullize((String)o.myDialect))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)StringUtil.nullize((String)o.myDriverClass))) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        for (DatabaseDriver.Option<?> option : DatabaseDriver.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o.getOption(option))) continue;
            return false;
        }
        if (this.myUrlTemplates != null ? !this.myUrlTemplates.equals(o.myUrlTemplates) : o.myUrlTemplates != null) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myVmOptions), (String)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        return ContainerUtil.diff(this.myVmEnv, o.myVmEnv).isEmpty();
    }

    public boolean equalConfiguration(DatabaseDriverImpl o) {
        return this.equalConfiguration(o, false);
    }

    public String toString() {
        return "LocalDatabaseDriver{myId='" + this.myId + '\'' + ", myName='" + this.myName + '\'' + '}';
    }

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/dataSource/DatabaseDriverImpl", "dump"));
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.getDriverClass()).append("\n");
        sb.append("Dialect - ").append(this.getDialect()).append("\n");
        sb.append("IconName - ").append(this.getIconName()).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        sb.append("DriverProperties").append("\n");
        for (Map.Entry entry : this.getDriverProperties().entrySet()) {
            sb.append(" * ").append((String)entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("ArtifactName - ").append(this.getArtifactName()).append("\n");
        if (this.myArtifactRef != null) {
            for (SimpleClasspathElement simpleClasspathElement : this.myArtifactRef.getElements()) {
                sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
            }
        }
        sb.append("ClasspathElements").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getAdditionalClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
    }

    @Nullable
    public static SqlLanguageDialect getLanguage(@Nullable DatabaseDriver driver) {
        if (driver == null || driver.getDialect() == null) {
            return null;
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)driver.getDialect()), SqlLanguageDialect.class);
    }

    @NotNull
    public List<SimpleClasspathElement> getArtifactClasspathElements() {
        List<SimpleClasspathElement> list = this.myArtifactRef == null ? Collections.emptyList() : this.myArtifactRef.getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getArtifactClasspathElements"));
        }
        return list;
    }

    public void setArtifact(@Nullable String name, @Nullable String version) {
        this.myArtifactRef = ArtifactRef.update(this.myArtifactRef, true, name, version);
    }

    public void setUseArtifact(boolean use) {
        if (this.myArtifactRef != null) {
            this.myArtifactRef.setUseArtifact(use);
        }
    }

    private static class ArtifactRef {
        private Boolean myUseArtifact;
        private final String myName;
        private final String myVersion;
        private final List<SimpleClasspathElement> myLegacyElements;

        @Nullable
        public static ArtifactRef create(@Nullable String name, @Nullable String version) {
            return StringUtil.isEmpty((String)name) ? null : new ArtifactRef(name, version);
        }

        @Nullable
        public static ArtifactRef update(@Nullable ArtifactRef prev, boolean merge, @Nullable String name, @Nullable String version) {
            boolean changed;
            if (!merge) {
                return ArtifactRef.create(name, version);
            }
            boolean bl = changed = prev == null || !Comparing.equal((String)prev.getName(), (String)name) || !Comparing.equal((String)prev.getVersion(), (String)version);
            if (!changed) {
                return prev;
            }
            ArtifactRef res = ArtifactRef.create(name, version);
            if (version == null && res != null && prev != null) {
                res.appendLegacy(prev.myLegacyElements);
            }
            return res;
        }

        public ArtifactRef(@NotNull String name, @Nullable String version) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRef", "<init>"));
            }
            this.myUseArtifact = null;
            this.myLegacyElements = ContainerUtil.newArrayList();
            this.myName = name;
            this.myVersion = version;
        }

        public boolean isUseArtifact() {
            if (this.myUseArtifact == null) {
                return this.myVersion != null;
            }
            return this.myUseArtifact;
        }

        public void setUseArtifact(boolean useArtifact) {
            this.myUseArtifact = useArtifact;
        }

        public void appendLegacy(@NotNull List<SimpleClasspathElement> items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRef", "appendLegacy"));
            }
            if (items.isEmpty()) {
                return;
            }
            this.myLegacyElements.addAll(items);
            if (this.myUseArtifact == null) {
                this.myUseArtifact = true;
            }
        }

        @NotNull
        public List<SimpleClasspathElement> getElements() {
            if (this.myVersion == null) {
                List<SimpleClasspathElement> list = this.myLegacyElements;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRef", "getElements"));
                }
                return list;
            }
            VirtualFile[] files = DatabaseArtifactManager.getInstance().getFiles(this.myName, this.myVersion);
            String[] urls = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].getUrl();
            }
            List list = SimpleClasspathElementFactory.createElements((String[])urls);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRef", "getElements"));
            }
            return list;
        }

        public boolean isDownloaded() {
            return this.myVersion == null || DatabaseArtifactManager.getInstance().isValid(this.myName, this.myVersion);
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRef", "getName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactRef ref = (ArtifactRef)o;
            if (!Comparing.equal((Object)this.isUseArtifact(), (Object)ref.isUseArtifact())) {
                return false;
            }
            if (!this.myName.equals(ref.myName)) {
                return false;
            }
            return Comparing.equal((String)this.myVersion, (String)ref.myVersion);
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isUseArtifact());
            result = 31 * result + this.myName.hashCode();
            result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
            return result;
        }

        @Nullable
        public String getVersion() {
            return this.myVersion;
        }
    }
}

