/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.factories.RdbmsServiceFactory;
import com.intellij.dbm.generic.GenericIntrospector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Objects;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.util.Version;

class DatabaseModelModernLoader {
    static final Map<String, Version> SUPPORTED_VERSIONS = ImmutableMap.of((Object)Postgres.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Oracle.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Mssql.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Sybase.RDBMS.code, (Object)Version.of((int[])new int[]{15}), (Object)Mysql.RDBMS.code, (Object)Version.of((int[])new int[]{5, 1}));
    static final Version UNATTAINABLE_FUTURE = Version.of((int[])new int[]{Integer.MAX_VALUE});
    @NotNull
    static final RdbmsServiceFactory ourServiceFactory = RdbmsServiceFactory.instance();
    private static final Logger LOG = Logger.getInstance(DatabaseModelModernLoader.class);

    DatabaseModelModernLoader() {
    }

    static void performModernIntrospection(@NotNull DBFacade facade, @NotNull LoaderContext context, @NotNull DasModel dasModel, @NotNull ProgressIndicator indicator, boolean forceLegacy) {
        String extra;
        boolean modern;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        boolean bl = modern = !forceLegacy;
        if (modern) {
            Version serverVersion = facade.getConnectionInfo().serverVersion;
            Version supportedVersion = Objects.notNull(SUPPORTED_VERSIONS.get(facade.rdbms().code), UNATTAINABLE_FUTURE);
            modern = serverVersion.compareTo(supportedVersion) >= 0;
        }
        DBIntrospector introspector = modern ? ourServiceFactory.createIntrospector(facade) : ourServiceFactory.createIntrospector(facade, GenericIntrospector.class);
        LocalDataSource dataSource = context.getDataSource();
        String string = extra = context.isSchemaListOnly() ? " [schemas only]" : "";
        if (dasModel instanceof BasicModModel) {
            indicator.setText("Preparing to incremental introspection (" + facade.rdbms().code + ")" + extra);
            BasicModModel model = (BasicModModel)dasModel;
            introspector.init(model);
        } else {
            indicator.setText("Preparing to complete introspection (" + facade.rdbms().code + ")" + extra);
            introspector.init(null);
            BasicModModel model = introspector.getModel();
            if (dataSource != null) {
                dataSource.setModel(model);
            }
        }
        introspector.setProgressIndicator(indicator);
        DatabaseModelModernLoader.performIntrospectionNewWay(dataSource, introspector, context.isSchemaListOnly());
        indicator.setText("Finishing introspection (" + facade.rdbms().code + ")" + extra);
    }

    private static void performIntrospectionNewWay(LocalDataSource dataSource, DBIntrospector introspector, boolean schemasOnly) {
        try {
            if (dataSource != null) {
                dataSource.performBatch(schemasOnly ? introspector::introspectNamespaces : () -> introspector.introspectAuto(new BasicNamespace[0]));
            } else if (schemasOnly) {
                introspector.introspectNamespaces();
            } else {
                introspector.introspectAuto(new BasicNamespace[0]);
            }
        }
        catch (RuntimeException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

