/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseForeignKey;
import com.intellij.database.dataSource.DatabaseIndex;
import com.intellij.database.dataSource.DatabaseKIFK;
import com.intellij.database.dataSource.DatabaseObject;
import com.intellij.database.dataSource.DatabaseSchema;
import com.intellij.database.dataSource.DatabaseTableFieldData;
import com.intellij.database.dataSource.DatabaseTableKey;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DatabaseTableData
extends DatabaseObject
implements DasTable {
    private String myName;
    private DatabaseSchema mySchema;
    private ObjectKind myKind;
    private String myComment;
    private volatile State myState = new State();
    private boolean mySystem;
    private boolean myTemporary;

    public DatabaseTableData() {
    }

    public DatabaseTableData(String name, DatabaseSchema schema, ObjectKind kind) {
        this.myName = DbUtil.intern((String)name);
        this.mySchema = schema;
        this.myKind = kind;
    }

    public DatabaseTableData(String name, String schema, String catalog, ObjectKind kind) {
        this(name, new DatabaseSchema(catalog, schema), kind);
    }

    void resolveReferences(Collection<DatabaseTableData> tables, Map<DatabaseObject, Object> stateMap) {
        State state = (State)ContainerUtil.getOrElse(stateMap, (Object)this, (Object)this.myState);
        if (state.primaryKey != null) {
            state.primaryKey.resolveReferences(tables);
        }
        for (DatabaseForeignKey databaseForeignKey : state.foreignKeys) {
            databaseForeignKey.resolveReferences(tables);
        }
        for (DatabaseKIFK databaseKIFK : state.indices) {
            databaseKIFK.resolveReferences(tables);
        }
    }

    @NotNull
    public String getName() {
        String string = (String)ObjectUtils.notNull((Object)this.myName, (Object)DasUtil.NO_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getName"));
        }
        return string;
    }

    public String getSchema() {
        return this.mySchema.getName();
    }

    public String getCatalog() {
        return this.mySchema.getCatalog();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.myKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getKind"));
        }
        return objectKind;
    }

    @Transient
    public void setType(ObjectKind kind) {
        this.myKind = kind;
    }

    @NotNull
    public List<DatabaseTableFieldData> getColumns() {
        List<DatabaseTableFieldData> list = this.myState.columns;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getColumns"));
        }
        return list;
    }

    public DatabaseTableKey getPrimaryKey() {
        return this.myState.primaryKey;
    }

    @NotNull
    public List<DatabaseForeignKey> getForeignKeys() {
        List<DatabaseForeignKey> list = this.myState.foreignKeys;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getForeignKeys"));
        }
        return list;
    }

    @NotNull
    public List<DatabaseKIFK> getExportedKeys() {
        List<DatabaseKIFK> list = this.myState.exportedKeys;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getExportedKeys"));
        }
        return list;
    }

    @NotNull
    public List<DatabaseIndex> getIndices() {
        List<DatabaseIndex> list = this.myState.indices;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getIndices"));
        }
        return list;
    }

    Collection<String> getVersionColumns() {
        return this.myState.versionColumns;
    }

    public Collection<String> getAutoIncrement() {
        return this.myState.autoIncrement;
    }

    @Override
    public String getComment() {
        return this.myComment;
    }

    @NotNull
    public DatabaseSchema getDbParent() {
        DatabaseSchema databaseSchema = this.mySchema;
        if (databaseSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getDbParent"));
        }
        return databaseSchema;
    }

    public void setComment(String comment) {
        this.myComment = comment;
    }

    @NonNls
    public String toString() {
        return "Table::" + this.myName;
    }

    void updateState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dataSource/DatabaseTableData", "updateState"));
        }
        this.myState = state.seal();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseTableData data = (DatabaseTableData)o;
        if (this.myName != null ? !this.myName.equals(data.myName) : data.myName != null) {
            return false;
        }
        return this.mySchema.equals(data.mySchema);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.mySchema != null ? this.mySchema.hashCode() : 0);
        return result;
    }

    public void setPrimaryKey(DatabaseTableKey primaryKey) {
        this.myState.primaryKey = primaryKey;
    }

    public boolean isSystem() {
        return this.mySystem;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
        if (c == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getColumnAttrs"));
            }
            return set;
        }
        String name = c.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        State state = this.myState;
        if (state.versionColumns.contains(name)) {
            set.add(DasColumn.Attribute.VERSION);
        }
        if (state.autoIncrement.contains(name)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if (state.primaryKey != null && DasUtil.containsName((String)name, state.primaryKey.getColumnsRef())) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (DatabaseForeignKey databaseForeignKey : state.foreignKeys) {
            if (!DasUtil.containsName((String)name, databaseForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DatabaseIndex databaseIndex : state.indices) {
            if (!DasUtil.containsName((String)name, databaseIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getColumnAttrs"));
        }
        return enumSet;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/DatabaseTableData", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/DatabaseTableData", "getDbChildren"));
        }
        JBIterable result = JBIterable.empty();
        if (kind == ObjectKind.COLUMN || kind == ObjectKind.NONE) {
            result = result.append(this.myState.columns);
        }
        if ((kind == ObjectKind.KEY || kind == ObjectKind.NONE) && this.myState.primaryKey != null) {
            result = result.append(Collections.singleton(this.myState.primaryKey));
        }
        if (kind == ObjectKind.FOREIGN_KEY || kind == ObjectKind.NONE) {
            result = result.append(this.myState.foreignKeys);
        }
        if (kind == ObjectKind.INDEX || kind == ObjectKind.NONE) {
            result = result.append(this.myState.indices);
        }
        JBIterable jBIterable = result.filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseTableData", "getDbChildren"));
        }
        return jBIterable;
    }

    static class State {
        DatabaseTableKey primaryKey;
        final List<DatabaseTableFieldData> columns;
        final List<DatabaseForeignKey> foreignKeys;
        final List<DatabaseKIFK> exportedKeys;
        final List<DatabaseIndex> indices;
        final List<String> versionColumns;
        final List<String> autoIncrement;

        public State() {
            this.columns = ContainerUtil.newArrayList();
            this.foreignKeys = ContainerUtil.newArrayList();
            this.exportedKeys = ContainerUtil.newArrayList();
            this.indices = ContainerUtil.newArrayList();
            this.versionColumns = ContainerUtil.newArrayList();
            this.autoIncrement = ContainerUtil.newArrayList();
        }

        public State(State s) {
            this.primaryKey = s.primaryKey;
            this.columns = State.trim(s.columns, false);
            this.foreignKeys = State.trim(s.foreignKeys, false);
            this.exportedKeys = State.trim(s.exportedKeys, true);
            this.indices = State.trim(s.indices, false);
            this.versionColumns = State.trim(s.versionColumns, false);
            this.autoIncrement = State.trim(s.autoIncrement, false);
        }

        State seal() {
            ContainerUtil.removeDuplicates(this.versionColumns);
            ContainerUtil.removeDuplicates(this.autoIncrement);
            return new State(this);
        }

        private static <T> List<T> trim(List<T> list, boolean mutable) {
            if (list.isEmpty()) {
                return mutable ? new SmartList() : Collections.emptyList();
            }
            return list.size() <= 1 ? new SmartList(list.get(0)) : (List)((ArrayList)list).clone();
        }
    }
}

