/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseKIFK;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionUtil;
import com.intellij.dbm.factories.RdbmsServiceFactory;
import com.intellij.dbm.generic.DatabaseLegacyModelUtils;
import com.intellij.dbm.generic.legacy.ProcedureParameterType;
import com.intellij.dbm.generic.legacy.ProcedureType;
import com.intellij.dbm.generic.legacy.TableType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class LegacyDeserializer {
    private static final String TABLE_ELEMENT_NAME = "table";
    private static final String COLUMN_ELEMENT_NAME = "column";
    private static final String PROCEDURE_ELEMENT_NAME = "procedure";
    private static final String PROCEDURE_PROTO_ELEMENT_NAME = "prototype";
    private static final String ARGUMENT_ELEMENT_NAME = "parameter";

    private static boolean isSchemaBased(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/LegacyDeserializer", "isSchemaBased"));
        }
        Set<String> dbs = scope.databases();
        Set<String> schemas = scope.allSchemas();
        return dbs.size() == 1 && dbs.contains("*") && (schemas.size() != 1 || !schemas.contains("*"));
    }

    @NotNull
    public static BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull DatabaseDialectEx dialect, IntrospectionScope intro, IntrospectionScope res) {
        DbmModel model;
        boolean schemaDbMode;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dialect.getFamilyId());
        if (rdbms == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        if ((schemaDbMode = DatabaseLegacyModelUtils.isSchemaDbMode(model = RdbmsServiceFactory.instance().createModel(rdbms), dialect.getFamilyId())) && (LegacyDeserializer.isSchemaBased(intro) || LegacyDeserializer.isSchemaBased(res))) {
            schemaDbMode = false;
        }
        while (true) {
            String nodeName;
            if (TABLE_ELEMENT_NAME.equals(nodeName = reader.getNodeName())) {
                LegacyDeserializer.deserializeTable(reader, model, schemaDbMode);
            } else if (PROCEDURE_ELEMENT_NAME.equals(nodeName)) {
                LegacyDeserializer.deserializeProcedure(reader, model, schemaDbMode);
            } else if ("schema".equals(nodeName)) {
                LegacyDeserializer.getOrCreateSchema(model, reader.getAttribute("catalog"), reader.getAttribute("name"), schemaDbMode);
            }
            reader.moveUp();
            if (!reader.hasMoreChildren()) break;
            reader.moveDown();
        }
        for (DbmSchema schema : ((JBTreeTraverser)model.traverser().expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).filter(DbmSchema.class)) {
            IntrospectionUtil.derefAll(schema);
        }
        DbmModel dbmModel = model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "deserialize"));
        }
        return dbmModel;
    }

    private static DbmRoutine createRoutine(Family<?> targetFamily, String name, DasRoutine.Kind kind, String comment) {
        DbmRoutine routine = (DbmRoutine)ObjectUtils.tryCast(targetFamily.create(name), DbmRoutine.class);
        if (routine == null) {
            return null;
        }
        routine.setRoutineKind(kind);
        ((DbmObject)((Object)routine)).setComment(comment);
        return routine;
    }

    private static void deserializeArgument(HierarchicalStreamReader xmlReader, DbmRoutine routine, boolean ret) {
        if (!ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        DbmArgument arg = (DbmArgument)((Family)routine.getArguments()).create(DbUtil.intern((String)xmlReader.getAttribute("name")));
        arg.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        arg.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        arg.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        DasArgument.Direction direction = ProcedureParameterType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)ProcedureParameterType.IN.getID())).getArgumentDirection();
        if (ret) {
            direction = DasArgument.Direction.RETURN;
        }
        arg.setDirection(direction);
        arg.setPosition((short)StringUtil.parseInt((String)xmlReader.getAttribute("index"), (int)-1));
    }

    @NotNull
    private static DataType deserializeDataType(HierarchicalStreamReader xmlReader) {
        int scale;
        int precision;
        String sqlType = DbUtil.intern((String)xmlReader.getAttribute("sqlType"));
        String lengthStr = xmlReader.getAttribute("length");
        if (lengthStr != null) {
            precision = StringUtil.parseInt((String)lengthStr, (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
        } else {
            precision = StringUtil.parseInt((String)xmlReader.getAttribute("precision"), (int)-1);
            scale = StringUtil.parseInt((String)xmlReader.getAttribute("scale"), (int)-1);
        }
        int jdbcType = StringUtil.parseInt((String)xmlReader.getAttribute("jdbcType"), (int)1111);
        DataType dataType = DataTypeFactory.of(null, DbUtil.intern((String)sqlType), precision, scale, null, null, false, false, jdbcType);
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeDataType"));
        }
        return dataType;
    }

    private static DbmRoutine deserializeProcedure(HierarchicalStreamReader xmlReader, DbmModel<?, ?> model, boolean schemaDbMode) {
        Family<?> pkgFamily;
        if (!PROCEDURE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return null;
        }
        DbmSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String pkg = DbUtil.intern((String)xmlReader.getAttribute("package"), null);
        Family<DbmSingleRoutine> targetFamily = null;
        if (!StringUtil.isEmpty((String)pkg) && (pkgFamily = schema.findFamilyByChildKind(ObjectKind.PACKAGE)) != null && pkgFamily.isPopulatable()) {
            Object pkgObj = pkgFamily.getOrCreate(pkg);
            targetFamily = ((DbmObject)pkgObj).findFamilyByChildKind(ObjectKind.ROUTINE);
        }
        if (targetFamily == null) {
            targetFamily = schema.getRoutines();
        }
        if (!targetFamily.isPopulatable()) {
            return null;
        }
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        DasRoutine.Kind kind = ProcedureType.findByID(StringUtil.parseInt((String)xmlReader.getAttribute("type"), (int)0)).getKind();
        String comment = LegacyDeserializer.deserializeAttribute(xmlReader, "remarks");
        DbmRoutine routine = null;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (PROCEDURE_PROTO_ELEMENT_NAME.equals(nodeName) && (routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment)) != null) {
                boolean hasReturn = "true".equals(xmlReader.getAttribute("return"));
                while (xmlReader.hasMoreChildren()) {
                    xmlReader.moveDown();
                    if (ARGUMENT_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                        LegacyDeserializer.deserializeArgument(xmlReader, routine, hasReturn);
                        if (hasReturn) {
                            hasReturn = false;
                        }
                    }
                    xmlReader.moveUp();
                }
                ((Family)routine.getArguments()).reorder();
            }
            xmlReader.moveUp();
        }
        if (routine == null) {
            routine = LegacyDeserializer.createRoutine(targetFamily, name, kind, comment);
        }
        return routine;
    }

    private static DbmSchema getOrCreateSchema(DbmModel<?, ?> model, String cat, String schema, boolean schemaDbMode) {
        DbmSchema res;
        if (model.getRootNamespaces().getChildKind() == ObjectKind.DATABASE) {
            DbmDatabase modCat = (DbmDatabase)model.getRootNamespaces().getOrCreate(StringUtil.notNullize((String)DbUtil.intern((String)cat)));
            modCat.setVisible(true);
            res = (DbmSchema)((Family)modCat.getSchemas()).getOrCreate(StringUtil.notNullize((String)DbUtil.intern((String)schema)));
        } else {
            res = (DbmSchema)model.getRootNamespaces().getOrCreate(StringUtil.notNullize((String)DbUtil.intern((String)(schemaDbMode ? cat : schema))));
        }
        res.setVisible(true);
        return res;
    }

    private static void deserializeTable(HierarchicalStreamReader xmlReader, DbmModel<?, ?> model, boolean schemaDbMode) {
        if (!TABLE_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
            return;
        }
        DbmSchema schema = LegacyDeserializer.getOrCreateSchema(model, xmlReader.getAttribute("catalog"), xmlReader.getAttribute("schema"), schemaDbMode);
        String name = DbUtil.intern((String)xmlReader.getAttribute("name"));
        TableType tableType = TableType.findByName(xmlReader.getAttribute("type"));
        Family tableFamily = (Family)ObjectUtils.chooseNotNull(schema.findFamilyByChildKind(tableType.getKind()), schema.getTables());
        if (!tableFamily.isPopulatable()) {
            return;
        }
        DbmLikeTable table = (DbmLikeTable)ObjectUtils.tryCast(tableFamily.getOrCreate(name), DbmLikeTable.class);
        if (table == null) {
            return;
        }
        table.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        short count = 0;
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if (COLUMN_ELEMENT_NAME.equals(nodeName)) {
                DbmColumn column = LegacyDeserializer.deserializeColumn(xmlReader, table);
                if (Boolean.parseBoolean(xmlReader.getAttribute("autoIncrement"))) {
                    column.setSequenceIdentity(DatabaseLegacyModelUtils.SEQUENCE_IDENTITY);
                }
                count = (short)(count + 1);
                column.setPosition(count);
            } else if ("primary-key".equals(nodeName)) {
                LegacyDeserializer.deserializeKey(xmlReader, table).setPrimary(true);
            } else if ("foreign-key".equals(nodeName)) {
                LegacyDeserializer.deserializeFk(xmlReader, table, schemaDbMode);
            } else if ("index".equals(nodeName)) {
                LegacyDeserializer.deserializeIndex(xmlReader, table);
            }
            xmlReader.moveUp();
        }
    }

    private static DbmKey deserializeKey(HierarchicalStreamReader xmlReader, DbmLikeTable table) {
        DbmKey key = (DbmKey)((Family)table.getKeys()).getOrCreate(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, key);
        return key;
    }

    private static DbmIndex deserializeIndex(HierarchicalStreamReader xmlReader, DbmLikeTable table) {
        String[] columns;
        DbmIndex index = (DbmIndex)((Family)table.getIndices()).getOrCreate(DbUtil.intern((String)xmlReader.getAttribute("name")));
        index.setUnique(Boolean.valueOf(xmlReader.getAttribute("unique")));
        for (String column : columns = DatabaseKIFK.COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0)) {
            index.addColumn(column, DasIndex.Sorting.NONE);
        }
        return index;
    }

    private static void deserializeConstraint(HierarchicalStreamReader xmlReader, DbmConstraint constraint) {
        String[] columns;
        for (String column : columns = DatabaseKIFK.COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("columns")), 0)) {
            constraint.addColumn(column);
        }
    }

    private static DbmForeignKey deserializeFk(HierarchicalStreamReader xmlReader, DbmLikeTable table, boolean schemaDbMode) {
        DbmForeignKey fk = (DbmForeignKey)((Family)table.getForeignKeys()).getOrCreate(DbUtil.intern((String)xmlReader.getAttribute("name")));
        LegacyDeserializer.deserializeConstraint(xmlReader, fk);
        String tTab = DbUtil.intern((String)xmlReader.getAttribute("ref-table"));
        String tSchema = DbUtil.intern((String)xmlReader.getAttribute("ref-schema"));
        String tCat = DbUtil.intern((String)xmlReader.getAttribute("ref-catalog"));
        String[] tCols = DatabaseKIFK.COLUMN_SPLITTER_PATTERN.split(StringUtil.notNullize((String)xmlReader.getAttribute("ref-columns")), 0);
        String[] tPath = LegacyDeserializer.buildSearchPath(table, tCat, tSchema, tTab, schemaDbMode);
        fk.refKey.set(tPath, tCols);
        fk.setCascadeUpdateRule(DatabaseLegacyModelUtils.asCascadeRule(DatabaseKIFK.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("update-rule")), (int)-1), DasForeignKey.RuleAction.values()), true));
        fk.setCascadeDeleteRule(DatabaseLegacyModelUtils.asCascadeRule(DatabaseKIFK.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("delete-rule")), (int)-1), DasForeignKey.RuleAction.values()), false));
        DasForeignKey.Deferrability deferrability = DatabaseKIFK.itemAt(StringUtil.parseInt((String)StringUtil.notNullize((String)xmlReader.getAttribute("deferrability")), (int)-1), DasForeignKey.Deferrability.values());
        if (deferrability == null) {
            deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
        }
        fk.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        fk.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        return fk;
    }

    @NotNull
    private static String[] buildSearchPath(DbmLikeTable table, String tCat, String tSchema, String tTab, boolean schemaDbMode) {
        String[] tPath;
        String dbName;
        DbmDatabase database = table.getSchema().myDatabase;
        String string = dbName = database == null ? null : database.getName();
        if (schemaDbMode) {
            String tmp = tCat;
            tCat = tSchema;
            tSchema = tmp;
        }
        if ((tPath = StringUtil.isNotEmpty((String)tCat) && !Comparing.equal((String)tCat, (String)dbName) ? new String[]{tCat, tSchema, tTab} : (StringUtil.isNotEmpty((String)tSchema) && !Comparing.equal((String)tSchema, (String)table.getSchema().getName()) ? new String[]{tSchema, tTab} : new String[]{tTab})) == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LegacyDeserializer", "buildSearchPath"));
        }
        return tPath;
    }

    private static DbmColumn deserializeColumn(HierarchicalStreamReader xmlReader, DbmLikeTable table) {
        DbmColumn column = (DbmColumn)((Family)table.getColumns()).getOrCreate(DbUtil.intern((String)xmlReader.getAttribute("name")));
        column.setDataType(LegacyDeserializer.deserializeDataType(xmlReader));
        column.setMandatory(!Boolean.parseBoolean(xmlReader.getAttribute("nullable")));
        column.setDefaultExpression(LegacyDeserializer.deserializeAttribute(xmlReader, "def"));
        column.setComment(LegacyDeserializer.deserializeAttribute(xmlReader, "remarks"));
        return column;
    }

    @Nullable
    static String deserializeAttribute(@NotNull HierarchicalStreamReader xmlReader, String name) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/LegacyDeserializer", "deserializeAttribute"));
        }
        String value = xmlReader.getAttribute(name);
        if (value != null) {
            return DbUtil.intern((String)new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8));
        }
        return null;
    }
}

