/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayouts;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceLayout {
    public static final Key<StorageSettings> STORAGE_SETTINGS_KEY = Key.create((String)"STORAGE_SETTINGS_KEY");
    public static final String DEF_STAGING_LAYOUT = "plain";
    public static final String DEF_BASE_LAYOUT = "schema-zip";
    public static final String STAGING_DIR = "_staging_";
    public static final String BASE_DIR = "_src_";
    public static final String STORAGE_CONFIG = "storage.xml";
    private final Logger LOG;
    private final String myDataSourceId;
    private final String myDsRoot;
    private final DbSrcStorage.FsAccess myFsAccess;
    private StorageSettings mySettings;

    public DbDataSourceLayout(@NotNull String dataSourceId, @NotNull String dsRoot, @NotNull DbSrcStorage.FsAccess fs) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        if (dsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dsRoot", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "<init>"));
        }
        this.LOG = Logger.getInstance(this.getClass());
        this.myDataSourceId = dataSourceId;
        this.myDsRoot = dsRoot;
        this.myFsAccess = fs;
        this.init();
    }

    @Nullable
    public DbSrcStorageLayout.Item getPath(@Nullable ObjectPath object, boolean stating) {
        VirtualFile root = this.root(stating);
        return object == null || root == null ? null : this.layout(stating).getLocation(root, object);
    }

    public void init() {
        try {
            this.readSettings();
        }
        catch (IOException e) {
            this.LOG.warn((Throwable)e);
            this.mySettings = this.getDefaultSettings();
        }
        this.readFolders(this.myDsRoot);
    }

    @NotNull
    private StorageSettings getDefaultSettings() {
        SqlLanguageDialect dialect = DbSqlUtil.getGenericDialect();
        MetaModel<?> metaModel = ((DatabaseDialectEx)dialect.getDatabaseDialect()).getMetaModel();
        DbSrcStorageLayout stagingLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_STAGING_LAYOUT, metaModel, this.myFsAccess));
        DbSrcStorageLayout baseLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_BASE_LAYOUT, metaModel, this.myFsAccess));
        StorageSettings storageSettings = new StorageSettings(dialect, stagingLayout, baseLayout, metaModel);
        if (storageSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getDefaultSettings"));
        }
        return storageSettings;
    }

    public void initForce(@NotNull SqlLanguageDialect language, @NotNull MetaModel<?> metaModel) throws IOException {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "initForce"));
        }
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "initForce"));
        }
        boolean updated = this.updateSettings(language, metaModel);
        if (updated |= this.createFolders(this.myDsRoot)) {
            this.saveSettings();
        }
    }

    public void initForce() throws IOException {
        boolean updated = this.createFolders(this.myDsRoot);
        if (updated) {
            this.saveSettings();
        }
    }

    public boolean updateSettings(@NotNull SqlLanguageDialect language, @NotNull MetaModel<?> metaModel) {
        DbSrcStorageLayout baseLayout;
        DbSrcStorageLayout stagingLayout;
        boolean metaModelChanged;
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "updateSettings"));
        }
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "updateSettings"));
        }
        boolean bl = metaModelChanged = this.mySettings == null || !this.mySettings.isMetaModel(metaModel);
        if (!metaModelChanged && this.mySettings.myLanguage == language) {
            return false;
        }
        if (this.mySettings == null) {
            stagingLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_STAGING_LAYOUT, metaModel, this.myFsAccess));
            baseLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(DEF_BASE_LAYOUT, metaModel, this.myFsAccess));
        } else if (metaModelChanged) {
            stagingLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(this.mySettings.myStagingLayout.getId(), metaModel, this.myFsAccess));
            baseLayout = (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(this.mySettings.myBaseLayout.getId(), metaModel, this.myFsAccess));
        } else {
            stagingLayout = this.mySettings.myStagingLayout;
            baseLayout = this.mySettings.myBaseLayout;
        }
        StorageSettings newSettings = new StorageSettings(language, stagingLayout, baseLayout, metaModel);
        this.migrate(newSettings);
        return true;
    }

    private void migrate(@NotNull StorageSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "migrate"));
        }
        this.mySettings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSettings() throws IOException {
        VirtualFile file = this.myFsAccess.findFileByPath(this.myDsRoot + "/" + STORAGE_CONFIG);
        if (file != null) {
            StorageSettings saved = (StorageSettings)STORAGE_SETTINGS_KEY.get((UserDataHolder)file);
            if (saved != null) {
                this.mySettings = new StorageSettings(saved.myLanguage, (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(saved.myStagingLayout.getId(), saved.myMetaModel, this.myFsAccess)), (DbSrcStorageLayout)ObjectUtils.assertNotNull((Object)DbSrcStorageLayouts.createLayout(saved.myBaseLayout.getId(), saved.myMetaModel, this.myFsAccess)), saved.myMetaModel);
                return;
            }
            try (XppReader reader = new XppReader((Reader)new InputStreamReader(file.getInputStream()));){
                this.mySettings = this.read((HierarchicalStreamReader)reader);
            }
        } else {
            this.mySettings = this.getDefaultSettings();
        }
    }

    private void saveSettings() throws IOException {
        DbDataSourceLayout.saveInner((OutputStream)new SafeFileOutputStream(new File(this.myDsRoot, STORAGE_CONFIG)), this.mySettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInner(@NotNull OutputStream stream, @NotNull StorageSettings settings) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "saveInner"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "saveInner"));
        }
        PrintWriter printWriter = new PrintWriter(stream);
        try (PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);){
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            DbDataSourceLayout.write((HierarchicalStreamWriter)writer, settings);
        }
    }

    @Nullable
    public ObjectPath getObject(@NotNull VirtualFile file, @Nullable Consumer<Boolean> staging) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getObject"));
        }
        VirtualFile hierarchyFile = (VirtualFile)ObjectUtils.chooseNotNull((Object)this.myFsAccess.getLocalFileForJarEntry(file), (Object)file);
        for (int i = 0; i < 2; ++i) {
            boolean isStaging = i == 0;
            VirtualFile root = this.root(isStaging);
            if (root == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)hierarchyFile, (boolean)false)) continue;
            if (staging != null) {
                staging.consume((Object)isStaging);
            }
            return this.layout(isStaging).getObject(root, file);
        }
        String path = hierarchyFile.getPath();
        for (int i = 0; i < 2; ++i) {
            boolean isStaging = i == 0;
            if (!FileUtil.isAncestor((String)(this.myDsRoot + "/" + (isStaging ? STAGING_DIR : BASE_DIR)), (String)path, (boolean)false) || staging == null) continue;
            staging.consume((Object)isStaging);
        }
        return null;
    }

    @NotNull
    public Iterable<ObjectPath> getExistingChildren(@Nullable ObjectPath object) {
        if (this.mySettings.myBaseRoot == null) {
            List<ObjectPath> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getExistingChildren"));
            }
            return list;
        }
        Iterable<ObjectPath> iterable = this.mySettings.myBaseLayout.getExistingChildren(this.mySettings.myBaseRoot, object);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getExistingChildren"));
        }
        return iterable;
    }

    @NotNull
    public String getDataSourceId() {
        String string = this.myDataSourceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getDataSourceId"));
        }
        return string;
    }

    @NotNull
    private DbSrcStorageLayout layout(boolean staging) {
        DbSrcStorageLayout dbSrcStorageLayout = staging ? this.mySettings.myStagingLayout : this.mySettings.myBaseLayout;
        if (dbSrcStorageLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "layout"));
        }
        return dbSrcStorageLayout;
    }

    @Nullable
    VirtualFile root(boolean staging) {
        return staging ? this.mySettings.myStagingRoot : this.mySettings.myBaseRoot;
    }

    @NotNull
    public MetaModel<?> getMetaModel() {
        MetaModel metaModel = this.mySettings.myMetaModel;
        if (metaModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "getMetaModel"));
        }
        return metaModel;
    }

    public void readFolders(@NotNull String root) {
        File path;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "readFolders"));
        }
        if (this.mySettings.myStagingRoot == null) {
            path = new File(root, STAGING_DIR);
            this.mySettings.myStagingRoot = this.myFsAccess.findFileByPath(path.getPath());
        }
        if (this.mySettings.myBaseRoot == null) {
            path = new File(root, BASE_DIR);
            this.mySettings.myBaseRoot = this.myFsAccess.findFileByPath(path.getPath());
        }
    }

    public boolean createFolders(@NotNull String root) throws IOException {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "createFolders"));
        }
        boolean result = false;
        if (this.mySettings.myStagingRoot == null) {
            this.mySettings.myStagingRoot = VfsUtil.createDirectories((String)new File(root, STAGING_DIR).getPath());
            result = true;
        }
        if (this.mySettings.myBaseRoot == null) {
            this.mySettings.myBaseRoot = VfsUtil.createDirectories((String)new File(root, BASE_DIR).getPath());
            result = true;
        }
        return result;
    }

    @Nullable
    public StorageSettings read(@NotNull HierarchicalStreamReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "read"));
        }
        if (!"storage-settings".equals(reader.getNodeName())) {
            return null;
        }
        String stagingLayoutId = reader.getAttribute("staging-layout");
        String baseLayoutId = reader.getAttribute("base-layout");
        String languageId = reader.getAttribute("language");
        MetaModel<?> metaModel = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("meta-model".equals(reader.getNodeName())) {
                metaModel = DbDataSourceLayout.readMetaModel(reader);
            }
            reader.moveUp();
        }
        if (metaModel == null) {
            throw new IOException("No meta model");
        }
        if (stagingLayoutId == null) {
            throw new IOException("Staging layout is undefined");
        }
        if (baseLayoutId == null) {
            throw new IOException("Base layout is undefined");
        }
        DbSrcStorageLayout stagingLayout = DbSrcStorageLayouts.createLayout(stagingLayoutId, metaModel, this.myFsAccess);
        if (stagingLayout == null) {
            throw new IOException("Unknown staging layout: " + stagingLayoutId);
        }
        DbSrcStorageLayout baseLayout = DbSrcStorageLayouts.createLayout(baseLayoutId, metaModel, this.myFsAccess);
        if (baseLayout == null) {
            throw new IOException("Unknown base layout: " + baseLayoutId);
        }
        SqlLanguageDialect language = (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)languageId), SqlLanguageDialect.class);
        if (language == null) {
            throw new IOException("Unknown SQL dialect: " + languageId);
        }
        return new StorageSettings(language, stagingLayout, baseLayout, metaModel);
    }

    @Nullable
    private static MetaModel<?> readMetaModel(@NotNull HierarchicalStreamReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "readMetaModel"));
        }
        if (!"meta-model".equals(reader.getNodeName())) {
            return null;
        }
        MetaModel.MetaModelBuilder builder = MetaModel.builder();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("node".equals(reader.getNodeName())) {
                String parent = reader.getAttribute("parent");
                String child = reader.getAttribute("child");
                if (parent == null || child == null) {
                    throw new IOException("Invalid MetaModel format");
                }
                ObjectKind pKind = (ObjectKind)ObjectKind.ourKinds.get(parent);
                if (pKind == null) {
                    throw new IOException("Unknown kind: " + parent);
                }
                ObjectKind cKind = (ObjectKind)ObjectKind.ourKinds.get(child);
                if (cKind == null) {
                    throw new IOException("Unknown kind: " + child);
                }
                builder.put(pKind, cKind, Object.class);
            }
            reader.moveUp();
        }
        return builder.build();
    }

    public static void write(@NotNull HierarchicalStreamWriter writer, @NotNull StorageSettings settings) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "write"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "write"));
        }
        writer.startNode("storage-settings");
        writer.addAttribute("staging-layout", settings.myStagingLayout.getId());
        writer.addAttribute("base-layout", settings.myBaseLayout.getId());
        writer.addAttribute("language", settings.myLanguage.getID());
        DbDataSourceLayout.writeMetaModel(writer, settings.myMetaModel);
        writer.endNode();
    }

    private static void writeMetaModel(@NotNull HierarchicalStreamWriter writer, @NotNull MetaModel<?> metaModel) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "writeMetaModel"));
        }
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout", "writeMetaModel"));
        }
        writer.startNode("meta-model");
        for (Couple couple : metaModel.getKindCouples()) {
            writer.startNode("node");
            writer.addAttribute("parent", ((ObjectKind)couple.first).code());
            writer.addAttribute("child", ((ObjectKind)couple.second).code());
            writer.endNode();
        }
        writer.endNode();
    }

    public static class StorageSettings {
        private final SqlLanguageDialect myLanguage;
        private final DbSrcStorageLayout myStagingLayout;
        private final DbSrcStorageLayout myBaseLayout;
        private final MetaModel<?> myMetaModel;
        private VirtualFile myBaseRoot;
        private VirtualFile myStagingRoot;

        public StorageSettings(@NotNull SqlLanguageDialect language, @NotNull DbSrcStorageLayout stagingLayout, @NotNull DbSrcStorageLayout baseLayout, @NotNull MetaModel<?> model) {
            if (language == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            if (stagingLayout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stagingLayout", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            if (baseLayout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLayout", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "<init>"));
            }
            this.myStagingLayout = stagingLayout;
            this.myBaseLayout = baseLayout;
            this.myMetaModel = model;
            this.myLanguage = language;
        }

        public boolean isMetaModel(@NotNull MetaModel<?> model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbDataSourceLayout$StorageSettings", "isMetaModel"));
            }
            return model.getKindCouples().equals(this.myMetaModel.getKindCouples());
        }
    }
}

