/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceListener;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayouts;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcFileSystem
extends NewVirtualFileSystem {
    private static final Logger LOG = Logger.getInstance(DbSrcFileSystem.class);
    public static final String PROTOCOL = "dbSrc";
    public static final FileAttributes DEFAULT_FOLDER_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    public static final String APP_PROJECT_ID = "app";
    public final List<ProjectRoot> myProjectRoots = new CopyOnWriteArrayList<ProjectRoot>();

    @Nullable
    public static Ref<Project> getProject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProject"));
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<Ref<Project>>(){

            @Override
            public Ref<Project> processProject(@Nullable Project project) {
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1", "processDataSource"));
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1", "processFolder"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1", "processFolder"));
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$1", "processFile"));
                }
                return Ref.create((Object)project);
            }
        });
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getDataSource"));
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "processDataSource"));
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "processFolder"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "processFolder"));
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$2", "processFile"));
                }
                return dataSourceId;
            }
        });
    }

    @Nullable
    public static Trinity<List<String>, String, String> getObject(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getObject"));
        }
        return DbSrcFileSystem.processPath(path, new ItemProcessor<Trinity<List<String>, String, String>>(){

            @Override
            public Trinity<List<String>, String, String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFolder"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFolder"));
                }
                return Trinity.create((Object)DbSrcFileSystem.extractObjectPath(path), (Object)DbSrcFileSystem.getCode(path), (Object)group);
            }

            @Override
            public Trinity<List<String>, String, String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$3", "processFile"));
                }
                return Trinity.create((Object)DbSrcFileSystem.extractObjectPath(path), (Object)DbSrcFileSystem.getCode(path), null);
            }
        });
    }

    public static DbSrcFileSystem getInstance() {
        return (DbSrcFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public DbSrcFileSystem() {
        if (!DbSrcStorage.isEnabled()) {
            return;
        }
        final Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                if (DbSrcFileSystem.this.myProjectRoots.isEmpty() && project != null) {
                    this.projectOpened(null);
                    Disposer.register((Disposable)application, () -> this.projectClosed(null));
                }
                String root = DbSrcStorage.getStorageRoot(project);
                String id = DbSrcFileSystem.getProjectId(project);
                DbSrcFileSystem.this.myProjectRoots.add(new ProjectRoot(id, root));
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath("/")});
                if (project == null) {
                    DataSourceStorage.getStorage().addDataSourceListener(new MyDataSourceUpdater(null), (Disposable)application);
                } else {
                    DataSourceManagerEx.getInstanceEx(project).addDataSourceListener(new MyDataSourceUpdater(project), (Disposable)project);
                }
            }

            public void projectClosed(Project project) {
                String id = DbSrcFileSystem.getProjectId(project);
                ProjectRoot root = (ProjectRoot)ContainerUtil.find(DbSrcFileSystem.this.myProjectRoots, r -> r.projectId.equals(id));
                if (root == null) {
                    return;
                }
                DbSrcFileSystem.this.myProjectRoots.remove(root);
                LocalFileSystem.getInstance().removeWatchedRoot(root.watchRequest);
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath("/")});
            }
        });
        application.getMessageBus().connect((Disposable)application).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "before"));
                }
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$5", "after"));
                }
                ArrayList files = ContainerUtil.newArrayList();
                for (VFileEvent vFileEvent : events) {
                    VirtualFile baseFile;
                    String dataSourceId;
                    String projectId = DbSrcFileSystem.this.getProjectRoot(vFileEvent.getPath());
                    if (projectId == null) continue;
                    Project project = null;
                    if (!DbSrcFileSystem.APP_PROJECT_ID.equals(projectId) && (project = ProjectIdMap.INSTANCE.getProject(projectId)) == null || (dataSourceId = DbSrcFileSystem.getDataSourceId(project, baseFile = vFileEvent.getFile())) == null || baseFile == null) continue;
                    DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                    Ref staging = Ref.create((Object)false);
                    ObjectPath object = layout.getObject(baseFile, (Consumer<Boolean>)((Consumer)arg_0 -> ((Ref)staging).set(arg_0)));
                    if (((Boolean)staging.get()).booleanValue() && (vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileContentChangeEvent)) continue;
                    for (int i = 0; i < 2; ++i) {
                        ContainerUtil.addIfNotNull((Collection)files, (Object)DbSrcFileSystem.this.refreshAndFindFileByPath(DbSrcFileSystem.getPath(project, dataSourceId, object, i == 0)));
                    }
                }
                if (!files.isEmpty()) {
                    VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)files));
                }
            }
        });
    }

    @NotNull
    private static String getProjectId(Project project) {
        String string = project == null ? APP_PROJECT_ID : project.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProjectId"));
        }
        return string;
    }

    @Nullable
    private String getProjectRoot(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProjectRoot"));
        }
        for (ProjectRoot root : this.myProjectRoots) {
            if (!FileUtil.isAncestor((String)root.root, (String)path, (boolean)false)) continue;
            return root.projectId;
        }
        return null;
    }

    @Nullable
    private static String getDataSourceId(@Nullable Project project, @Nullable VirtualFile file) {
        DbSrcStorage storage = DbSrcStorage.getInstance(project);
        VirtualFile folder = storage.getDataSourceFolder(file);
        if (folder == null || file == null || !file.isValid()) {
            return null;
        }
        return folder.getName();
    }

    @NotNull
    public static String getPath(@Nullable Project project, @Nullable String dsId, @Nullable ObjectPath object, boolean src) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(DbSrcFileSystem.getProjectId(project));
        if (dsId != null) {
            builder.append("/").append(dsId);
            if (object != null) {
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dsId);
                DbSrcStorageLayouts.GroupedByKindLayout.FullPath kinds = DbSrcStorageLayouts.GroupedByKindLayout.getPathToRoot(layout.getMetaModel(), object);
                if (kinds == null) {
                    for (String item : object.path) {
                        builder.append("/none/").append(DbSrcFileSystem.escape(item));
                    }
                } else {
                    int end = kinds.size();
                    for (int i = 0; i < end; ++i) {
                        builder.append("/").append(DbSrcFileSystem.escape(kinds.kind(i).code())).append("/").append(DbSrcFileSystem.escape(kinds.name(i)));
                    }
                }
                if (src) {
                    builder.append(".sql");
                }
            }
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getPath"));
        }
        return string;
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findFileByPath"));
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        Project project;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractPresentableUrl"));
        }
        List items = FileUtil.splitPath((String)path);
        if (items.size() >= 2 && (project = ProjectIdMap.INSTANCE.getProject((String)items.get(1))) != null) {
            DbDataSource source;
            items.set(1, project.getName());
            if (items.size() >= 3 && (source = DbPsiFacade.getInstance((Project)project).findDataSource((String)items.get(2))) != null) {
                items.set(2, source.getName());
            }
        }
        String string = StringUtil.join((Collection)items, (String)String.valueOf(File.separatorChar));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractPresentableUrl"));
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, (boolean)asynchronous);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "refreshAndFindFileByPath"));
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findFileByPathIfCached"));
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractRootPath"));
        }
        String string = path.startsWith("/") ? "/" : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractRootPath"));
        }
        return string;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "normalize"));
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "copyFile"));
        }
        throw DbSrcFileSystem.unsupported("copy", file);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildDirectory"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildDirectory"));
        }
        throw DbSrcFileSystem.unsupported("create directory", parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createChildFile"));
        }
        throw DbSrcFileSystem.unsupported("create file", parent);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "deleteFile"));
        }
        throw DbSrcFileSystem.unsupported("delete", file);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "moveFile"));
        }
        throw DbSrcFileSystem.unsupported("move", file);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "renameFile"));
        }
        throw DbSrcFileSystem.unsupported("rename", file);
    }

    @NotNull
    private static IOException unsupported(@NotNull String op, @NotNull VirtualFile file) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        IOException iOException = new IOException(StringUtil.capitalize((String)op) + " is unsupported for DbSrcFS: " + file.getUrl());
        if (iOException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "unsupported"));
        }
        return iOException;
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getAttributes"));
        }
        if (!DbSrcStorage.isEnabled()) {
            return null;
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<FileAttributes>(){

            @Override
            public FileAttributes processRoot() {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processProject(@Nullable Project project) {
                return DEFAULT_FOLDER_ATTRIBUTES;
            }

            @Override
            public FileAttributes processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processDataSource"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                return storage.exists(dataSourceId) ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFolder"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFolder"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = storage.getLayout(dataSourceId);
                ObjectPath object = DbSrcFileSystem.createObject(layout, path);
                if (object == null && !path.isEmpty()) {
                    return null;
                }
                if (group != null) {
                    return JBIterable.from(layout.getExistingChildren(object)).filter(p -> p.kind.code().equals(group)).isEmpty() ? null : DEFAULT_FOLDER_ATTRIBUTES;
                }
                DbSrcStorageLayout.Item item = layout.getPath(object, false);
                return item != null && item.hasChildren() ? DEFAULT_FOLDER_ATTRIBUTES : null;
            }

            @Override
            public FileAttributes processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                VirtualFile baseFile;
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$6", "processFile"));
                }
                DbSrcStorage storage = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = storage.getLayout(dataSourceId);
                ObjectPath object = DbSrcFileSystem.createObject(layout, path);
                if (object == null) {
                    return null;
                }
                DbSrcStorageLayout.Item item = layout.getPath(object, true);
                VirtualFile virtualFile = baseFile = item == null ? null : item.getSrcFile();
                if (baseFile == null) {
                    item = layout.getPath(object, false);
                    VirtualFile virtualFile2 = baseFile = item == null ? null : item.getSrcFile();
                }
                if (baseFile == null) {
                    return null;
                }
                NewVirtualFileSystem baseFs = (NewVirtualFileSystem)ObjectUtils.tryCast((Object)baseFile.getFileSystem(), NewVirtualFileSystem.class);
                if (baseFs != null) {
                    FileAttributes attr = baseFs.getAttributes(baseFile);
                    return attr == null ? null : new FileAttributes(attr.isDirectory(), attr.isSpecial(), attr.isSymLink(), attr.isHidden(), attr.length, attr.lastModified, true);
                }
                return new FileAttributes(false, false, false, false, baseFile.getLength(), baseFile.getModificationStamp(), true);
            }
        });
    }

    @Nullable
    public static DasObject findObject(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        return DbSrcFileSystem.findObject(file, (PairFunction<Project, String, DasModel>)((PairFunction)(p, id) -> {
            LocalDataSource ds = DbSrcChangesTracker.findDataSource(p, id);
            return ds == null ? null : ds.getModel();
        }), DasObject.class);
    }

    @Nullable
    public static <T extends DasObject> T findObject(@NotNull VirtualFile file, final @NotNull PairFunction<Project, String, DasModel> modelProvider, final @NotNull Class<? extends T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        if (modelProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelProvider", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        return (T)((DasObject)DbSrcFileSystem.processPath(file, new ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$7", "processFile"));
                }
                return DbSrcFileSystem.findObject(path, (DasModel)modelProvider.fun((Object)project, (Object)dataSourceId), clazz);
            }
        }));
    }

    @Nullable
    @Contract(value="_,null,_->null")
    private static <T extends DasObject> T findObject(@NotNull List<String> path, @Nullable DasModel model, @NotNull Class<? extends T> clazz) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "findObject"));
        }
        if (model == null) {
            return null;
        }
        String code = DbSrcFileSystem.getCode(path);
        DasObject obj = (DasObject)QNameUtil.findByQName(model, StringUtil.join(DbSrcFileSystem.extractObjectPath(path), DatabaseElementVirtualFileImpl.ESCAPER, (String)"."), DatabaseElementVirtualFileImpl.NAMER).filter(clazz).filter(o -> o.getKind().code().equals(code)).first();
        return (T)(obj == null ? null : obj);
    }

    private static List<String> extractObjectPath(@NotNull List<String> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "extractObjectPath"));
        }
        ArrayList p = ContainerUtil.newArrayListWithCapacity((int)(path.size() / 2));
        int i = 0;
        while (i + 1 < path.size()) {
            p.add(path.get(i + 1));
            i += 2;
        }
        return p;
    }

    public boolean exists(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "exists"));
        }
        return this.getAttributes(file) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
        }
        if (!DbSrcStorage.isEnabled()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = ArrayUtil.toStringArray(DbSrcFileSystem.processPath(file, new ItemProcessor<Collection<String>>(){

            @Override
            public Collection<String> processRoot() {
                ArrayList res = ContainerUtil.newArrayList((Object[])new String[]{DbSrcFileSystem.APP_PROJECT_ID});
                for (Project p : ProjectManager.getInstance().getOpenProjects()) {
                    res.add(p.getLocationHash());
                }
                return res;
            }

            @Override
            public Collection<String> processOutOfDate() {
                return Collections.emptyList();
            }

            @Override
            public Collection<String> processProject(@Nullable Project project) {
                return DbSrcStorage.getInstance(project).getDataSources();
            }

            @Override
            public Collection<String> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8", "processDataSource"));
                }
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                return JBIterable.from(layout.getExistingChildren(null)).transform(o -> o.kind.code()).transform(k -> DbSrcFileSystem.escape(k)).toSet();
            }

            @Override
            public Collection<String> processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8", "processFolder"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8", "processFolder"));
                }
                DbDataSourceLayout layout = DbSrcStorage.getInstance(project).getLayout(dataSourceId);
                JBIterable children = JBIterable.from(layout.getExistingChildren(DbSrcFileSystem.createObject(layout, path)));
                if (group != null) {
                    LinkedHashSet res = ContainerUtil.newLinkedHashSet();
                    for (ObjectPath child : children.filter(o -> o.kind.code().equals(group))) {
                        DbSrcStorageLayout.Item item = layout.getPath(child, false);
                        if (item == null) continue;
                        if (item.getSrcFile() != null) {
                            res.add(DbSrcFileSystem.escape(child.getName()) + ".sql");
                        }
                        if (!item.hasChildren()) continue;
                        res.add(DbSrcFileSystem.escape(child.getName()));
                    }
                    return res;
                }
                return children.transform(o -> o.kind.code()).transform(k -> DbSrcFileSystem.escape(k)).toSet();
            }

            @Override
            public Collection<String> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$8", "processFile"));
                }
                return Collections.emptyList();
            }
        }));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "list"));
        }
        return stringArray;
    }

    public boolean isDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isDirectory"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isWritable"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "isSymLink"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null && attributes.isSymLink();
    }

    public long getTimeStamp(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getTimeStamp"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public long getLength(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getLength"));
        }
        FileAttributes attributes = this.getAttributes(file);
        return attributes != null ? attributes.length : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file, long timeStamp) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "setTimeStamp"));
        }
        throw DbSrcFileSystem.unsupported("set timestamp", file);
    }

    public void setWritable(@NotNull VirtualFile file, boolean writableFlag) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "setWritable"));
        }
        throw DbSrcFileSystem.unsupported("set writable", file);
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
        }
        VirtualFile baseFile = this.getBaseFile(file, true);
        if (baseFile == null) {
            baseFile = this.getBaseFile(file, false);
        }
        if (baseFile == null) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        FileSystemInterface fs = (FileSystemInterface)ObjectUtils.tryCast((Object)baseFile.getFileSystem(), FileSystemInterface.class);
        byte[] byArray = fs == null ? baseFile.contentsToByteArray() : fs.contentsToByteArray(baseFile);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getInputStream"));
        }
        BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(this.contentsToByteArray(file));
        if (bufferExposingByteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getInputStream"));
        }
        return bufferExposingByteArrayInputStream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public OutputStream getOutputStream(final @NotNull VirtualFile file, final Object requestor, long modStamp, long l) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
        }
        VirtualFile baseFile = this.getBaseFile(file, true);
        if (baseFile != null) {
            void timeStamp;
            FileSystemInterface fs = (FileSystemInterface)ObjectUtils.tryCast((Object)baseFile.getFileSystem(), FileSystemInterface.class);
            OutputStream outputStream = fs == null ? baseFile.getOutputStream(requestor) : fs.getOutputStream(baseFile, requestor, modStamp, (long)timeStamp);
            if (outputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
            }
            return outputStream;
        }
        baseFile = this.getBaseFile(file, false);
        if (baseFile == null) {
            throw DbSrcFileSystem.unsupported("write", file);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = DbSrcFileSystem.this.contentsToByteArray(file);
                boolean same = bytes.length == this.count;
                for (int i = 0; i < this.count && same; ++i) {
                    same = bytes[i] == this.buf[i];
                }
                if (same) {
                    return;
                }
                VirtualFile clone = DbSrcFileSystem.this.createBaseFile(file, true);
                if (clone == null) {
                    throw DbSrcFileSystem.unsupported("write (close)", file);
                }
                try (OutputStream stream = clone.getOutputStream(requestor);){
                    stream.write(this.buf, 0, this.count);
                }
            }
        };
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getOutputStream"));
        }
        return byteArrayOutputStream;
    }

    @Nullable
    public VirtualFile getBaseFile(@NotNull VirtualFile file, final boolean staging) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getBaseFile"));
        }
        return DbSrcFileSystem.processPath(file, new ItemProcessor<VirtualFile>(){

            @Override
            public VirtualFile processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$10", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$10", "processFile"));
                }
                DbSrcStorage instance = DbSrcStorage.getInstance(project);
                DbDataSourceLayout layout = instance.getLayout(dataSourceId);
                DbSrcStorageLayout.Item item = layout.getPath(DbSrcFileSystem.createObject(layout, path), staging);
                return item == null ? null : item.getSrcFile();
            }
        });
    }

    @Nullable
    private VirtualFile createBaseFile(@NotNull VirtualFile file, final boolean staging) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createBaseFile"));
        }
        final Ref exc = Ref.create();
        VirtualFile res = DbSrcFileSystem.processPath(file, new ItemProcessor<VirtualFile>(){

            @Override
            public VirtualFile processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
                if (dataSourceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$11", "processFile"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$11", "processFile"));
                }
                DbSrcStorage instance = DbSrcStorage.getInstance(project);
                try {
                    DbDataSourceLayout layout = instance.getLayout(dataSourceId);
                    layout.initForce();
                    DbSrcStorageLayout.Item item = layout.getPath(DbSrcFileSystem.createObject(layout, path), staging);
                    if (item == null) {
                        return null;
                    }
                    item.getOutputStream(this).close();
                    return item.getSrcFile();
                }
                catch (IOException e) {
                    exc.set((Object)e);
                    return null;
                }
            }
        });
        if (exc.get() != null) {
            throw (IOException)exc.get();
        }
        return res;
    }

    @Nullable
    private static ObjectPath createObject(@NotNull DbDataSourceLayout layout, @NotNull List<String> path) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createObject"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "createObject"));
        }
        assert (path.size() % 2 == 0);
        if (path.size() < 2) {
            return null;
        }
        ObjectKind kind = layout.getMetaModel().findKind(DbSrcFileSystem.getCode(path));
        if (kind == null) {
            return null;
        }
        return new ObjectPath(kind, DbSrcFileSystem.extractObjectPath(path));
    }

    @Nullable
    private static String getCode(@NotNull List<String> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getCode"));
        }
        return path.size() < 2 ? null : path.get(path.size() - 2);
    }

    @Nullable
    public VirtualFile getLatestBaseFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "getLatestBaseFile"));
        }
        VirtualFile res = this.getBaseFile(file, true);
        return res == null ? this.getBaseFile(file, false) : res;
    }

    public static <R> R processPath(@NotNull VirtualFile file, @NotNull ItemProcessor<R> processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        return DbSrcFileSystem.processPath(file.getPath(), processor);
    }

    public static <R> R processPath(@NotNull String path, @NotNull ItemProcessor<R> processor) {
        Project project;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem", "processPath"));
        }
        List items = FileUtil.splitPath((String)path);
        if (items.size() <= 1 || items.size() == 2 && ((String)items.get(1)).isEmpty()) {
            return processor.processRoot();
        }
        boolean app = ((String)items.get(1)).equals(APP_PROJECT_ID);
        Project project2 = project = app ? null : ProjectIdMap.INSTANCE.getProject((String)items.get(1));
        if (project == null && !app) {
            return processor.processOutOfDate();
        }
        if (items.size() <= 2) {
            return processor.processProject(project);
        }
        if (items.size() <= 3) {
            return processor.processDataSource(project, (String)items.get(2));
        }
        boolean group = (items.size() - 3) % 2 == 1;
        String last = (String)items.get(items.size() - 1);
        if (!group) {
            if (last.endsWith(".sql")) {
                items.set(items.size() - 1, StringUtil.trimEnd((String)last, (String)".sql"));
                return processor.processFile(project, (String)items.get(2), DbSrcFileSystem.unescape(items.subList(3, items.size())));
            }
            return processor.processFolder(project, (String)items.get(2), DbSrcFileSystem.unescape(items.subList(3, items.size())), null);
        }
        return processor.processFolder(project, (String)items.get(2), DbSrcFileSystem.unescape(items.subList(3, items.size() - 1)), DbSrcFileSystem.unescape(last));
    }

    private static String escape(String s) {
        if (s == null) {
            return null;
        }
        return DatabaseElementVirtualFileImpl.escape(s);
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return DatabaseElementVirtualFileImpl.unescape(s);
    }

    private static List<String> unescape(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, DbSrcFileSystem.unescape(list.get(i)));
        }
        return list;
    }

    private class MyDataSourceUpdater
    implements DataSourceListener {
        private final Project myProject;

        public MyDataSourceUpdater(Project project) {
            this.myProject = project;
        }

        @Override
        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater", "dataSourceAdded"));
            }
            this.markDirty();
        }

        @Override
        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$MyDataSourceUpdater", "dataSourceRemoved"));
            }
            this.markDirty();
        }

        @Override
        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
        }

        public void markDirty() {
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{DbSrcFileSystem.this.findFileByPath(DbSrcFileSystem.getPath(this.myProject, null, null, false))});
        }
    }

    private static class ProjectIdMap {
        public static final ProjectIdMap INSTANCE = new ProjectIdMap();
        private final BidirectionalMap<Project, String> myProject2Id = new BidirectionalMap();

        public ProjectIdMap() {
            Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

                public void projectOpened(Project project) {
                    this.onProjectOpened(project);
                }
            });
            this.initProjectMap();
        }

        @Nullable
        public Project getProject(String projectId) {
            List list = this.myProject2Id.getKeysByValue((Object)projectId);
            return list == null || list.size() > 1 ? null : (Project)list.get(0);
        }

        public void onProjectClosed(Project project) {
            this.myProject2Id.remove((Object)project);
        }

        public void onProjectOpened(final Project project) {
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    this.onProjectClosed(project);
                }
            });
            String projectId = project.getLocationHash();
            this.myProject2Id.put((Object)project, (Object)projectId);
            List projects = this.myProject2Id.getKeysByValue((Object)projectId);
            if (projects != null && projects.size() > 1) {
                LOG.error("project " + projectId + " already registered: " + projects);
            }
        }

        private void initProjectMap() {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (!project.isOpen()) continue;
                this.onProjectOpened(project);
            }
        }
    }

    public static abstract class ItemProcessor<R> {
        public R processRoot() {
            return null;
        }

        public R processOutOfDate() {
            return null;
        }

        public R processProject(@Nullable Project project) {
            return null;
        }

        public R processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processDataSource"));
            }
            return null;
        }

        public R processFolder(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path, @Nullable String group) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFolder"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFolder"));
            }
            return null;
        }

        public R processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull List<String> path) {
            if (dataSourceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFile"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcFileSystem$ItemProcessor", "processFile"));
            }
            return null;
        }
    }

    private static class ProjectRoot {
        public final String projectId;
        public final String root;
        public final LocalFileSystem.WatchRequest watchRequest;

        private ProjectRoot(String projectId, String root) {
            this.projectId = projectId;
            this.root = root;
            this.watchRequest = LocalFileSystem.getInstance().addRootToWatch(root, true);
        }
    }
}

