/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Set<DbElement> load(@Nullable ProgressIndicator indicator, @NotNull DbDataSource dataSource, @NotNull Collection<DbElement> objects) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        Set toDo = objects.contains(dataSource) ? ((JBTreeTraverser)dataSource.getModel().traverser().filter(DbSrcStorage::isStored)).filter(DbElement.class).toSet() : ((JBTreeTraverser)((JBTreeTraverser)dataSource.getModel().traverser().withRoots(objects)).filter(DbSrcStorage::isStored)).filter(DbElement.class).toSet();
        DbSrcStorage storage = DbSrcStorage.getInstance(dataSource);
        DbDataSourceLayout layout = storage.getLayout(dataSource.getUniqueId());
        DbSrcLoader.wrap(() -> {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "lambda$load$0"));
            }
            layout.initForce(DbSqlUtil.getSqlDialect((DbElement)dataSource), DbImplUtil.getDatabaseDialect((DbElement)dataSource).getMetaModel());
            return null;
        });
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        int count = indicator == null ? 1 : toDo.size();
        int portion = Math.max(1, count / 50);
        int index = 0;
        HashSet failed = ContainerUtil.newHashSet();
        ConnectionProvider provider = ConnectionProvider.forElement((DbElement)dataSource);
        provider.acquire();
        try {
            for (DbElement element : toDo) {
                if (indicator != null) {
                    indicator.checkCanceled();
                    if (index % portion == 0) {
                        indicator.setFraction(0.01 + 1.0 * (double)index / (double)count);
                    }
                }
                if (!DbSrcLoader.load(layout, provider, element)) {
                    failed.add(element);
                }
                ++index;
            }
        }
        finally {
            provider.release();
        }
        HashSet hashSet = failed;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        return hashSet;
    }

    public static boolean load(@NotNull DbDataSourceLayout layout, @NotNull ConnectionProvider provider, @NotNull DbElement object) throws IOException {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcLoader", "load"));
        }
        StringBuilder src = new StringBuilder();
        try {
            DatabaseEditorHelper.loadDefinition(provider, object, src);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return false;
        }
        String text = src.toString();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return false;
        }
        DbSrcStorageLayout.Item item = layout.getPath(ObjectPath.of((DasObject)object), false);
        if (item == null) {
            return false;
        }
        DbSrcLoader.wrap(() -> {
            try (PrintWriter writer = new PrintWriter(item.getOutputStream(DbSrcLoader.class));){
                writer.write(text);
            }
            return null;
        });
        return true;
    }

    public static <T> T wrap(final ThrowableComputable<T, IOException> comp) throws IOException {
        RunResult result = new WriteAction<T>(){

            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/srcStorage/DbSrcLoader$1", "run"));
                }
                result.setResult(comp.compute());
            }
        }.execute();
        ExceptionUtil.rethrowUnchecked((Throwable)result.getThrowable());
        if (result.getThrowable() instanceof IOException) {
            throw (IOException)result.getThrowable();
        }
        return (T)result.getResultObject();
    }
}

