/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftFactoryMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorage {
    public static boolean ourEnabledOverride = false;
    private final Project myProject;
    private final String myStorageRoot;
    protected final FsAccess myFsAccess;
    private final SoftFactoryMap<String, DbDataSourceLayout> myDsLayouts;
    private static final Set<ObjectKind> ourKinds = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.ROUTINE, ObjectKind.VIEW, ObjectKind.PACKAGE, ObjectKind.BODY});

    public static boolean isEnabled() {
        if (ourEnabledOverride) {
            return true;
        }
        return LazyData.STORAGE_ENABLED;
    }

    @NotNull
    public static DbSrcStorage getInstance(@Nullable Project project) {
        DbSrcStorage service = project == null ? (DbSrcStorage)ServiceManager.getService(App.class) : (DbSrcStorage)ServiceManager.getService((Project)project, DbSrcStorage.class);
        DbSrcStorage dbSrcStorage = service == null ? new DbSrcStorage(project) : service;
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    @NotNull
    public static DbSrcStorage getInstance(@NotNull DbDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        Project project = dataSource.getProject();
        LocalDataSource localDataSource = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class));
        if (localDataSource != null && localDataSource.isGlobal()) {
            project = null;
        }
        DbSrcStorage dbSrcStorage = DbSrcStorage.getInstance(project);
        if (dbSrcStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getInstance"));
        }
        return dbSrcStorage;
    }

    public DbSrcStorage(@Nullable Project project) {
        this(project, FsAccess.INSTANCE);
    }

    public DbSrcStorage(@Nullable Project project, @NotNull FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "<init>"));
        }
        this.myDsLayouts = new SoftFactoryMap<String, DbDataSourceLayout>(){

            @Nullable
            protected DbDataSourceLayout create(String id) {
                return new DbDataSourceLayout(id, DbSrcStorage.this.buildPath(id), DbSrcStorage.this.myFsAccess);
            }
        };
        this.myFsAccess = fs;
        this.myProject = project;
        this.myStorageRoot = DbSrcStorage.getStorageRoot(project);
    }

    @NotNull
    public FsAccess getFsAccess() {
        FsAccess fsAccess = this.myFsAccess;
        if (fsAccess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getFsAccess"));
        }
        return fsAccess;
    }

    @NotNull
    public List<String> getDataSources() {
        VirtualFile root = this.getStorageRoot();
        if (root == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getDataSources"));
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayList();
        for (VirtualFile file : root.getChildren()) {
            if (!file.isDirectory()) continue;
            res.add(file.getName());
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getDataSources"));
        }
        return arrayList;
    }

    public boolean exists(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "exists"));
        }
        return this.getRoot(dataSourceId) != null;
    }

    @Nullable
    public String getDataSourceId(@Nullable VirtualFile file) {
        VirtualFile folder = this.getDataSourceFolder(file);
        return folder == null ? null : folder.getName();
    }

    @Nullable
    public VirtualFile getDataSourceFolder(@Nullable VirtualFile file) {
        VirtualFile prev;
        VirtualFile root;
        if (file != null && file.getFileSystem() instanceof ArchiveFileSystem) {
            file = VfsUtilCore.getVirtualFileForJar((VirtualFile)file);
        }
        if ((root = this.getStorageRoot()) == null || file == null || file.equals(root)) {
            return null;
        }
        do {
            prev = file;
        } while ((file = file.getParent()) != null && !file.equals(root));
        return file == null ? null : prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DbDataSourceLayout getLayout(@NotNull String dataSourceId) {
        DbDataSourceLayout layout;
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        SoftFactoryMap<String, DbDataSourceLayout> softFactoryMap = this.myDsLayouts;
        synchronized (softFactoryMap) {
            layout = (DbDataSourceLayout)ObjectUtils.assertNotNull((Object)this.myDsLayouts.get((Object)dataSourceId));
        }
        LocalDataSource source = DbSrcChangesTracker.findDataSource(this.myProject, dataSourceId);
        if (layout.getMetaModel() == null && source != null) {
            SqlLanguageDialect lang;
            String defaultDialect = source.getDefaultDialect();
            SqlLanguageDialect sqlLanguageDialect = lang = StringUtil.isEmpty((String)defaultDialect) ? null : DbSqlUtil.findDialectById(defaultDialect);
            if (lang == null) {
                lang = DbSqlUtil.getGenericDialect();
            }
            layout.updateSettings(lang, ((DatabaseDialectEx)lang.getDatabaseDialect()).getMetaModel());
        }
        DbDataSourceLayout dbDataSourceLayout = layout;
        if (dbDataSourceLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getLayout"));
        }
        return dbDataSourceLayout;
    }

    @Nullable(value="storage is empty")
    public @Nullable(value="storage is empty") VirtualFile getStorageRoot() {
        return this.myFsAccess.findFileByPath(this.myStorageRoot);
    }

    @Nullable
    public VirtualFile getRoot(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getRoot"));
        }
        return this.myFsAccess.findFileByPath(this.buildPath(dataSourceId));
    }

    @NotNull
    public String buildPath(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        String string = this.myStorageRoot + "/" + dataSourceId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "buildPath"));
        }
        return string;
    }

    @NotNull
    public static String getStorageRoot(@Nullable Project project) {
        String storage = DataSourceStorage.getStoragePath(project);
        if (storage == null && project != null) {
            storage = project.getProjectFilePath();
        }
        if (storage == null) {
            storage = PathManager.getOptionsPath() + "/dummy";
        }
        String string = new File(new File(storage).getParentFile(), "dataSources").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorage", "getStorageRoot"));
        }
        return string;
    }

    public static boolean isStored(@Nullable DasObject obj) {
        return obj != null && ourKinds.contains(obj.getKind());
    }

    public static class App
    extends DbSrcStorage {
        public App(@NotNull FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$App", "<init>"));
            }
            super(null, fs);
        }

        public App() {
            super(null);
        }
    }

    public static class FsAccess {
        public static final FsAccess INSTANCE = new FsAccess();

        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "findFileByPath"));
            }
            return LocalFileSystem.getInstance().findFileByPath(path);
        }

        @Nullable
        public VirtualFile getJarRootForLocalFile(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getJarRootForLocalFile"));
            }
            return JarFileSystem.getInstance().getJarRootForLocalFile(file);
        }

        @Nullable
        public VirtualFile getLocalFileForJarEntry(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "getLocalFileForJarEntry"));
            }
            return JarFileSystem.getInstance().getLocalByEntry(file);
        }

        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorage$FsAccess", "refreshAndFindFileByPath"));
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
    }

    private static class LazyData {
        public static final boolean STORAGE_ENABLED;

        private LazyData() {
        }

        static {
            ApplicationManager.getApplication().getComponent(RegistryState.class);
            STORAGE_ENABLED = Registry.is((String)"database.src_storage.enabled", (boolean)false);
        }
    }
}

