/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParameterEditorModel;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlEditorModel
extends UrlEditorModelBase {
    private final List<ParameterEditorModel> myGroups;
    private int myActive;
    private String myUrl;
    private int myPrevActive;
    private boolean myColdStart;

    public UrlEditorModel(@NotNull Collection<StatelessJdbcUrlParser> parsers) {
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/template/UrlEditorModel", "<init>"));
        }
        this.myUrl = "";
        this.myColdStart = true;
        MultiMap grouped = MultiMap.createLinked();
        for (StatelessJdbcUrlParser parser : parsers) {
            grouped.putValue((Object)parser.getName(), (Object)parser);
        }
        this.myGroups = ContainerUtil.newArrayListWithCapacity((int)grouped.keySet().size());
        for (String name : grouped.keySet()) {
            this.myGroups.add(new ParameterEditorModel(name, grouped.get((Object)name)));
        }
        this.myGroups.add(new ParameterEditorModel("URL only", Collections.emptyList()));
        this.myActive = this.myPrevActive = this.getDefaultIdx();
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/UrlEditorModel", "setUrl"));
        }
        if (this.myUrl.equals(url)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        this.myUrl = url;
    }

    @NotNull
    private ParameterEditorModel getActiveGroup() {
        ParameterEditorModel parameterEditorModel = this.myGroups.get(this.myActive);
        if (parameterEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getActiveGroup"));
        }
        return parameterEditorModel;
    }

    public void setParameter(@NotNull String param, @NotNull String value) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/UrlEditorModel", "setParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/UrlEditorModel", "setParameter"));
        }
        this.getActiveGroup().setParameter(param, value);
        if (this.getActiveGroup().getState() == UrlEditorModelBase.State.PARAMS_CHANGED) {
            this.invalidate(UrlEditorModelBase.State.PARAMS_CHANGED);
        }
    }

    public boolean commit(@Nullable Object arg) {
        if (this.getState() == UrlEditorModelBase.State.VALID && this.myPrevActive == this.myActive) {
            assert (this.getActiveGroup().getState() == UrlEditorModelBase.State.VALID);
            return false;
        }
        boolean changed = false;
        if (this.getState() == UrlEditorModelBase.State.URL_CHANGED) {
            if (this.myPrevActive == this.myActive || this.myColdStart) {
                changed = this.chooseGroup();
            }
            this.getActiveGroup().setUrl(this.myUrl);
        }
        changed |= this.getActiveGroup().commit(arg);
        if (!this.myUrl.equals(this.getActiveGroup().getUrl())) {
            changed = true;
            this.myUrl = this.getActiveGroup().getUrl();
        }
        boolean bl = this.myPrevActive != this.myActive;
        this.myPrevActive = this.myActive;
        this.myColdStart = false;
        return this.validate(changed |= bl, arg);
    }

    @Nullable
    public StatelessJdbcUrlParser getMeaningfullParser() {
        if (!this.isUrlOnly()) {
            return this.getCurrentParser();
        }
        for (ParameterEditorModel group : this.myGroups) {
            StatelessJdbcUrlParser parser = group.getMeaningfullParser(this.getUrl());
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    private boolean chooseGroup() {
        if (!this.myColdStart && this.getActiveGroup().isUrlValueValid(this.myUrl)) {
            return false;
        }
        int i = 0;
        while (i + 1 < this.myGroups.size()) {
            ParameterEditorModel group = this.myGroups.get(i);
            if ((this.myColdStart || i != this.myActive) && group.isUrlValueValid(this.myUrl)) {
                this.myActive = i;
                return true;
            }
            ++i;
        }
        return false;
    }

    @NotNull
    public String getUrl() {
        assert (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED);
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getUrl"));
        }
        return string;
    }

    public int getActiveGroupId() {
        return this.myActive;
    }

    @NotNull
    public String getGroupName(int id) {
        String string = this.myGroups.get(id).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getGroupName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getParameter"));
        }
        return this.getActiveGroup().getParameter(param);
    }

    @Override
    @Nullable
    protected StatelessParametersHolder getParametersHolderDelegate() {
        return this.getActiveGroup();
    }

    public int getGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public StatelessParametersHolder getGroup(int i) {
        StatelessParametersHolder statelessParametersHolder = this.myGroups.get(i);
        if (statelessParametersHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getGroup"));
        }
        return statelessParametersHolder;
    }

    private boolean isValidUrlValue(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/UrlEditorModel", "isValidUrlValue"));
        }
        if (!this.isUrlOnly() && this.getActiveGroup().isUrlValueValid(url)) {
            return true;
        }
        int i = 0;
        while (i + 1 < this.myGroups.size()) {
            ParameterEditorModel group = this.myGroups.get(i);
            if (i != this.myActive && group.isUrlValueValid(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void assign(@NotNull UrlEditorModel source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/url/template/UrlEditorModel", "assign"));
        }
        String url = source.getUrl();
        if (this.isValidUrlValue(url) || source.isUrlOnly() || !source.isParserValid()) {
            this.setUrl(url);
            return;
        }
        int covering = -1;
        for (int i = 0; i < this.myGroups.size(); ++i) {
            if (!UrlEditorModel.commonParameters(source, this.myGroups.get(i), true)) continue;
            covering = i;
            break;
        }
        if (covering == -1) {
            this.setUrl(url);
            return;
        }
        this.myActive = covering;
        UrlEditorModel.transferParameters(source, this);
    }

    private static boolean commonParameters(@NotNull ParametersHolder source, @NotNull StatelessParametersHolder parameters, boolean covers) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/url/template/UrlEditorModel", "commonParameters"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dataSource/url/template/UrlEditorModel", "commonParameters"));
        }
        HashSet parserParams = ContainerUtil.newHashSet(parameters.getParameters());
        for (String s : source.getParameters()) {
            if (StringUtil.isEmpty((String)source.getParameter(s)) || parserParams.contains(s) == covers) continue;
            return !covers;
        }
        return covers;
    }

    private static void transferParameters(@NotNull ParametersHolder source, @NotNull UrlEditorModel target) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dataSource/url/template/UrlEditorModel", "transferParameters"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/url/template/UrlEditorModel", "transferParameters"));
        }
        for (String s : source.getParameters()) {
            String parameter = source.getParameter(s);
            if (parameter == null) continue;
            target.setParameter(s, parameter);
        }
    }

    @NotNull
    public Collection<TextRange> getInvalidRanges() {
        Collection<TextRange> collection = this.getActiveGroup().getInvalidRanges();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getInvalidRanges"));
        }
        return collection;
    }

    @Nullable
    public TextRange getParameterRange(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/UrlEditorModel", "getParameterRange"));
        }
        return this.getActiveGroup().getParameterRange(param);
    }

    public void selectGroup(int group) {
        if (this.myActive == group) {
            return;
        }
        ParameterEditorModel cur = this.myGroups.get(group);
        ParameterEditorModel prev = this.getActiveGroup();
        this.myActive = group;
        if (!cur.isUrlValueValid(this.myUrl) && UrlEditorModel.commonParameters(prev, cur, false)) {
            UrlEditorModel.transferParameters(prev, this);
        } else {
            cur.setUrl(this.myUrl);
            this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        }
    }

    public boolean isParserValid() {
        return this.getActiveGroup().isParserValid();
    }

    @Nullable
    public StatelessJdbcUrlParser getCurrentParser() {
        return this.getActiveGroup().getActiveParser();
    }

    public boolean isUrlOnly() {
        return this.myActive + 1 == this.myGroups.size();
    }

    public void setUrlOnly(boolean only) {
        if (only == this.isUrlOnly()) {
            return;
        }
        this.selectGroup(only ? this.myGroups.size() - 1 : this.getDefaultIdx());
        this.myColdStart = !only;
    }

    private int getDefaultIdx() {
        for (int i = 0; i < this.myGroups.size(); ++i) {
            if (!this.myGroups.get(i).getName().equals("default")) continue;
            return i;
        }
        return 0;
    }
}

