/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseConfigValidator {
    public static final ExtensionPointName<DatabaseConfigValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.configValidator");

    public abstract void findProblems(@NotNull Object var1, @NotNull Consumer<DataSourceProblem> var2, @NotNull Control var3);

    public static Set<DataSourceProblem> getProblems(@NotNull Object dataSource, @NotNull Control control) {
        DatabaseConfigValidator[] extensions;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/DatabaseConfigValidator", "getProblems"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseConfigValidator", "getProblems"));
        }
        HashSet result = ContainerUtil.newHashSet();
        Consumer consumer = result::add;
        for (DatabaseConfigValidator extension : extensions = (DatabaseConfigValidator[])Extensions.getExtensions(EP_NAME)) {
            extension.findProblems(dataSource, (Consumer<DataSourceProblem>)consumer, control);
        }
        return result;
    }

    public static abstract class Typed<E>
    extends DatabaseConfigValidator {
        private final Class<E> myClass;

        public Typed(Class<E> clazz) {
            this.myClass = clazz;
        }

        @Override
        public void findProblems(@NotNull Object dataSource, @NotNull Consumer<DataSourceProblem> problems, @NotNull Control control) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/DatabaseConfigValidator$Typed", "findProblems"));
            }
            if (problems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseConfigValidator$Typed", "findProblems"));
            }
            if (control == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseConfigValidator$Typed", "findProblems"));
            }
            Object dataSourceTyped = ObjectUtils.tryCast((Object)dataSource, this.myClass);
            if (dataSourceTyped != null) {
                this.findProblemsTyped(dataSourceTyped, problems, control);
            }
        }

        public abstract void findProblemsTyped(@NotNull E var1, @NotNull Consumer<DataSourceProblem> var2, @NotNull Control var3);
    }

    public static interface Control {
        @NotNull
        public <T> T actualize(@NotNull T var1, boolean var2);

        public void changed(@NotNull Object var1);
    }
}

