/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverValidator
extends DatabaseConfigValidator.Typed<DatabaseDriverImpl> {
    public DatabaseDriverValidator() {
        super(DatabaseDriverImpl.class);
    }

    @Override
    public void findProblemsTyped(@NotNull DatabaseDriverImpl baseDriver, @NotNull Consumer<DataSourceProblem> problems, @NotNull DatabaseConfigValidator.Control control) {
        if (baseDriver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDriver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findProblemsTyped"));
        }
        DatabaseDriverImpl driver = control.actualize(baseDriver, false);
        if (!driver.getTemplatesErrors().isEmpty()) {
            StringBuilder msg = new StringBuilder();
            for (Pair<UrlTemplate, String> pair : driver.getTemplatesErrors()) {
                msg.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                msg.append(StringUtil.escapeXml((String)((UrlTemplate)pair.getFirst()).getName())).append(" &mdash; ").append(StringUtil.escapeXml((String)((String)pair.getSecond())));
            }
            String shortDesc = msg.toString();
            String longDesc = "Driver <a href=\"$ACTION0\">" + StringUtil.escapeXml((String)driver.getFullName()) + "</a> has invalid templates:" + shortDesc;
            problems.consume((Object)new DataSourceProblem((Object)driver, null, "Invalid template", shortDesc, longDesc, null, new DataSourceProblem.Navigate(driver)));
        }
    }

    public static void findDriverFilesProblems(@Nullable DatabaseDriver baseDriver, @NotNull Consumer<DataSourceProblem> problems, @NotNull DatabaseConfigValidator.Control control) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "findDriverFilesProblems"));
        }
        if (baseDriver == null) {
            return;
        }
        DatabaseDriver driver = control.actualize(baseDriver, false);
        if (StringUtil.isNotEmpty((String)driver.getArtifactName())) {
            boolean needDownload;
            DatabaseArtifactManager.getInstance();
            String title = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)driver.getArtifactName()) + " files"});
            NamedProgressive download = NamedProgressive.named(title, indicator -> {
                if (control == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$findDriverFilesProblems$1"));
                }
                DatabaseDriver actual = control.actualize(baseDriver, true);
                if (actual.getArtifactName() == null) {
                    return;
                }
                while (!indicator.isCanceled()) {
                    try {
                        String prevVer = actual.getArtifactVersion();
                        String ver = DatabaseArtifactManager.getInstance().downloadLatest(actual.getArtifactName(), (Consumer<String>)((Consumer)current -> {
                            if (control == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "control", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "lambda$null$0"));
                            }
                            if (!Comparing.equal((String)prevVer, (String)current)) {
                                control.changed(actual);
                            }
                        }));
                        if (ver == null) break;
                        ((DatabaseDriverImpl)actual).setArtifact(actual.getArtifactName(), ver);
                    }
                    catch (IOException e) {
                        String msg = IdeBundle.message((String)"progress.download.0.title", (Object[])new Object[]{StringUtil.capitalize((String)actual.getArtifactName()) + " files"});
                        boolean retry = IOExceptionDialog.showErrorDialog((String)msg, (String)e.getMessage());
                        if (retry) continue;
                    }
                    break;
                }
            });
            String driverName = StringUtil.escapeXml((String)driver.getFullName());
            String actualVersion = DatabaseArtifactManager.getInstance().getActualVersion(driver.getArtifactName());
            boolean bl = needDownload = !driver.isDownloaded() || driver.getClasspathElements().isEmpty();
            if (needDownload) {
                problems.consume((Object)new DataSourceProblem((Object)driver, null, "", "<a href=\"$ACTION0\">Download</a> missing driver files", "Download missing <a href=\"$ACTION1\">" + driverName + "</a> driver files", download, download, new DataSourceProblem.Navigate(driver)));
            } else if (actualVersion != null && !DatabaseDriverValidator.isActual(driver, actualVersion)) {
                problems.consume((Object)new DataSourceProblem((Object)driver, null, "", "<a href=\"$ACTION0\">Update</a> driver files", "Update <a href=\"$ACTION1\">" + driverName + "</a> driver files", download, download, new DataSourceProblem.Navigate(driver)));
            }
        }
    }

    static boolean isActual(@NotNull DatabaseDriver driver, @NotNull String actualVersion) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isActual"));
        }
        if (actualVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualVersion", "com/intellij/database/dataSource/validation/DatabaseDriverValidator", "isActual"));
        }
        if (driver.getArtifactName() == null || !driver.isUseArtifact() || Comparing.equal((String)driver.getArtifactVersion(), (String)actualVersion)) {
            return true;
        }
        if (driver.getArtifactVersion() != null) {
            return false;
        }
        JBIterable urls = JBIterable.from(driver.getClasspathElements()).flatten(SimpleClasspathElement::getClassesRootUrls);
        if (!urls.filter(url -> !FileUtil.exists((String)VfsUtilCore.urlToPath((String)url))).isEmpty()) {
            return false;
        }
        return DatabaseArtifactManager.getInstance().isFreshFiles(driver.getArtifactName(), urls.transform(VfsUtil::extractFileName).toSet());
    }
}

