/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataAuditor {
    public void print(@NotNull DataRequest.Context var1, @Nullable String var2);

    public void warn(@NotNull DataRequest.Context var1, @Nullable String var2);

    public void error(@NotNull DataRequest.Context var1, @Nullable String var2, @Nullable Throwable var3);

    public void requestStarted(@NotNull DataRequest.Context var1);

    public void updateCountReceived(@NotNull DataRequest.Context var1, int var2);

    public void fetchStarted(@NotNull DataRequest.Context var1, int var2);

    public void fetchFinished(@NotNull DataRequest.Context var1, int var2, int var3);

    public void requestFinished(@NotNull DataRequest.Context var1);

    public void txCompleted(@NotNull DataRequest.Context var1, boolean var2);

    public void jobSubmitted(@NotNull DataRequest var1, @NotNull DataProducer var2);

    public void jobFinished(@NotNull DataRequest var1, @NotNull DataProducer var2);

    public static class ConsoleLogger
    extends Adapter {
        public final ConsoleView consoleView;

        public ConsoleLogger(ConsoleView consoleView) {
            this.consoleView = consoleView;
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$ConsoleLogger", "print"));
            }
            this.print(message);
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$ConsoleLogger", "warn"));
            }
            this.print(message, ConsoleViewContentType.SYSTEM_OUTPUT);
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$ConsoleLogger", "error"));
            }
            this.error(message, th);
        }

        @NotNull
        protected String getMessagePrefix() {
            String string = DataSourceUiUtil.currentTime();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataAuditor$ConsoleLogger", "getMessagePrefix"));
            }
            return string;
        }

        public void printInput(String message) {
            this.consoleView.print(message, ConsoleViewContentType.USER_INPUT);
            this.newLine();
        }

        public void print(String message) {
            this.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
        }

        public void error(String message, Throwable th) {
            if (message != null) {
                this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
            }
            if (th != null) {
                this.printError(th);
            }
        }

        public void printError(Throwable throwable) {
            this.error(ExceptionUtil.getUserStackTrace((Throwable)throwable, (Logger)AbstractQueryLanguageConsole.LOG), null);
        }

        public void print(String message, ConsoleViewContentType output) {
            if (!StringUtil.isEmptyOrSpaces((String)message)) {
                this.consoleView.print(this.getMessagePrefix() + message, output);
            }
            this.newLine();
        }

        public void newLine() {
            this.consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }

        public void scrollToEnd() {
            if (this.consoleView instanceof ConsoleViewImpl) {
                DbUIUtil.invokeLater(() -> ((ConsoleViewImpl)this.consoleView).scrollToEnd());
            }
        }
    }

    public static class BusyCounter
    extends Adapter {
        private final AtomicInteger count = new AtomicInteger();

        public BusyCounter(DataRequest.OwnerEx owner) {
            owner.getMessageBus().addAuditor(this);
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$BusyCounter", "jobSubmitted"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$BusyCounter", "jobSubmitted"));
            }
            this.update(this.count.incrementAndGet());
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$BusyCounter", "jobFinished"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$BusyCounter", "jobFinished"));
            }
            this.update(this.count.decrementAndGet());
        }

        public int getCount() {
            return this.count.intValue();
        }

        protected void update(int current) {
        }
    }

    public static class Wrapper
    implements DataAuditor {
        public final DataAuditor delegate;

        public Wrapper(DataAuditor delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        protected boolean accepts(DataRequest.Context context) {
            return this.accepts(context.request.owner);
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "print"));
            }
            if (this.accepts(context)) {
                this.delegate.print(context, message);
            }
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "warn"));
            }
            if (this.accepts(context)) {
                this.delegate.warn(context, message);
            }
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "error"));
            }
            if (this.accepts(context)) {
                this.delegate.error(context, message, th);
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "requestStarted"));
            }
            if (this.accepts(context)) {
                this.delegate.requestStarted(context);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "updateCountReceived"));
            }
            if (this.accepts(context)) {
                this.delegate.updateCountReceived(context, updateCount);
            }
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "fetchStarted"));
            }
            if (this.accepts(context)) {
                this.delegate.fetchStarted(context, index);
            }
        }

        @Override
        public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "fetchFinished"));
            }
            if (this.accepts(context)) {
                this.delegate.fetchFinished(context, index, rowCount);
            }
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "requestFinished"));
            }
            if (this.accepts(context)) {
                this.delegate.requestFinished(context);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, boolean committed) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Wrapper", "txCompleted"));
            }
            if (this.accepts(context)) {
                this.delegate.txCompleted(context, committed);
            }
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$Wrapper", "jobSubmitted"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$Wrapper", "jobSubmitted"));
            }
            if (this.accepts(request.owner)) {
                this.delegate.jobSubmitted(request, producer);
            }
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$Wrapper", "jobFinished"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$Wrapper", "jobFinished"));
            }
            if (this.accepts(request.owner)) {
                this.delegate.jobFinished(request, producer);
            }
        }
    }

    public static abstract class Adapter
    implements DataAuditor {
        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "print"));
            }
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "warn"));
            }
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "error"));
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "requestStarted"));
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "updateCountReceived"));
            }
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "fetchStarted"));
            }
        }

        @Override
        public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "fetchFinished"));
            }
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "requestFinished"));
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, boolean committed) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataAuditor$Adapter", "txCompleted"));
            }
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$Adapter", "jobSubmitted"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$Adapter", "jobSubmitted"));
            }
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataAuditor$Adapter", "jobFinished"));
            }
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/database/datagrid/DataAuditor$Adapter", "jobFinished"));
            }
        }
    }
}

