/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.model.DasTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.vfs.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public abstract class DataRequest {
    public static final TxMarker NONE = DataRequest.newTxMarker("NONE", null);
    public static final TxMarker AUTO_COMMIT = DataRequest.newTxMarker("AUTO_COMMIT", null);
    public static final TxMarker START_NEW = DataRequest.newTxMarker("START_NEW", null);
    public final Owner owner;
    public final TxMarker txMarker;
    private final AsyncPromise<Void> promise;

    @NotNull
    public AsyncPromise<Void> getPromise() {
        AsyncPromise<Void> asyncPromise = this.promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "getPromise"));
        }
        return asyncPromise;
    }

    @NotNull
    public static Owner newOwner() {
        final String title = "Owner:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        Owner owner = new Owner(){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$1", "getDisplayName"));
                }
                return string;
            }
        };
        if (owner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newOwner"));
        }
        return owner;
    }

    @NotNull
    public static OwnerEx newOwnerEx(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DataRequest", "newOwnerEx"));
        }
        final String title = "OwnerEx:" + ((Class)ObjectUtils.assertNotNull((Object)ReflectionUtil.findCallerClass((int)2))).getSimpleName();
        OwnerEx ownerEx = new OwnerEx(){
            final DataBus.Consuming messageBus;
            {
                this.messageBus = SimpleRequestBroker.newInstance(project, title).filterFor(this);
            }

            @Override
            public DataBus.Consuming getMessageBus() {
                return this.messageBus;
            }

            @Override
            @NotNull
            public TxMarker getCurrentTx() {
                TxMarker txMarker = NONE;
                if (txMarker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$2", "getCurrentTx"));
                }
                return txMarker;
            }

            @Override
            public void setAutoCommit(boolean autoCommit) {
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = title;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$2", "getDisplayName"));
                }
                return string;
            }

            public void dispose() {
            }

            public String toString() {
                return this.getDisplayName();
            }
        };
        if (ownerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newOwnerEx"));
        }
        return ownerEx;
    }

    @NotNull
    public static TxMarker getInitialTxMarker(boolean autoCommit) {
        TxMarker txMarker = autoCommit ? AUTO_COMMIT : START_NEW;
        if (txMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "getInitialTxMarker"));
        }
        return txMarker;
    }

    @NotNull
    public static TxMarker newTxMarker(final @NotNull String title, final @Nullable Owner owner) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/datagrid/DataRequest", "newTxMarker"));
        }
        TxMarker txMarker = new TxMarker(){

            @Override
            public Owner getOwner() {
                return owner;
            }

            @Override
            @NotNull
            public String toString() {
                String string = title;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$3", "toString"));
                }
                return string;
            }
        };
        if (txMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newTxMarker"));
        }
        return txMarker;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        DataRequest dataRequest = DataRequest.newRequest(owner, owner.getCurrentTx(), "");
        if (dataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        return dataRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        QueryRequest queryRequest = new QueryRequest(owner, marker, query, DataRequest.newConstraints(0, -1, -1), null);
        if (queryRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        QueryRequest queryRequest = new QueryRequest(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(), null);
        if (queryRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull OwnerEx owner, @NotNull String query, int start, boolean forward, int pageSize, int resultSetIndex) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        QueryRequest queryRequest = new QueryRequest(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(start, forward, pageSize, resultSetIndex), null);
        if (queryRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newRequest(@NotNull Owner owner, @NotNull TxMarker txMarker, @NotNull String query, @NotNull Constraints constraints) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        QueryRequest queryRequest = new QueryRequest(owner, txMarker, query, constraints, null);
        if (queryRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newRequest"));
        }
        return queryRequest;
    }

    @NotNull
    public static DataRequest newInsertRequest(@NotNull OwnerEx owner, @NotNull DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newInsertRequest"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DataRequest", "newInsertRequest"));
        }
        InsertRequest insertRequest = new InsertRequest(owner, owner.getCurrentTx(), table, columns, rows);
        if (insertRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newInsertRequest"));
        }
        return insertRequest;
    }

    @NotNull
    public static DataRequest newUpdateRequest(@NotNull OwnerEx owner, @NotNull DasTable table, @NotNull List<DataConsumer.Column> columns, @NotNull List<DataConsumer.Row> rows, DataConsumer.Column column, Object value) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        DataRequest dataRequest = DataRequest.newUpdateRequest(owner, table, columns, rows, ContainerUtil.newSmartList((Object)column), value);
        if (dataRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        return dataRequest;
    }

    @NotNull
    public static DataRequest newUpdateRequest(@NotNull OwnerEx owner, @NotNull DasTable table, @NotNull List<DataConsumer.Column> columns, List<DataConsumer.Row> rows, List<DataConsumer.Column> columnsToUpdate, Object value) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        UpdateRequest updateRequest = new UpdateRequest(owner, owner.getCurrentTx(), table, columns, rows, columnsToUpdate, value);
        if (updateRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newUpdateRequest"));
        }
        return updateRequest;
    }

    @NotNull
    public static DataRequest newDeleteRequest(@NotNull OwnerEx owner, @NotNull DasTable table, @NotNull List<DataConsumer.Column> columns, @NotNull List<DataConsumer.Row> rows) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newDeleteRequest"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/DataRequest", "newDeleteRequest"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/datagrid/DataRequest", "newDeleteRequest"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/DataRequest", "newDeleteRequest"));
        }
        DeleteRequest deleteRequest = new DeleteRequest(owner, owner.getCurrentTx(), table, columns, rows);
        if (deleteRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newDeleteRequest"));
        }
        return deleteRequest;
    }

    @NotNull
    public static DataRequest newTxCommit(@NotNull OwnerEx owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newTxCommit"));
        }
        TxRequest txRequest = new TxRequest(owner, owner.getCurrentTx(), TxCommand.COMMIT);
        if (txRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newTxCommit"));
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newTxRollback(@NotNull OwnerEx owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newTxRollback"));
        }
        TxRequest txRequest = new TxRequest(owner, owner.getCurrentTx(), TxCommand.ROLLBACK);
        if (txRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newTxRollback"));
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newTxRollback(@NotNull TxMarker txMarker) {
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/datagrid/DataRequest", "newTxRollback"));
        }
        TxRequest txRequest = new TxRequest(txMarker.getOwner(), txMarker, TxCommand.ROLLBACK);
        if (txRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newTxRollback"));
        }
        return txRequest;
    }

    @NotNull
    public static DataRequest newSchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath schema, boolean forced) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newSchemaSwitchRequest"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/datagrid/DataRequest", "newSchemaSwitchRequest"));
        }
        SchemaSwitchRequest schemaSwitchRequest = new SchemaSwitchRequest(owner, schema, forced);
        if (schemaSwitchRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newSchemaSwitchRequest"));
        }
        return schemaSwitchRequest;
    }

    @NotNull
    public static Context newContext(@NotNull OwnerEx owner, @Nullable DataProducer producer, String query) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "newContext"));
        }
        Context context = new Context(producer, DataRequest.newRequest(owner, query), NONE){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/datagrid/DataRequest$4", "reportException"));
                }
            }
        };
        if (context == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newContext"));
        }
        return context;
    }

    @NotNull
    public static Context newContext(@NotNull String query) {
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest", "newContext"));
        }
        Context context = new Context(null, DataRequest.newRequest(DataRequest.newOwner(), NONE, query, DataRequest.newConstraints()), NONE){

            @Override
            public void reportException(@NotNull Throwable th, Object parameter) {
                if (th == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "th", "com/intellij/database/datagrid/DataRequest$5", "reportException"));
                }
            }
        };
        if (context == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest", "newContext"));
        }
        return context;
    }

    public static Constraints newConstraints() {
        return DataRequest.newConstraints(1, DatabaseSettings.getSettings().getPageSize(), 0);
    }

    public static Constraints newConstraints(int offset, int limit, int resultSetIndex) {
        return new Constraints(offset, limit, true, "", resultSetIndex, Collections.emptyList());
    }

    public static Constraints newConstraints(int offset, boolean forward, int limit, int resultSetIndex) {
        return new Constraints(offset, limit, forward, "", resultSetIndex, Collections.emptyList());
    }

    protected DataRequest(@NotNull Owner owner, @NotNull TxMarker txMarker) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest", "<init>"));
        }
        if (txMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/datagrid/DataRequest", "<init>"));
        }
        this.promise = new AsyncPromise();
        this.owner = owner;
        this.txMarker = txMarker;
    }

    public void accept(Visitor visitor) {
        visitor.visitRequest(this);
    }

    public static abstract class Visitor {
        public void visitRequest(DataRequest r) {
        }

        public void visitCancel(Cancel r) {
            this.visitRequest(r);
        }

        public void visitTx(TxRequest r) {
            this.visitRequest(r);
        }

        public void visitDml(DmlRequest r) {
            this.visitRequest(r);
        }

        public void visitInsert(InsertRequest r) {
            this.visitDml(r);
        }

        public void visitUpdate(UpdateRequest r) {
            this.visitDml(r);
        }

        public void visitDelete(DeleteRequest r) {
            this.visitDml(r);
        }

        public void visitRaw(RawRequest r) {
            this.visitRequest(r);
        }

        public void visitQuery(QueryRequest r) {
            this.visitRequest(r);
        }

        public void visitSchemaSwitch(SchemaSwitchRequest r) {
            this.visitRequest(r);
        }
    }

    public static class Constraints {
        public final int offset;
        public final int limit;
        public final String filter;
        public final int resultSetNumber;
        public final List<RowSortOrder<String>> orders;

        public Constraints(int offset, int limit, boolean forward, String filter, int resultSetNumber, List<RowSortOrder<String>> orders) {
            this.offset = forward ? (offset == 0 ? 1 : offset) : Math.max(offset - limit, 0);
            this.limit = limit;
            this.filter = filter;
            this.resultSetNumber = resultSetNumber;
            this.orders = orders;
        }
    }

    public static abstract class Context {
        public final DataProducer producer;
        public final DataRequest request;
        public final TxMarker txMarker;
        public final Ref<String> query;

        public Context(@Nullable DataProducer producer, @NotNull DataRequest request, @NotNull TxMarker txMarker) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/datagrid/DataRequest$Context", "<init>"));
            }
            if (txMarker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "txMarker", "com/intellij/database/datagrid/DataRequest$Context", "<init>"));
            }
            this.query = Ref.create();
            this.producer = producer;
            this.request = request;
            this.txMarker = txMarker;
        }

        @NotNull
        public String getQuery() {
            String string = this.request instanceof QueryRequest ? ((QueryRequest)this.request).query : StringUtil.notNullize((String)((String)this.query.get()));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataRequest$Context", "getQuery"));
            }
            return string;
        }

        public abstract void reportException(@NotNull Throwable var1, @Nullable Object var2);

        public String toString() {
            return this.request + " in " + this.txMarker;
        }
    }

    public static interface TxMarker {
        @Nullable
        public Owner getOwner();

        @NotNull
        public String toString();
    }

    public static interface OwnerEx
    extends Owner,
    Disposable {
        public DataBus.Consuming getMessageBus();

        @NotNull
        public TxMarker getCurrentTx();

        public void setAutoCommit(boolean var1);
    }

    public static interface Owner {
        @NotNull
        public String getDisplayName();
    }

    public static abstract class RawQueryRequest
    extends IsolatedQueryRequest {
        protected RawQueryRequest(Owner owner, TxMarker txMarker, String query, Constraints constraints) {
            super(owner, txMarker, query, constraints, null);
        }

        @Override
        public void setColumns(@NotNull Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataRequest$RawQueryRequest", "setColumns"));
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataRequest$RawQueryRequest", "afterLastRowAdded"));
            }
        }
    }

    public static abstract class IsolatedQueryRequest
    extends QueryRequest
    implements DataConsumer {
        protected IsolatedQueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest", "<init>"));
            }
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest", "<init>"));
            }
            if (constraints == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/datagrid/DataRequest$IsolatedQueryRequest", "<init>"));
            }
            super(owner, marker, query, constraints, params);
        }
    }

    public static class UpdateRequest
    extends DmlRequest {
        public final List<DataConsumer.Column> columnsToUpdate;
        public final Object newValue;

        UpdateRequest(Owner owner, TxMarker marker, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows, List<DataConsumer.Column> columnsToUpdate, Object newValue) {
            super(owner, marker, table, columns, rows);
            this.columnsToUpdate = columnsToUpdate;
            this.newValue = newValue;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitUpdate(this);
        }
    }

    public static class DeleteRequest
    extends DmlRequest {
        DeleteRequest(Owner owner, TxMarker marker, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
            super(owner, marker, table, columns, rows);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDelete(this);
        }
    }

    public static class InsertRequest
    extends DmlRequest {
        InsertRequest(Owner owner, TxMarker marker, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
            super(owner, marker, table, columns, rows);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitInsert(this);
        }
    }

    public static abstract class DmlRequest
    extends DataRequest {
        public final DasTable table;
        public final List<DataConsumer.Column> columns;
        public final List<DataConsumer.Row> rows;

        DmlRequest(Owner owner, TxMarker marker, DasTable table, List<DataConsumer.Column> columns, List<DataConsumer.Row> rows) {
            super(owner, marker);
            this.table = table;
            this.columns = columns;
            this.rows = rows;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitDml(this);
        }
    }

    public static class QueryRequest
    extends DataRequest {
        public final String query;
        public final Constraints constraints;
        public final Object params;

        protected QueryRequest(@NotNull Owner owner, @NotNull TxMarker marker, @NotNull String query, @NotNull Constraints constraints, @Nullable Object params) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$QueryRequest", "<init>"));
            }
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/database/datagrid/DataRequest$QueryRequest", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/datagrid/DataRequest$QueryRequest", "<init>"));
            }
            if (constraints == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/datagrid/DataRequest$QueryRequest", "<init>"));
            }
            super(owner, marker);
            this.query = query;
            this.constraints = constraints;
            this.params = params;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitQuery(this);
        }

        public String toString() {
            return this.query + "@" + this.owner.getDisplayName();
        }
    }

    public static abstract class RawRequest
    extends DataRequest {
        protected RawRequest(OwnerEx owner) {
            super(owner, owner.getCurrentTx());
        }

        public abstract void processRaw(Context var1, Connection var2) throws Exception;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitRaw(this);
        }
    }

    public static class SchemaSwitchRequest
    extends DataRequest {
        public final SearchPath path;
        public final boolean forced;

        protected SchemaSwitchRequest(@NotNull OwnerEx owner, @NotNull SearchPath path, boolean forced) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$SchemaSwitchRequest", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/datagrid/DataRequest$SchemaSwitchRequest", "<init>"));
            }
            super(owner, owner.getCurrentTx());
            this.path = path;
            this.forced = forced;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSchemaSwitch(this);
        }
    }

    public static class Cancel
    extends DataRequest {
        public Cancel(@NotNull OwnerEx owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/datagrid/DataRequest$Cancel", "<init>"));
            }
            super(owner, owner.getCurrentTx());
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCancel(this);
        }
    }

    public static class TxRequest
    extends DataRequest {
        public final TxCommand command;

        TxRequest(Owner owner, TxMarker marker, TxCommand command) {
            super(owner, marker);
            this.command = command;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTx(this);
        }
    }

    public static enum TxCommand {
        COMMIT,
        ROLLBACK;

    }
}

