/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridFilteringModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridSortingModelImpl;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableGridDataHookUp
extends DatabaseGridDataHookUp {
    private final DatabaseElementVirtualFileImpl myFile;
    private final GridFilteringModelImpl myFilteringModel;
    private final GridSortingModelImpl<DataConsumer.Row, DataConsumer.Column> mySortingModel;

    DatabaseTableGridDataHookUp(@NotNull Project project, @NotNull DataBus.Consuming messageBus, @NotNull DatabaseElementVirtualFileImpl file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "<init>"));
        }
        super(project, messageBus);
        this.myFile = file;
        this.setDataSource(this.myFile.findDataSource());
        this.myFilteringModel = new GridFilteringModelImpl(this.createFilterDocument(""));
        this.myFilteringModel.setFilteringEnabled(true);
        this.mySortingModel = new GridSortingModelImpl();
        this.mySortingModel.setSortingEnabled(true);
        this.mySortingModel.addListener(new GridSortingModel.Listener(){

            @Override
            public void orderingChanged() {
                DatabaseTableGridDataHookUp.this.myLoader.invalidateQuery();
            }
        }, this);
    }

    @NotNull
    public DatabaseElementVirtualFileImpl getFile() {
        DatabaseElementVirtualFileImpl databaseElementVirtualFileImpl = this.myFile;
        if (databaseElementVirtualFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "getFile"));
        }
        return databaseElementVirtualFileImpl;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myFile.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    public GridFilteringModel getFilteringModel() {
        return this.myFilteringModel;
    }

    @Override
    @Nullable
    public GridSortingModel<DataConsumer.Row, DataConsumer.Column> getSortingModel() {
        return this.mySortingModel;
    }

    @Override
    public boolean isReadOnly() {
        return this.myFile.getObjectKind() != ObjectKind.TABLE || !this.myFile.isWritable() || super.isReadOnly();
    }

    @Override
    @Nullable
    public String getUnlimitedQueryText() {
        Pair<String, Boolean> pair = ((DatabaseGridDataHookUp.DatabaseLoader)this.myLoader).createQueryTextPure(null);
        return pair == null ? super.getUnlimitedQueryText() : (String)pair.getFirst();
    }

    @Override
    @Nullable
    public DasTable getDatabaseTable() {
        DasTable table = super.getDatabaseTable();
        if (table == null && this.myFile.isValid()) {
            table = this.myFile.findTable();
            this.setDatabaseTable(table);
        }
        return table;
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        DatabaseTableLoader databaseTableLoader = new DatabaseTableLoader();
        if (databaseTableLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "createLoader"));
        }
        return databaseTableLoader;
    }

    protected void updateFilterDocument() {
        this.myFilteringModel.setDocument(this.createFilterDocument(this.myFilteringModel.getFilterDocument().getText()));
    }

    @NotNull
    private Document createFilterDocument(String initialText) {
        DbDataSource dataSource = this.getDataSource();
        String queryText = this.getQueryText();
        Document document = null;
        if (dataSource != null && queryText != null) {
            SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(this.getDatabaseDialect());
            SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getProject());
            PsiCodeFragment filterFragment = psiFacade.createExpressionFragment((Language)sqlDialect, dataSource, initialText, queryText);
            document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)filterFragment);
        }
        Document document2 = document != null ? document : ((EditorFactory)ObjectUtils.assertNotNull((Object)EditorFactory.getInstance())).createDocument((CharSequence)"");
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp", "createFilterDocument"));
        }
        return document2;
    }

    private class DatabaseTableLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private DatabaseTableLoader() {
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] columns, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "setColumns"));
            }
            boolean columnsChanged = !this.sameColumnsAsInModel(columns);
            super.setColumns(context, resultSetIndex, columns, firstRowNum);
            if (columnsChanged) {
                DatabaseTableGridDataHookUp.this.updateFilterDocument();
            }
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "loadFirstPage"));
            }
            this.invalidateQuery();
            super.loadFirstPage(source);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "loadLastPage"));
            }
            this.invalidateQuery();
            super.loadLastPage(source);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "loadNextPage"));
            }
            this.invalidateQuery();
            super.loadNextPage(source);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "loadPreviousPage"));
            }
            this.invalidateQuery();
            super.loadPreviousPage(source);
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "updateTotalRowCount"));
            }
            this.invalidateQuery();
            super.updateTotalRowCount(source);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int startIndex) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "load"));
            }
            this.invalidateQuery();
            super.load(source, startIndex);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "applyFilter"));
            }
            if (!DatabaseTableGridDataHookUp.this.myFilteringModel.isFilteringEnabled()) {
                DatabaseTableGridDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            DatabaseTableGridDataHookUp.this.myFilteringModel.setAppliedFilterText(DatabaseTableGridDataHookUp.this.myFilteringModel.getFilterDocument().getText());
            this.invalidateQuery();
            this.invalidateRowCount();
            this.loadFirstPage(source);
        }

        @Override
        protected void appendOrderByClause(@NotNull DdlBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "appendOrderByClause"));
            }
            List ordering = DatabaseTableGridDataHookUp.this.mySortingModel.getOrdering();
            boolean orderByAdded = false;
            for (RowSortOrder order : ordering) {
                String sortOrderKeyword;
                DataConsumer.Column column = (DataConsumer.Column)DatabaseTableGridDataHookUp.this.myModel.getColumn(order.getColumn());
                String string = order.getOrder() == RowSortOrder.Type.DESC ? "DESC" : (sortOrderKeyword = order.getOrder() == RowSortOrder.Type.ASC ? "ASC" : null);
                if (column == null || StringUtil.isEmpty((String)sortOrderKeyword)) continue;
                if (!orderByAdded) {
                    builder.space().keywords("ORDER", "BY");
                    orderByAdded = true;
                } else {
                    builder.symbol(",");
                }
                builder.space().columnRef(column.name).space().keyword(sortOrderKeyword);
            }
        }

        @Override
        protected boolean appendWhereClause(@Nullable String alias, @NotNull DdlBuilder builder) {
            String filterText;
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/datagrid/DatabaseTableGridDataHookUp$DatabaseTableLoader", "appendWhereClause"));
            }
            String string = filterText = DatabaseTableGridDataHookUp.this.myFilteringModel.isFilteringEnabled() ? DatabaseTableGridDataHookUp.this.myFilteringModel.getAppliedFilterText() : "";
            if (StringUtil.isNotEmpty((String)filterText)) {
                builder.space().keyword("WHERE").space().plain(filterText);
                return true;
            }
            return false;
        }
    }
}

