/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class GridFilteringModelImpl
implements GridFilteringModel {
    private final EventDispatcher<GridFilteringModel.Listener> myEventDispatcher;
    private boolean myEnabled;
    private Document myDocument;
    private String myAppliedFilterText;

    public GridFilteringModelImpl(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/GridFilteringModelImpl", "<init>"));
        }
        this.myEventDispatcher = EventDispatcher.create(GridFilteringModel.Listener.class);
        this.myAppliedFilterText = "";
        this.myDocument = document;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myEnabled;
    }

    @Override
    public void setFilteringEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @NotNull
    public String getAppliedFilterText() {
        String string = this.myAppliedFilterText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridFilteringModelImpl", "getAppliedFilterText"));
        }
        return string;
    }

    @Override
    public void setAppliedFilterText(@NotNull String filterText) {
        if (filterText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterText", "com/intellij/database/datagrid/GridFilteringModelImpl", "setAppliedFilterText"));
        }
        this.myAppliedFilterText = filterText;
    }

    @Override
    @NotNull
    public Document getFilterDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridFilteringModelImpl", "getFilterDocument"));
        }
        return document;
    }

    @Override
    public void addListener(@NotNull GridFilteringModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/GridFilteringModelImpl", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/GridFilteringModelImpl", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    void setDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/GridFilteringModelImpl", "setDocument"));
        }
        this.myDocument = document;
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).filterDocumentChanged(this);
    }
}

