/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;

public class HandleErrorTask
implements Runnable {
    public static final List<String> POISON = ContainerUtil.emptyList();
    @NotNull
    private final Project myProject;
    @NotNull
    private final CsvFormatter myFormatter;
    @NotNull
    private final BlockingQueue<List<String>> myErrorQueue;
    @NotNull
    private final Writer myWriter;
    private volatile boolean myStopped;

    public HandleErrorTask(@NotNull Project project, @NotNull BlockingQueue<List<String>> errorQueue, @NotNull Writer writer, @NotNull CsvFormat format) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        if (errorQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorQueue", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/HandleErrorTask", "<init>"));
        }
        this.myProject = project;
        this.myErrorQueue = errorQueue;
        this.myFormatter = new CsvFormatter(format);
        this.myWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (BufferedWriter writer = new BufferedWriter(this.myWriter);){
            List<String> error;
            while ((error = this.getNextError()) != POISON) {
                writer.append(this.myFormatter.formatRecord(error));
                writer.append(this.myFormatter.getFormat().dataRecord.recordSeparator);
            }
            this.setStopped();
        }
        catch (IOException e) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Can't access file while processing error records.", NotificationType.ERROR).notify(this.myProject);
        }
        finally {
            this.finish();
        }
    }

    private void finish() {
        if (this.isStopped()) {
            return;
        }
        this.setStopped();
        this.myErrorQueue.clear();
    }

    private void setStopped() {
        this.myStopped = true;
    }

    private List<String> getNextError() {
        try {
            return this.myErrorQueue.take();
        }
        catch (InterruptedException e) {
            return POISON;
        }
    }

    public boolean isStopped() {
        return this.myStopped;
    }
}

