/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.state;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransactionStateHolder
implements TransactionStateHolder {
    private static final Logger LOG = Logger.getInstance(AbstractTransactionStateHolder.class);
    static String CHECK_CONNECTION = "Check connection and database settings and try again";
    static String ROLLBACK_ERROR = "Can't rollback changes with error records. " + CHECK_CONNECTION;
    static String SAVE_ERROR = "Can't save current transaction state. " + CHECK_CONNECTION;
    protected final boolean mySupportTransactions;
    private final boolean mySupportSavepoints;
    private final ImportInfo myInfo;
    private final ImportManager myManager;
    int myBatchCount;
    private Savepoint myLastState;

    protected AbstractTransactionStateHolder(@NotNull ImportInfo info, @NotNull ImportManager manager, boolean transactions, boolean supportSavepoints) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "<init>"));
        }
        this.mySupportTransactions = transactions;
        this.mySupportSavepoints = supportSavepoints;
        this.myInfo = info;
        this.myManager = manager;
    }

    @Override
    public void batchExecuted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchExecuted"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void batchAdded(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchAdded"));
        }
        ++this.myBatchCount;
    }

    @Override
    public void onAddBatchRecordError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "onAddBatchRecordError"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void onExecuteBatchError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "onExecuteBatchError"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public void batchStarted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "batchStarted"));
        }
        this.myBatchCount = 0;
    }

    @Override
    public boolean canExecuteBatch() {
        return this.myBatchCount > 0;
    }

    @Override
    public void committed(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "committed"));
        }
        this.myLastState = null;
        this.myBatchCount = 0;
    }

    void checkoutLastState(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "checkoutLastState"));
        }
        this.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                AbstractTransactionStateHolder.this.myLastState = connection.setSavepoint();
            }
        }, SAVE_ERROR);
    }

    void rollbackToLastState(final @NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "rollbackToLastState"));
        }
        this.run(new ThrowableRunnable<SQLException>(){

            public void run() throws SQLException {
                if (AbstractTransactionStateHolder.this.myLastState == null) {
                    connection.rollback();
                    return;
                }
                connection.rollback(AbstractTransactionStateHolder.this.myLastState);
            }
        }, ROLLBACK_ERROR);
    }

    boolean isSupportTransactions() {
        return this.mySupportTransactions;
    }

    boolean isSupportSavepoints() {
        return this.mySupportSavepoints;
    }

    void releaseLastState(final @NotNull Connection connection, @NotNull String message) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "releaseLastState"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "releaseLastState"));
        }
        try {
            this.run(new ThrowableRunnable<SQLException>(){

                public void run() throws SQLException {
                    if (AbstractTransactionStateHolder.this.myLastState == null) {
                        return;
                    }
                    connection.releaseSavepoint(AbstractTransactionStateHolder.this.myLastState);
                }
            }, message);
        }
        finally {
            this.myLastState = null;
        }
    }

    protected void lock(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "lock"));
        }
        if (!this.myInfo.shouldLockTable()) {
            return;
        }
        String lockSql = this.myManager.getLockQuery(this.myInfo.getTable());
        if (lockSql != null) {
            DbImplUtil.executeUpdate(connection, lockSql);
        }
    }

    void run(@NotNull ThrowableRunnable<SQLException> runnable, @NotNull String message) throws SQLException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "run"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/state/AbstractTransactionStateHolder", "run"));
        }
        try {
            runnable.run();
        }
        catch (SQLException e) {
            LOG.warn("Batches: " + this.myBatchCount);
            LOG.warn(message);
            LOG.warn((Throwable)e);
            throw new IllegalTransactionStateException(e, message);
        }
    }

    public static class IllegalTransactionStateException
    extends SQLException {
        public IllegalTransactionStateException(Throwable cause, String error) {
            super(error, cause);
        }
    }
}

