/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpArgumentGroup;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpDialogValidator;
import com.intellij.database.dump.dbdump.DumpPanelDecorator;
import com.intellij.database.dump.dbdump.LexemeIndicators;
import com.intellij.database.dump.dbdump.MysqlArguments;
import com.intellij.database.dump.dbdump.PgArguments;
import com.intellij.database.dump.dbdump.argument.DumpArgument;
import com.intellij.database.dump.dbdump.lexer.HelpTokenType;
import com.intellij.database.dump.dbdump.mysql.MysqlArgumentsGroup;
import com.intellij.database.dump.dbdump.mysql.MysqlDialogValidator;
import com.intellij.database.dump.dbdump.pg.PgArgumentGroup;
import com.intellij.database.dump.dbdump.pg.PgDumpDialogValidator;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum DumpConfigurationImpl implements DumpConfiguration
{
    POSTGRES(PgArgumentGroup.values(), PgArguments.HOST, PgArguments.PORT, PgArguments.USER, PgArguments.PASSWORD, PgArguments.OUT_PATH, "PGPASSWORD", "PG_DUMP_PROPERTIES", "pg_dump", (DatabaseDialect)PostgresDialect.INSTANCE){

        @Override
        @Nullable
        public String getDefaultSearchPath() {
            if (SystemInfo.isLinux) {
                return "/usr/bin/pg_dump";
            }
            if (SystemInfo.isMac) {
                return "/usr/local/bin/pg_dump";
            }
            return null;
        }

        @Override
        @NotNull
        public DumpDialogValidator getValidator() {
            PgDumpDialogValidator pgDumpDialogValidator = new PgDumpDialogValidator();
            if (pgDumpDialogValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "getValidator"));
            }
            return pgDumpDialogValidator;
        }

        @Override
        @NotNull
        public LexemeIndicators getPasswordIndicators() {
            LexemeIndicators lexemeIndicators = new LexemeIndicators(PgArguments.NO_PASSWORD, false, true);
            if (lexemeIndicators == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "getPasswordIndicators"));
            }
            return lexemeIndicators;
        }

        @Override
        @NotNull
        public List<String> tweakAutocompletion(@NotNull List<String> variants) {
            if (variants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "tweakAutocompletion"));
            }
            ContainerUtil.removeAll(variants, (Object[])PgArguments.PASSWORD);
            List<String> list = variants;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "tweakAutocompletion"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<DbElement> filterElements(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "filterElements"));
            }
            DbElement dataSource = DumpConfigurationImpl.findCommonDataSource(elements);
            if (dataSource == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "filterElements"));
                }
                return list;
            }
            ArrayList result = ContainerUtil.newArrayList((Object[])new DbElement[]{dataSource});
            List schemas = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbNamespaceImpl.class));
            List tables = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbTable.class));
            List sources = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbDataSource.class));
            if (sources.isEmpty() && tables.isEmpty() && schemas.isEmpty()) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "filterElements"));
                }
                return list;
            }
            result.addAll(schemas);
            result.addAll(tables);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "filterElements"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<String> getParameterizableArguments() {
            List list = ContainerUtil.list((Object[])new String[]{"-f", "-F", "-j", "-Z", "-E", "-n", "-N", "-S", "-t", "-T", "-d", "-h", "-p", "-U"});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "getParameterizableArguments"));
            }
            return list;
        }

        @Override
        @NotNull
        public String processParameter(@NotNull DumpCommandLineLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processParameter"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processParameter"));
            }
            String text = lexeme.getText();
            boolean isTable = ArrayUtil.contains((String)text, (String[])PgArguments.TABLE);
            boolean isSchema = ArrayUtil.contains((String)text, (String[])PgArguments.SCHEMA);
            String string = isTable ? this.processTable(parameter) : (isSchema ? this.processSimple(super.processParameter(lexeme, parameter)) : super.processParameter(lexeme, parameter));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processParameter"));
            }
            return string;
        }

        @NotNull
        private String processTable(@NotNull String parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processTable"));
            }
            List splitted = StringUtil.splitHonorQuotes((String)DbDumpUtil.unescapeAll(parameter), (char)'.');
            if (splitted.size() != 2) {
                String string = this.processSimple(parameter);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processTable"));
                }
                return string;
            }
            String string = this.processSimple((String)splitted.get(0)) + "." + this.processSimple((String)splitted.get(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processTable"));
            }
            return string;
        }

        @NotNull
        private String processSimple(@NotNull String parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processSimple"));
            }
            String processed = StringUtil.unquoteString((String)parameter).replaceAll("\"", "\"\"").replaceAll("\\\\", SystemInfo.isWindows ? "\\\\\\\\" : "\\\\");
            String string = StringUtil.isQuotedString((String)parameter) || !StringUtil.equals((CharSequence)parameter, (CharSequence)StringUtil.toLowerCase((String)parameter)) ? StringUtil.wrapWithDoubleQuote((String)processed) : processed;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "processSimple"));
            }
            return string;
        }

        @Override
        @NotNull
        public Map<String, String> getInfoMap() {
            HashMap map = ContainerUtil.newHashMap();
            DumpConfigurationImpl.put(map, "Dump only the data", PgArguments.DATA_ONLY);
            DumpConfigurationImpl.put(map, "Include blobs in the dump", PgArguments.BLOBS);
            DumpConfigurationImpl.put(map, "Commands to drop database", PgArguments.CLEAN_DATABASE);
            DumpConfigurationImpl.put(map, "Commands to create database", PgArguments.CREATE_DATABASE);
            DumpConfigurationImpl.put(map, "Dump in the specified encoding", PgArguments.ENCODING);
            DumpConfigurationImpl.put(map, "Dump to the specified file", PgArguments.OUT_PATH);
            DumpConfigurationImpl.put(map, "Format of the output", PgArguments.FILE_AND_DIR);
            DumpConfigurationImpl.put(map, "Parallel jobs count", PgArguments.JOBS);
            DumpConfigurationImpl.put(map, "Dump only matched schemas", PgArguments.SCHEMA);
            DumpConfigurationImpl.put(map, "Exclude matches schemas", PgArguments.EXCLUDE_SCHEMA);
            DumpConfigurationImpl.put(map, "Dump object identifiers", PgArguments.OIDS);
            DumpConfigurationImpl.put(map, "Off ownership commands", PgArguments.NO_OWNER);
            DumpConfigurationImpl.put(map, "Obsolete", PgArguments.NO_RECONNECT);
            DumpConfigurationImpl.put(map, "only the object definitions", PgArguments.SCHEMA_ONLY);
            DumpConfigurationImpl.put(map, "Superuser user name", PgArguments.SUPERUSER);
            DumpConfigurationImpl.put(map, "Dump matched tables", PgArguments.TABLE);
            DumpConfigurationImpl.put(map, "Exclude matched tables", PgArguments.EXCLUDE_TABLE);
            DumpConfigurationImpl.put(map, "Verbose mode", PgArguments.VERBOSE);
            DumpConfigurationImpl.put(map, "Print version", PgArguments.VERSION);
            DumpConfigurationImpl.put(map, "Turn off grant/revoke", PgArguments.NO_PRIVILEGES);
            DumpConfigurationImpl.put(map, "Compression level(0..9)", PgArguments.COMPRESS);
            DumpConfigurationImpl.put(map, "For upgrade utilities", new String[]{"--binary-upgrade"});
            DumpConfigurationImpl.put(map, "Inserts with columns", PgArguments.INSERTS_WITH_COLUMNS);
            DumpConfigurationImpl.put(map, "Disable dollar quoting", new String[]{"--disable-dollar-quoting"});
            DumpConfigurationImpl.put(map, "Disable triggers", new String[]{"--disable-triggers"});
            DumpConfigurationImpl.put(map, "Set on row_security", new String[]{"--enable-row-security"});
            DumpConfigurationImpl.put(map, "Exclude matched tables data", PgArguments.EXCLUDE_TABLE_DATA);
            DumpConfigurationImpl.put(map, "Add IF EXISTS", new String[]{"--if-exists"});
            DumpConfigurationImpl.put(map, "Dump as insert commands", new String[]{"--inserts"});
            DumpConfigurationImpl.put(map, "Wait timeout to lock", PgArguments.LOCK_WAIT_TIMEOUT);
            DumpConfigurationImpl.put(map, "Exclude security labels", new String[]{"--no-security-labels"});
            DumpConfigurationImpl.put(map, "No select tablespaces", new String[]{"--no-tablespaces"});
            DumpConfigurationImpl.put(map, "No unlogged tables", new String[]{"--no-unlogged-table-data"});
            DumpConfigurationImpl.put(map, "Force quoting", new String[]{"--quote-all-identifiers"});
            DumpConfigurationImpl.put(map, "Only dump the named section", PgArguments.SECTION);
            DumpConfigurationImpl.put(map, "Serializable transaction", new String[]{"--serializable-deferrable"});
            DumpConfigurationImpl.put(map, "Use specified snapshot", PgArguments.SNAPSHOT);
            DumpConfigurationImpl.put(map, "Output SET SESSION AUTHORIZATION", new String[]{"--use-set-session-authorization"});
            DumpConfigurationImpl.put(map, "Show help", PgArguments.HELP);
            DumpConfigurationImpl.put(map, "Database name", PgArguments.DB_NAME);
            DumpConfigurationImpl.put(map, "Host name", PgArguments.HOST);
            DumpConfigurationImpl.put(map, "TCP port", PgArguments.PORT);
            DumpConfigurationImpl.put(map, "User name", PgArguments.USER);
            DumpConfigurationImpl.put(map, "Never issue a password prompt", PgArguments.NO_PASSWORD);
            DumpConfigurationImpl.put(map, "Force prompt password", PgArguments.PASSWORD);
            DumpConfigurationImpl.put(map, "Role name", PgArguments.ROLE);
            DumpConfigurationImpl.put(map, "Multiple connections on pre-9.2", new String[]{"--no-synchronized-snapshots"});
            HashMap hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "getInfoMap"));
            }
            return hashMap;
        }

        @Override
        @NotNull
        public String getPartOfValidationOut() {
            if ("pg_dump" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$1", "getPartOfValidationOut"));
            }
            return "pg_dump";
        }
    }
    ,
    MYSQL((DumpArgumentGroup[])MysqlArgumentsGroup.values(), MysqlArguments.HOST, MysqlArguments.PORT, MysqlArguments.USER, MysqlArguments.PASSWORD_PARAMETERIZABLE, MysqlArguments.RESULT_FILE, "MYSQL_PWD", "MYSQL_PROPERTIES", "mysqldump", (DatabaseDialect)MysqlDialect.INSTANCE){

        @Override
        @Nullable
        public String getDefaultSearchPath() {
            if (SystemInfo.isLinux) {
                return "/usr/bin/mysqldump";
            }
            if (SystemInfo.isMac) {
                return "/usr/local/bin/mysqldump";
            }
            return null;
        }

        @Override
        @NotNull
        public List<String> tweakAutocompletion(@NotNull List<String> variants) {
            if (variants == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "tweakAutocompletion"));
            }
            ArrayList result = ContainerUtil.newArrayList(variants);
            ContainerUtil.removeAll((Collection)result, (Object[])new String[]{"--databases="});
            ContainerUtil.removeAll((Collection)result, (Object[])MysqlArguments.PASSWORD);
            ContainerUtil.addAll((Collection)result, (Iterable)ContainerUtil.filter((Object[])MysqlArguments.DATABASES, s -> !s.endsWith("=")));
            ContainerUtil.addAll((Collection)result, (Object[])MysqlArguments.PASSWORD_PARAMETERIZABLE);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "tweakAutocompletion"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public List<DbElement> filterElements(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "filterElements"));
            }
            List schemas = ContainerUtil.filter(elements, DbDumpUtil.mySqlDatabases());
            if (schemas.size() > 1) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "filterElements"));
                }
                return list;
            }
            DbElement commonSchema = DumpConfigurationImpl.findCommonSchema(elements);
            if (commonSchema == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "filterElements"));
                }
                return list;
            }
            List tables = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbTable.class));
            ArrayList result = ContainerUtil.newArrayList((Iterable)tables);
            result.add(commonSchema);
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "filterElements"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text) {
            List tables;
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "sanitizeArguments"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "sanitizeArguments"));
            }
            List databases = ContainerUtil.filter(elements, DbDumpUtil.mySqlDatabases());
            String sanitized = super.sanitizeArguments(elements, text);
            List lexemes = DbDumpUtil.rawLexemes(sanitized);
            if (databases.size() > 1) {
                lexemes = DumpConfigurationImpl.removeAll(lexemes, new String[]{"--tables"});
                lexemes = DumpConfigurationImpl.removeAll(lexemes, MysqlArguments.DATABASES);
                lexemes = DumpConfigurationImpl.addAll(lexemes, sanitized, new String[]{DbDumpUtil.extractNonParameterizable(MysqlArguments.DATABASES)});
            }
            if ((tables = ContainerUtil.filter(elements, (Condition)DasUtil.byClass(DbTable.class))).size() > 0 && ContainerUtil.find((Iterable)lexemes, DbDumpUtil.lexemeFinder(MysqlArguments.DATABASES)) != null) {
                lexemes = DumpConfigurationImpl.removeAll(lexemes, new String[]{"--tables"});
                lexemes = DumpConfigurationImpl.addAll(lexemes, sanitized, new String[]{"--tables"});
            }
            String string = StringUtil.join((Collection)lexemes, DumpCommandLineLexeme::getText, (String)"");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "sanitizeArguments"));
            }
            return string;
        }

        @Override
        @NotNull
        public DumpDialogValidator getValidator() {
            MysqlDialogValidator mysqlDialogValidator = new MysqlDialogValidator();
            if (mysqlDialogValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "getValidator"));
            }
            return mysqlDialogValidator;
        }

        @Override
        @NotNull
        public List<String> getParameterizableArguments() {
            List list = ContainerUtil.list((Object[])new String[]{"-p", "-P", "-r", "-S", "-T", "-u", "w", "-#"});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "getParameterizableArguments"));
            }
            return list;
        }

        @Override
        @NotNull
        public String getPartOfValidationOut() {
            if ("mysqldump" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "getPartOfValidationOut"));
            }
            return "mysqldump";
        }

        @Override
        @NotNull
        public Map<String, String> getInfoMap() {
            HashMap infoMap = ContainerUtil.newHashMap();
            DumpConfigurationImpl.put(infoMap, "Display a help message and exit", new String[]{"--help", "-?"});
            DumpConfigurationImpl.put(infoMap, "Add DROP DATABASE statements", new String[]{"--add-drop-database"});
            DumpConfigurationImpl.put(infoMap, "Add DROP TABLE statements", new String[]{"--add-drop-table"});
            DumpConfigurationImpl.put(infoMap, "Add DROP TRIGGER statements", new String[]{"--add-drop-trigger"});
            DumpConfigurationImpl.put(infoMap, "Add LOCK/UNLOCK TABLES statements", new String[]{"--add-locks"});
            DumpConfigurationImpl.put(infoMap, "Dump all databases", MysqlArguments.ALL_DATABASES);
            DumpConfigurationImpl.put(infoMap, "Add statements for NDBCLUSTER table", MysqlArguments.ALL_TABLESPACES);
            DumpConfigurationImpl.put(infoMap, "Permit keywords column names", new String[]{"--allow-keywords"});
            DumpConfigurationImpl.put(infoMap, "For dump produced with --dump-slave", new String[]{"--apply-slave-statements"});
            DumpConfigurationImpl.put(infoMap, "Interface for connecting to MySQL server", MysqlArguments.BIND_ADDRESS);
            DumpConfigurationImpl.put(infoMap, "Directory with character sets", MysqlArguments.CHAR_SETS_DIR);
            DumpConfigurationImpl.put(infoMap, "Write host information, program and server version", MysqlArguments.COMMENTS);
            DumpConfigurationImpl.put(infoMap, "Produce more compact output", new String[]{"--compact"});
            DumpConfigurationImpl.put(infoMap, "Produce more other databases compatible output", MysqlArguments.COMPATIBLE);
            DumpConfigurationImpl.put(infoMap, "Inserts with column names", MysqlArguments.INSERTS_WITH_COLUMNS);
            DumpConfigurationImpl.put(infoMap, "The shared-memory name to use", MysqlArguments.SHARED_MEMORY_NAME);
            DumpConfigurationImpl.put(infoMap, "Sets default_character_set", new String[]{"--set-charset"});
            DumpConfigurationImpl.put(infoMap, "Compress client-server communication", MysqlArguments.COMPRESS);
            DumpConfigurationImpl.put(infoMap, "CREATE TABLE statements with options", MysqlArguments.CREATE_OPTIONS);
            DumpConfigurationImpl.put(infoMap, "Dump several databases", MysqlArguments.DATABASES);
            DumpConfigurationImpl.put(infoMap, "Write a debugging log", MysqlArguments.DEBUG);
            DumpConfigurationImpl.put(infoMap, "Debug information on exit", new String[]{"--debug-check"});
            DumpConfigurationImpl.put(infoMap, "Debug information and resources usage statistics", new String[]{"--debug-info"});
            DumpConfigurationImpl.put(infoMap, "Hint about client-side authentication plugin", MysqlArguments.DEFAULT_AUTH);
            DumpConfigurationImpl.put(infoMap, "Verbose mode", MysqlArguments.VERBOSE);
            DumpConfigurationImpl.put(infoMap, "Use charset_name as the default character set", MysqlArguments.DEFAULT_CHAR_SET);
            DumpConfigurationImpl.put(infoMap, "Second options file", MysqlArguments.DEFAULT_EXTRA_FILE);
            DumpConfigurationImpl.put(infoMap, "Use only the given option file", MysqlArguments.DEFAULTS_FILE);
            DumpConfigurationImpl.put(infoMap, "Read not only the usual option groups", MysqlArguments.DEFAULTS_GROUP_SUFFIX);
            DumpConfigurationImpl.put(infoMap, "INSERT DELAYED statements", new String[]{"--delayed-insert"});
            DumpConfigurationImpl.put(infoMap, "PURGE BINARY LOGS statement after dump", new String[]{"--delete-master-logs"});
            DumpConfigurationImpl.put(infoMap, "Disable keys before insert", MysqlArguments.DISABLE_KEYS);
            DumpConfigurationImpl.put(infoMap, "Comment with date at the end of the dump", new String[]{"--dump-date"});
            DumpConfigurationImpl.put(infoMap, "Uses a replication slave server", MysqlArguments.DUMP_SLAVE);
            DumpConfigurationImpl.put(infoMap, "Include Event Scheduler events", MysqlArguments.EVENTS);
            DumpConfigurationImpl.put(infoMap, "Multiple-row inserts", MysqlArguments.EXTENDED_INSERTS);
            DumpConfigurationImpl.put(infoMap, "Fields enclose string", MysqlArguments.FIELDS_ENCLOSED_BY);
            DumpConfigurationImpl.put(infoMap, "Fields escape string", MysqlArguments.FIELDS_ESCAPED_BY);
            DumpConfigurationImpl.put(infoMap, "Optionally fields enclose string", MysqlArguments.FIELDS_OPT_ENCLOSED_BY);
            DumpConfigurationImpl.put(infoMap, "Fields separator", MysqlArguments.FIELDS_TERMINATED_BY);
            DumpConfigurationImpl.put(infoMap, "Lock all tables (Deprecated)", new String[]{"--first-slave"});
            DumpConfigurationImpl.put(infoMap, "Flush server log files before dump", MysqlArguments.FLUSH_LOGS);
            DumpConfigurationImpl.put(infoMap, "Add a FLUSH PRIVILEGES statement", new String[]{"--flush-privileges"});
            DumpConfigurationImpl.put(infoMap, "Continue even if an SQL error occurs", MysqlArguments.FORCE);
            DumpConfigurationImpl.put(infoMap, "Enable cleartext authentication plugin", new String[]{"--enable-cleartext-plugin"});
            DumpConfigurationImpl.put(infoMap, "Host address", MysqlArguments.HOST);
            DumpConfigurationImpl.put(infoMap, "Hexadecimal notation for blobs", new String[]{"--hex-blob"});
            DumpConfigurationImpl.put(infoMap, "For the CHANGE MASTER TO statement in a slave dump", new String[]{"--include-master-host-port"});
            DumpConfigurationImpl.put(infoMap, "Do not dump the given table", MysqlArguments.IGNORE_TABLE);
            DumpConfigurationImpl.put(infoMap, "INSERT IGNORE statements", MysqlArguments.INSERT_IGNORE);
            DumpConfigurationImpl.put(infoMap, "Line separator", MysqlArguments.LINES_TERMINATED_BY);
            DumpConfigurationImpl.put(infoMap, "Lock all tables", MysqlArguments.LOCK_ALL_TABLES);
            DumpConfigurationImpl.put(infoMap, "Lock all tables to be dumped", MysqlArguments.LOCK_TABLES);
            DumpConfigurationImpl.put(infoMap, "Log warnings and errors", MysqlArguments.LOG_ERROR);
            DumpConfigurationImpl.put(infoMap, "Dump a master replication server", MysqlArguments.MASTER_DATA);
            DumpConfigurationImpl.put(infoMap, "Turn off autocommit and add COMMIT statements", new String[]{"--no-autocommit"});
            DumpConfigurationImpl.put(infoMap, "Suppress the CREATE DATABASE statements", MysqlArguments.NO_CREATE_DB);
            DumpConfigurationImpl.put(infoMap, "Do not write CREATE TABLE statements", MysqlArguments.NO_CREATE_INFO);
            DumpConfigurationImpl.put(infoMap, "Do not dump table contents", MysqlArguments.NO_DATA);
            DumpConfigurationImpl.put(infoMap, "Do not read any option files", new String[]{"--no-defaults"});
            DumpConfigurationImpl.put(infoMap, "Write SET NAMES default_character_set to the output", MysqlArguments.NO_SET_NAMES);
            DumpConfigurationImpl.put(infoMap, "Exclude CREATE LOGFILE GROUP and CREATE TABLESPACE", MysqlArguments.NO_TABLESPACES);
            DumpConfigurationImpl.put(infoMap, "Shortcut for default options", new String[]{"--opt"});
            DumpConfigurationImpl.put(infoMap, "Sort rows by its primary key or first unique index", new String[]{"--order-by-primary"});
            DumpConfigurationImpl.put(infoMap, "The password to use when connecting to the server", MysqlArguments.PASSWORD_PARAMETERIZABLE);
            DumpConfigurationImpl.put(infoMap, "Connect to the server using a named pipe (Windows)", MysqlArguments.PIPE);
            DumpConfigurationImpl.put(infoMap, "Plugins directory", MysqlArguments.PLUGIN_DIR);
            DumpConfigurationImpl.put(infoMap, "TCP port", MysqlArguments.PORT);
            DumpConfigurationImpl.put(infoMap, "Print program name and options from option files", new String[]{"--print-defaults"});
            DumpConfigurationImpl.put(infoMap, "Connection protocol to use", MysqlArguments.PROTOCOL);
            DumpConfigurationImpl.put(infoMap, "For dumping large tables", MysqlArguments.QUICK);
            DumpConfigurationImpl.put(infoMap, "Refuse connecting if server uses old protocol", new String[]{"--secure-auth"});
            DumpConfigurationImpl.put(infoMap, "Quote identifiers", MysqlArguments.QUOTE_NAMES);
            DumpConfigurationImpl.put(infoMap, "REPLACE statements", new String[]{"--replace"});
            DumpConfigurationImpl.put(infoMap, "Direct output to the named file", MysqlArguments.RESULT_FILE);
            DumpConfigurationImpl.put(infoMap, "Include stored routines", MysqlArguments.ROUTINES);
            DumpConfigurationImpl.put(infoMap, "Set REPEATABLE READ isolation mode", new String[]{"--single-transaction"});
            DumpConfigurationImpl.put(infoMap, "Write host, program and server version", new String[]{"--skip-comments"});
            DumpConfigurationImpl.put(infoMap, "Dump only selected by WHERE condition rows", MysqlArguments.WHERE);
            DumpConfigurationImpl.put(infoMap, "Disable --opt option", new String[]{"--skip-opt"});
            DumpConfigurationImpl.put(infoMap, "Unix - socket file, Windows - name of the pipe", MysqlArguments.SOCKET);
            DumpConfigurationImpl.put(infoMap, "Directory for tab-separated files", MysqlArguments.TAB);
            DumpConfigurationImpl.put(infoMap, "Override --databases option", new String[]{"--tables"});
            DumpConfigurationImpl.put(infoMap, "Include triggers", new String[]{"--triggers"});
            DumpConfigurationImpl.put(infoMap, "Set connection time zone to UTC", new String[]{"--tz-utc"});
            DumpConfigurationImpl.put(infoMap, "User name", MysqlArguments.USER);
            DumpConfigurationImpl.put(infoMap, "Max packet length", MysqlArguments.MAX_ALLOWED_PACKET);
            DumpConfigurationImpl.put(infoMap, "Add 'SET @@GLOBAL.GTID_PURGED' to the output", MysqlArguments.SET_GTID_PURGED);
            DumpConfigurationImpl.put(infoMap, "Buffer size network communication", MysqlArguments.NET_BUFFER_LENGTH);
            DumpConfigurationImpl.put(infoMap, "Disable --add-drop-table", new String[]{MysqlArguments.SKIP_ADD_DROP_TABLE});
            DumpConfigurationImpl.put(infoMap, "Disable --add-locks", new String[]{MysqlArguments.SKIP_ADD_LOCKS});
            DumpConfigurationImpl.put(infoMap, "Disable --create-options", MysqlArguments.SKIP_CREATE_OPTIONS);
            DumpConfigurationImpl.put(infoMap, "Disable --disable-keys", MysqlArguments.SKIP_DISABLE_KEYS);
            DumpConfigurationImpl.put(infoMap, "Disable --dump-date", new String[]{MysqlArguments.SKIP_DUMP_DATE});
            DumpConfigurationImpl.put(infoMap, "Disable --extended-inserts", MysqlArguments.SKIP_EXTENDED_INSERTS);
            DumpConfigurationImpl.put(infoMap, "Disable --lock-tables", MysqlArguments.SKIP_LOCK_TABLES);
            DumpConfigurationImpl.put(infoMap, "Disable --quick", MysqlArguments.SKIP_QUICK);
            DumpConfigurationImpl.put(infoMap, "Disable --quote-names", MysqlArguments.SKIP_QUOTE_NAMES);
            DumpConfigurationImpl.put(infoMap, "Disable --secure-auth", new String[]{MysqlArguments.SKIP_SECURE_AUTH});
            DumpConfigurationImpl.put(infoMap, "Disable --set-charset", new String[]{MysqlArguments.SKIP_SET_CHARSET});
            DumpConfigurationImpl.put(infoMap, "Print version of mysqldump", MysqlArguments.VERSION);
            DumpConfigurationImpl.put(infoMap, "Write dump output as XML", MysqlArguments.XML);
            DumpConfigurationImpl.put(infoMap, "Disable --triggers", new String[]{MysqlArguments.SKIP_TRIGGERS});
            DumpConfigurationImpl.put(infoMap, "Disable --tz-utc", new String[]{MysqlArguments.SKIP_TZ_UTC});
            DumpConfigurationImpl.put(infoMap, "Enable secure connection", new String[]{MysqlArguments.SSL});
            DumpConfigurationImpl.put(infoMap, "Path X509 key", MysqlArguments.SSL_KEY);
            DumpConfigurationImpl.put(infoMap, "Security state of connection", MysqlArguments.SSL_MODE);
            DumpConfigurationImpl.put(infoMap, "Do not use secure connection", new String[]{MysqlArguments.SKIP_SSL});
            DumpConfigurationImpl.put(infoMap, "Path list of SSL CAs", MysqlArguments.SSL_CA);
            DumpConfigurationImpl.put(infoMap, "Directory with SSL CA certificates", MysqlArguments.SSL_CA_PATH);
            DumpConfigurationImpl.put(infoMap, "Path of X509 certificate", MysqlArguments.SSL_CERT);
            DumpConfigurationImpl.put(infoMap, "Permitted ciphers for encryption", MysqlArguments.SSL_CIPHER);
            DumpConfigurationImpl.put(infoMap, "Verify server certificate", new String[]{MysqlArguments.SSL_VERIFY_SERVER_CERT});
            DumpConfigurationImpl.put(infoMap, "Certificate revocation list", MysqlArguments.SSL_CRL);
            DumpConfigurationImpl.put(infoMap, "Certificate revocation list path", MysqlArguments.SSL_CRL_PATH);
            HashMap hashMap = infoMap;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl$2", "getInfoMap"));
            }
            return hashMap;
        }
    };

    private final DumpArgumentGroup<? extends DumpArgument>[] myGroups;
    private final String[] myHostArgs;
    private final String[] myPortArgs;
    private final String[] myUsernameArgs;
    private final String[] myPasswordArgs;
    private final String[] myFileArgs;
    private final String myEnvironmentVarName;
    private final String myPropertyKey;
    private final String myName;
    private final DatabaseDialect myDialect;

    private DumpConfigurationImpl(@NotNull DumpArgumentGroup<? extends DumpArgument>[] groups, @NotNull String[] hostArgs, @NotNull String[] portArgs, @NotNull String[] usernameArgs, @NotNull String[] passwordArgs, @NotNull String[] fileArgs, @NotNull String name, @NotNull String propertyKey, String name1, DatabaseDialect dialect) {
        if (groups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groups", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (hostArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostArgs", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (portArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portArgs", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (usernameArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usernameArgs", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (passwordArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "passwordArgs", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (name1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name1", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "<init>"));
        }
        this.myGroups = groups;
        this.myHostArgs = hostArgs;
        this.myPortArgs = portArgs;
        this.myUsernameArgs = usernameArgs;
        this.myPasswordArgs = passwordArgs;
        this.myFileArgs = fileArgs;
        this.myEnvironmentVarName = name;
        this.myPropertyKey = propertyKey;
        this.myName = name1;
        this.myDialect = dialect;
    }

    @Override
    @NotNull
    public DumpPanelDecorator getDecorator() {
        DumpPanelDecorator.DefaultDumpPanelDecorator defaultDumpPanelDecorator = new DumpPanelDecorator.DefaultDumpPanelDecorator(this.getName());
        if (defaultDumpPanelDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getDecorator"));
        }
        return defaultDumpPanelDecorator;
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "tweakAutocompletion"));
        }
        List<String> list = variants;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "tweakAutocompletion"));
        }
        return list;
    }

    @Override
    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> elements, @NotNull String text) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "sanitizeArguments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "sanitizeArguments"));
        }
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(text);
        List mapped = ContainerUtil.map(lexemes, DumpCommandLineLexeme::convertLineWrapToWhitespace);
        String string = StringUtil.join((Collection)mapped, DumpCommandLineLexeme::getText, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "sanitizeArguments"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @Nullable String username, @Nullable String host, @Nullable String port) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getCommand"));
        }
        String string = command + DumpConfigurationImpl.notNullPair(DbDumpUtil.extractParameterizable(this.myUsernameArgs), username) + DumpConfigurationImpl.notNullPair(DbDumpUtil.extractParameterizable(this.myHostArgs), host) + DumpConfigurationImpl.notNullPair(DbDumpUtil.extractParameterizable(this.myPortArgs), port);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getCommand"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<DumpComponent> getComponents() {
        List<DumpComponent> list = Arrays.stream(this.myGroups).flatMap(group -> group.createComponents().stream()).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getPropertyKey() {
        String string = this.myPropertyKey;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getPropertyKey"));
        }
        return string;
    }

    @Override
    @NotNull
    public String[] getFileArgs() {
        if (this.myFileArgs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getFileArgs"));
        }
        return this.myFileArgs;
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myPasswordArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getPasswordIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getUsernameIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myUsernameArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getUsernameIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getHostIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myHostArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getHostIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public LexemeIndicators getPortIndicators() {
        LexemeIndicators lexemeIndicators = new LexemeIndicators(this.myPortArgs);
        if (lexemeIndicators == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getPortIndicators"));
        }
        return lexemeIndicators;
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        if ("--help" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getHelpCommand"));
        }
        return "--help";
    }

    @Override
    @NotNull
    public String getValidationCommand() {
        if ("--version" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getValidationCommand"));
        }
        return "--version";
    }

    @Override
    @NotNull
    public String getEnvironmentVariableName() {
        String string = this.myEnvironmentVarName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "getEnvironmentVariableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String processParameter(@NotNull DumpCommandLineLexeme lexeme, @NotNull String parameter) {
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "processParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "processParameter"));
        }
        String string = DbDumpUtil.unescapeAll(StringUtil.unquoteString((String)parameter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "processParameter"));
        }
        return string;
    }

    @Nullable
    public static DumpConfigurationImpl of(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "of"));
        }
        for (DumpConfigurationImpl capabilities : DumpConfigurationImpl.values()) {
            if (capabilities.myDialect != dialect) continue;
            return capabilities;
        }
        return null;
    }

    @Nullable
    private static DbElement findCommonSchema(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "findCommonSchema"));
        }
        return DumpConfigurationImpl.findCommon(elements, (NullableFunction<DbElement, DbElement>)((NullableFunction)DatabaseView::getLowestSchema));
    }

    @Nullable
    private static DbElement findCommonDataSource(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "findCommonDataSource"));
        }
        return DumpConfigurationImpl.findCommon(elements, (NullableFunction<DbElement, DbElement>)((NullableFunction)DbElement::getDataSource));
    }

    @Nullable
    private static DbElement findCommon(@NotNull Collection<DbElement> elements, @NotNull NullableFunction<DbElement, DbElement> getter) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "findCommon"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "findCommon"));
        }
        Set common = JBIterable.from(elements).transform(getter).filter(Condition.NOT_NULL).toSet();
        return common.size() != 1 ? null : (DbElement)ContainerUtil.getFirstItem((Collection)common);
    }

    @NotNull
    private static String notNullPair(@NotNull String argument, @Nullable String parameter) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "notNullPair"));
        }
        String string = parameter == null ? "" : " " + argument + parameter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "notNullPair"));
        }
        return string;
    }

    private static void put(@NotNull Map<String, String> map, @NotNull String text, String ... args) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "put"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "put"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "put"));
        }
        for (String arg : args) {
            map.put(arg, text);
        }
    }

    @NotNull
    private static List<DumpCommandLineLexeme> removeAll(@NotNull List<DumpCommandLineLexeme> lexemes, String ... args) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "removeAll"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "removeAll"));
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)ContainerUtil.filter(lexemes, (Condition)Conditions.not(DbDumpUtil.lexemeFinder(args))));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "removeAll"));
        }
        return arrayList;
    }

    @NotNull
    private static List<DumpCommandLineLexeme> addAll(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull String command, String ... args) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "addAll"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "addAll"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "addAll"));
        }
        int offset = 0;
        for (String arg : args) {
            int end = command.length() + offset;
            DumpCommandLineLexeme space = new DumpCommandLineLexeme(" ", HelpTokenType.BAD, end, end + 1);
            DumpCommandLineLexeme lexeme = new DumpCommandLineLexeme(arg, HelpTokenType.LONG_PARAMETER, end + 1, end + arg.length() + 1);
            offset += arg.length() + 1;
            lexemes.add(space);
            lexemes.add(lexeme);
        }
        List<DumpCommandLineLexeme> list = lexemes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpConfigurationImpl", "addAll"));
        }
        return list;
    }
}

