/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpSettings;
import com.intellij.database.dump.dbdump.LexemeIndicators;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpCredentialsManager {
    private static final String MESSAGE = "Enter Username and Password";
    private final LocalDataSource myDataSource;
    private final DumpConfiguration myConfiguration;
    private final Project myProject;
    private final DumpSettings mySettings;
    private boolean myAskingTurnedOff;

    public DumpCredentialsManager(@NotNull LocalDataSource source, @NotNull DumpConfiguration configuration, @NotNull Project project, @NotNull DumpSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "<init>"));
        }
        this.myDataSource = source;
        this.myConfiguration = configuration;
        this.myProject = project;
        this.mySettings = settings;
    }

    @NotNull
    public Pair<String, String> getCommandAndPassword() {
        DatabaseDriver driver = (DatabaseDriver)ObjectUtils.assertNotNull((Object)this.myDataSource.getDatabaseDriver());
        RawConnectionConfig config = (RawConnectionConfig)ObjectUtils.assertNotNull((Object)this.myDataSource.getConnectionConfig());
        String executable = StringUtil.trim((String)(this.mySettings.getPathToExecutable() + " " + this.mySettings.getCommand()));
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        String url = config.getUrl();
        Pair pair = (Pair)ObjectUtils.assertNotNull(JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create()));
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(executable);
        ConnectionData host = this.getData(this.myConfiguration.getHostIndicators(), DumpCredentialsManager.getHost((String)pair.getFirst()));
        ConnectionData port = this.getData(this.myConfiguration.getPortIndicators(), (String)pair.getSecond());
        DumpCredentials credentials = this.getCredentials(this.myDataSource, lexemes);
        ConnectionData username = credentials.getUsername();
        ConnectionData password = credentials.getPassword();
        if (username.isNeedToSetManually() && username.isEmpty()) {
            DumpCredentialsManager.cancelDump();
        }
        String sanitizedCommand = this.syncCredentials(executable, credentials);
        String command = this.myConfiguration.getCommand(sanitizedCommand, DumpCredentialsManager.getValue(username), DumpCredentialsManager.getValue(host), DumpCredentialsManager.getValue(port));
        Pair pair2 = Pair.create((Object)command, (Object)DumpCredentialsManager.getValue(password));
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandAndPassword"));
        }
        return pair2;
    }

    public void turnOffAskingCredentials() {
        this.myAskingTurnedOff = true;
    }

    @Nullable
    private static String getValue(@NotNull ConnectionData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getValue"));
        }
        return !data.isNeedToSetManually() ? null : data.getValue();
    }

    @NotNull
    private DumpCredentials getCredentials(@NotNull LocalDataSource source, @NotNull List<DumpCommandLineLexeme> lexemes) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        Credentials credentials = databaseCredentials.getCredentials((DatabaseSystem)source);
        String userName = credentials == null || StringUtil.isEmpty((String)credentials.getUserName()) ? "" : credentials.getUserName();
        String pass = credentials == null || StringUtil.isEmpty((String)credentials.getPasswordAsString()) ? "" : credentials.getPasswordAsString();
        ConnectionData username = this.getData(this.myConfiguration.getUsernameIndicators(), userName);
        ConnectionData password = this.getData(this.myConfiguration.getPasswordIndicators(), pass);
        boolean differentSources = password.isNeedToSetManually() != username.isNeedToSetManually();
        boolean manualOrAskPassword = password.isNeedToSetManually() || !this.myConfiguration.getPasswordIndicators().isNoAskingIndicator();
        boolean manualOrAskUsername = username.isNeedToSetManually() || !this.myConfiguration.getUsernameIndicators().isNoAskingIndicator();
        boolean manualEmpty = password.isNeedToSetManually() && password.isEmpty() || username.isNeedToSetManually() && username.isEmpty();
        boolean ask = differentSources && manualOrAskPassword && manualOrAskUsername || manualEmpty;
        DumpCredentials dumpCredentials = !ask || this.myAskingTurnedOff ? new DumpCredentials(username, password, false, false) : this.askCredentials(lexemes, databaseCredentials, source, username, password);
        if (dumpCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCredentials"));
        }
        return dumpCredentials;
    }

    @NotNull
    private String syncCredentials(@NotNull String command, @NotNull DumpCredentials credentials) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String string = DumpCredentialsManager.getCommandWithout(command, credentials.isUsernameRemoveNeeded() ? usernameIndicators : null, credentials.isPasswordRemoveNeeded() ? passwordIndicators : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "syncCredentials"));
        }
        return string;
    }

    @NotNull
    private static String getCommandWithout(@NotNull String command, LexemeIndicators ... indicators) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        for (LexemeIndicators indicator : indicators) {
            if (indicator == null) continue;
            command = DumpCredentialsManager.getCommandWithout(command, indicator);
        }
        String string = command;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        return string;
    }

    @NotNull
    private static String getCommandWithout(@NotNull String command, LexemeIndicators indicators) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.rawLexemes(command);
        int lexemeIndex = DumpCredentialsManager.getIndexFromCommand(lexemes, indicators);
        while (lexemeIndex != -1 && lexemeIndex != lexemes.size() - 1) {
            lexemes.remove(lexemeIndex);
            if (indicators.hasParameter()) {
                lexemes.remove(lexemeIndex);
            }
            lexemeIndex = DumpCredentialsManager.getIndexFromCommand(lexemes, indicators);
        }
        String string = StringUtil.join(lexemes, DumpCommandLineLexeme::getText, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getCommandWithout"));
        }
        return string;
    }

    @NotNull
    private DumpCredentials askCredentials(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource source, @NotNull ConnectionData username, @NotNull ConnectionData password) {
        Pair<String, String> pair;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (username == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        boolean noStore = !username.isNeedToSetManually() || !password.isNeedToSetManually();
        LexemeIndicators usernameIndicators = this.myConfiguration.getUsernameIndicators();
        LexemeIndicators passwordIndicators = this.myConfiguration.getPasswordIndicators();
        String usernameForDialog = !username.isNeedToSetManually() ? DumpCredentialsManager.getFromCommandLine(lexemes, usernameIndicators) : username.getValue();
        String passwordForDialog = !password.isNeedToSetManually() ? DumpCredentialsManager.getFromCommandLine(lexemes, passwordIndicators) : password.getValue();
        Pair<String, String> pair2 = pair = noStore ? DumpCredentialsManager.getNoStored(source, usernameForDialog, passwordForDialog) : this.getStored(source, credentials, usernameForDialog);
        if (pair == null) {
            DumpCredentialsManager.cancelDump();
        }
        boolean removeUsername = !username.isNeedToSetManually() && !StringUtil.equals((CharSequence)usernameForDialog, (CharSequence)((CharSequence)pair.getFirst()));
        boolean removePassword = !password.isNeedToSetManually() && !StringUtil.equals((CharSequence)passwordForDialog, (CharSequence)((CharSequence)pair.getSecond()));
        boolean needManualSetUsername = removeUsername || username.isNeedToSetManually();
        boolean needManualSetPassword = removePassword || password.isNeedToSetManually();
        DumpCredentials dumpCredentials = new DumpCredentials(new ConnectionData((String)pair.getFirst(), needManualSetUsername), new ConnectionData((String)pair.getSecond(), needManualSetPassword), removeUsername, removePassword);
        if (dumpCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "askCredentials"));
        }
        return dumpCredentials;
    }

    @Nullable
    private static Pair<String, String> getNoStored(@NotNull LocalDataSource source, @Nullable String username, @Nullable String password) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getNoStored"));
        }
        return (Pair)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "lambda$getNoStored$0"));
            }
            PasswordPromptComponent component = new PasswordPromptComponent(true, MESSAGE, true, null);
            component.setUserName(username);
            component.setPassword(password);
            DialogBuilder builder = new DialogBuilder().centerPanel(component.getComponent()).title(String.format("Dumping %s", source.getName())).okActionEnabled(true);
            builder.addCancelAction();
            builder.addOkAction();
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            if (!builder.showAndGet()) {
                return null;
            }
            return Pair.create((Object)component.getUserName(), (Object)String.valueOf(component.getPassword()));
        });
    }

    @Nullable
    private Pair<String, String> getStored(@NotNull LocalDataSource source, @NotNull DatabaseCredentials credentials, @Nullable String username) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getStored"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getStored"));
        }
        Credentials asked = credentials.askCredentialsWhenFailed(this.myProject, source, MESSAGE, username);
        return asked == null || StringUtil.isEmpty((String)asked.getUserName()) || StringUtil.isEmpty((String)asked.getPasswordAsString()) ? null : Pair.create((Object)asked.getUserName(), (Object)asked.getPasswordAsString());
    }

    @Nullable
    private static String getFromCommandLine(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getFromCommandLine"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getFromCommandLine"));
        }
        if (indicators.isNoAskingIndicator()) {
            return "";
        }
        if (!indicators.hasParameter()) {
            return null;
        }
        int index = DumpCredentialsManager.getIndexFromCommand(lexemes, indicators);
        if (index == -1 || index == lexemes.size() - 1) {
            return null;
        }
        return StringUtil.trim((String)lexemes.get(index + 1).getText());
    }

    private static int getIndexFromCommand(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getIndexFromCommand"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getIndexFromCommand"));
        }
        return ContainerUtil.lastIndexOf(lexemes, DbDumpUtil.lexemeWithParameterFinder(lexemes, indicators));
    }

    private static void cancelDump() {
        throw new ProcessCanceledException();
    }

    @NotNull
    private ConnectionData getData(@NotNull LexemeIndicators indicators, @NotNull String string) {
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getData"));
        }
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getData"));
        }
        ConnectionData connectionData = new ConnectionData(string, !this.mySettings.contains(indicators));
        if (connectionData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getData"));
        }
        return connectionData;
    }

    @NotNull
    private static String getHost(@NotNull String host) {
        String string;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getHost"));
        }
        if (!StringUtil.equals((CharSequence)host, (CharSequence)"localhost")) {
            String string2 = host;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getHost"));
            }
            return string2;
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            string = address == null ? host : address.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            String string3 = host;
            if (string3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getHost"));
            }
            return string3;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager", "getHost"));
        }
        return string;
    }

    private static class DumpCredentials {
        private final ConnectionData myUsername;
        private final ConnectionData myPassword;
        private final boolean myUsernameRemoveNeeded;
        private final boolean myPasswordRemoveNeeded;

        private DumpCredentials(@NotNull ConnectionData username, @NotNull ConnectionData password, boolean usernameRemoveNeeded, boolean passwordRemoveNeeded) {
            if (username == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "<init>"));
            }
            if (password == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "<init>"));
            }
            this.myUsername = username;
            this.myPassword = password;
            this.myUsernameRemoveNeeded = usernameRemoveNeeded;
            this.myPasswordRemoveNeeded = passwordRemoveNeeded;
        }

        public boolean isPasswordRemoveNeeded() {
            return this.myPasswordRemoveNeeded;
        }

        public boolean isUsernameRemoveNeeded() {
            return this.myUsernameRemoveNeeded;
        }

        @NotNull
        public ConnectionData getPassword() {
            ConnectionData connectionData = this.myPassword;
            if (connectionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "getPassword"));
            }
            return connectionData;
        }

        @NotNull
        public ConnectionData getUsername() {
            ConnectionData connectionData = this.myUsername;
            if (connectionData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpCredentialsManager$DumpCredentials", "getUsername"));
            }
            return connectionData;
        }
    }

    private static class ConnectionData {
        private final String myValue;
        private final boolean myNeedToSetManually;

        ConnectionData(@Nullable String value, boolean needToSetManually) {
            this.myValue = value;
            this.myNeedToSetManually = needToSetManually;
        }

        boolean isNeedToSetManually() {
            return this.myNeedToSetManually;
        }

        @Nullable
        String getValue() {
            return this.myValue;
        }

        boolean isEmpty() {
            return this.myValue != null && this.myValue.isEmpty();
        }
    }
}

