/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabasePluginId;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorScripts {
    private static final String SCRIPT_DIR = "data/extractors";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+)(?:\\.(\\w+))?\\.\\w+");

    private ExtractorScripts() {
    }

    @Nullable
    public static VirtualFile getScriptsDirectory() {
        try {
            return ExtractorScripts.getScriptDirectoryImpl(true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    public static List<VirtualFile> getScriptFiles() {
        List list;
        try {
            VirtualFile directory = ExtractorScripts.getScriptDirectoryImpl(false);
            Object[] scriptDirChildren = directory == null ? VirtualFile.EMPTY_ARRAY : directory.getChildren();
            Condition scriptFileFilter = Conditions.and((Condition)ExtensionsRootType.regularFileFilter(), virtualFile -> FILE_PATTERN.matcher(virtualFile.getName()).matches());
            list = ContainerUtil.filter((Object[])scriptDirChildren, (Condition)scriptFileFilter);
        }
        catch (IOException iOException) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorScripts", "getScriptFiles"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorScripts", "getScriptFiles"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile findScript(String name) {
        try {
            return ExtensionsRootType.getInstance().findResource(DatabasePluginId.get(), "data/extractors/" + name, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull VirtualFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/database/extractors/ExtractorScripts", "getOutputFileExtension"));
        }
        String string = ExtractorScripts.getNamePart(script, 2, "txt");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorScripts", "getOutputFileExtension"));
        }
        return string;
    }

    @NotNull
    private static String getNamePart(@NotNull VirtualFile file, int namePart, String def) {
        String string;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/extractors/ExtractorScripts", "getNamePart"));
        }
        Matcher matcher = FILE_PATTERN.matcher(file.getNameSequence());
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorScripts", "getNamePart"));
            }
            return string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/ExtractorScripts", "getNamePart"));
        }
        return string;
    }

    @Nullable
    private static VirtualFile getScriptDirectoryImpl(boolean createIfMissing) throws IOException {
        return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
    }
}

