/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.tz;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TimeZonedValue<T extends Date> {
    private final T myValue;
    private final String myStringRepresentation;
    private final int myType;
    private ZoneOffset myZoneOffset;

    TimeZonedValue(@NotNull T value, @NotNull String stringRepresentation, int type) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/tz/TimeZonedValue", "<init>"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/extractors/tz/TimeZonedValue", "<init>"));
        }
        this.myValue = value;
        this.myStringRepresentation = stringRepresentation;
        this.myType = type;
    }

    public T getValue() {
        return this.myValue;
    }

    public String getStringRepresentation() {
        return this.myStringRepresentation;
    }

    @Nullable
    public ZoneOffset getZoneOffset() {
        int index;
        String offsetId;
        int lastIndex;
        if (this.myZoneOffset != null) {
            return this.myZoneOffset;
        }
        int lastPlusIndex = this.myStringRepresentation.lastIndexOf(43);
        int lastMinusIndex = this.myStringRepresentation.lastIndexOf(45);
        int n = lastIndex = lastPlusIndex == -1 ? lastMinusIndex : lastPlusIndex;
        if (lastIndex <= this.getMinOffsetIndex()) {
            return null;
        }
        String string = offsetId = lastIndex == -1 ? null : this.myStringRepresentation.substring(lastIndex);
        if (offsetId == null || offsetId.isEmpty()) {
            return null;
        }
        for (index = offsetId.length() - 1; index > 0 && !Character.isDigit(offsetId.charAt(index)); --index) {
        }
        this.myZoneOffset = TimeZonedValue.tryParse(offsetId.substring(0, index + 1));
        return this.myZoneOffset;
    }

    abstract int getMinOffsetIndex();

    private static ZoneOffset tryParse(String zoneId) {
        try {
            return ZoneOffset.of(zoneId);
        }
        catch (DateTimeException e) {
            return null;
        }
    }

    public int getType() {
        return this.myType;
    }
}

