/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.properties.ListMultiRef;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface BasicIndex
extends BasicColumniation,
DasIndex {
    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColNames"));
        }
        return list;
    }

    @NotNull
    default public Set<String> getReverseColNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getReverseColNames"));
        }
        return set;
    }

    default public boolean isUnique() {
        return false;
    }

    @NotNull
    default public MultiRef<? extends BasicColumn> getColumnsRef() {
        ListMultiRef<? extends BasicColumn> listMultiRef = new ListMultiRef<BasicColumn>(this.getCols());
        if (listMultiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnsRef"));
        }
        return listMultiRef;
    }

    @NotNull
    default public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
        }
        String name = column.getName();
        if (name == null || name.isEmpty()) {
            DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        if (this.getReverseColNames().contains(name)) {
            DasIndex.Sorting sorting = DasIndex.Sorting.DESCENDING;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        if (this.getColNames().contains(name)) {
            DasIndex.Sorting sorting = DasIndex.Sorting.ASCENDING;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
        }
        return sorting;
    }
}

