/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicSynonym
extends BasicMajorObject,
DasSynonym {
    @Nullable
    default public String getTargetSchemaName() {
        return null;
    }

    @Nullable
    default public BasicSchema getTargetSchema() {
        BasicSchema mySchema = this.getSchema();
        String refSchemaName = this.getTargetSchemaName();
        if (refSchemaName == null) {
            return mySchema;
        }
        return mySchema != null ? mySchema.getSibling(refSchemaName) : null;
    }

    @NotNull
    default public ObjectKind getTargetObjectKind() {
        ObjectKind objectKind = ObjectKind.NONE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicSynonym", "getTargetObjectKind"));
        }
        return objectKind;
    }

    @Nullable
    default public String getTargetObjectName() {
        return null;
    }

    @Nullable
    default public BasicMajorObject getTargetObject() {
        ObjectKind targetObjectKind = this.getTargetObjectKind();
        if (targetObjectKind == ObjectKind.NONE) {
            return null;
        }
        String targetObjectName = this.getTargetObjectName();
        if (targetObjectName == null || targetObjectName.isEmpty()) {
            return null;
        }
        BasicSchema targetSchema = this.getTargetSchema();
        if (targetSchema == null) {
            return null;
        }
        return targetSchema.findChild(targetObjectKind, targetObjectName, BasicMajorObject.class);
    }

    @Nullable
    default public BasicMajorObject getOrigin() {
        BasicMajorObject targetObject = this.getTargetObject();
        while (targetObject != null && targetObject instanceof BasicSynonym) {
            targetObject = ((BasicSynonym)targetObject).getTargetObject();
        }
        return targetObject;
    }

    @Deprecated
    @Nullable
    default public DasObject resolveTarget() {
        return this.getTargetObject();
    }

    @NotNull
    default public Iterable<String> getTargetPath() {
        LinkedList<String> path = new LinkedList<String>();
        for (BasicElement e = this.getTargetObject(); e != null && !(e instanceof BasicRoot); e = e.getDbParent()) {
            path.addFirst(e.getName());
        }
        LinkedList<String> linkedList = path;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicSynonym", "getTargetPath"));
        }
        return linkedList;
    }
}

