/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.db2;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.db2.DB2ModSchema;
import com.intellij.database.model.db2.DB2Synonym;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DB2ModSynonym
extends DB2Synonym,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public DB2ModSchema getSchema();

    @Override
    @NotNull
    default public DB2ModSchema getDbParent() {
        DB2ModSchema dB2ModSchema = this.getSchema();
        if (dB2ModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModSynonym", "getDbParent"));
        }
        return dB2ModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends DB2ModSynonym> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModSynonym", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/db2/DB2ModSynonym", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setTargetSchemaName(@Nullable String var1);

    public void setTargetObjectKind(@NotNull ObjectKind var1);

    public void setTargetObjectName(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/db2/DB2ModSynonym", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String targetSchemaName = properties.get("TargetSchemaName");
        String targetObjectKind = properties.get("TargetObjectKind");
        String targetObjectName = properties.get("TargetObjectName");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (targetSchemaName != null) {
            this.setTargetSchemaName(PropertyConverter.importString(targetSchemaName));
        }
        if (targetObjectKind != null) {
            this.setTargetObjectKind(PropertyConverter.importObjectKind(targetObjectKind));
        }
        if (targetObjectName != null) {
            this.setTargetObjectName(PropertyConverter.importString(targetObjectName));
        }
    }
}

