/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.generic.GenericConstraint;
import com.intellij.database.model.generic.GenericSchema;
import com.intellij.database.model.generic.GenericTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericForeignKey
extends GenericConstraint,
BasicForeignKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public GenericTable getTable();

    @Override
    @Nullable
    default public GenericTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public GenericTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingFamily<@NotNull ? extends GenericForeignKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public GenericSchema getSchema() {
        GenericTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getColNames"));
        }
        return list;
    }

    @Override
    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericForeignKey", "getRefColNames"));
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> refColNames;
        String refKeyName;
        String refTableName;
        String refSchemaName;
        List<String> colNames;
        String comment;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/generic/GenericForeignKey", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if ((refSchemaName = this.getRefSchemaName()) != null) {
            consumer.accept("RefSchemaName", PropertyConverter.export(refSchemaName));
        }
        if ((refTableName = this.getRefTableName()) != null) {
            consumer.accept("RefTableName", PropertyConverter.export(refTableName));
        }
        if ((refKeyName = this.getRefKeyName()) != null) {
            consumer.accept("RefKeyName", PropertyConverter.export(refKeyName));
        }
        if (!(refColNames = this.getRefColNames()).isEmpty()) {
            consumer.accept("RefColNames", PropertyConverter.exportListOfString(refColNames));
        }
    }
}

