/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.generic.GenericIndex;
import com.intellij.database.model.generic.GenericModSchema;
import com.intellij.database.model.generic.GenericModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericModIndex
extends GenericIndex,
BasicModNamedElement {
    @Override
    @NotNull
    public GenericModTable getTable();

    @Override
    @NotNull
    default public GenericModTable getDbParent() {
        GenericModTable genericModTable = this.getTable();
        if (genericModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModIndex", "getDbParent"));
        }
        return genericModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends GenericModIndex> getParentFamily();

    @Override
    @NotNull
    default public GenericModSchema getSchema() {
        GenericModSchema genericModSchema = this.getTable().getSchema();
        if (genericModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModIndex", "getSchema"));
        }
        return genericModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModIndex", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModIndex", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setColNames(@NotNull List<String> var1);

    default public void setColNames(String ... colNames) {
        this.setColNames(Arrays.asList(colNames));
    }

    public void setReverseColNames(@NotNull Set<String> var1);

    public void setUnique(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/generic/GenericModIndex", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String colNames = properties.get("ColNames");
        String reverseColNames = properties.get("ReverseColNames");
        String unique = properties.get("Unique");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (colNames != null) {
            this.setColNames(PropertyConverter.importListOfString(colNames));
        }
        if (reverseColNames != null) {
            this.setReverseColNames(PropertyConverter.importSetOfString(reverseColNames));
        }
        if (unique != null) {
            this.setUnique(PropertyConverter.importBoolean(unique));
        }
    }
}

