/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.postgres.PostgresModArgument;
import com.intellij.database.model.postgres.PostgresModCheck;
import com.intellij.database.model.postgres.PostgresModDatabase;
import com.intellij.database.model.postgres.PostgresModDefType;
import com.intellij.database.model.postgres.PostgresModDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresModForeignKey;
import com.intellij.database.model.postgres.PostgresModIndex;
import com.intellij.database.model.postgres.PostgresModKey;
import com.intellij.database.model.postgres.PostgresModMatView;
import com.intellij.database.model.postgres.PostgresModMatViewColumn;
import com.intellij.database.model.postgres.PostgresModModel;
import com.intellij.database.model.postgres.PostgresModOperator;
import com.intellij.database.model.postgres.PostgresModRoot;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresModTableColumn;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.postgres.PostgresModView;
import com.intellij.database.model.postgres.PostgresModViewColumn;
import com.intellij.database.model.postgres.PostgresRoot;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PostgresOperatorKind;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PostgresImplModel
extends BaseModel
implements PostgresModModel {
    private final Root myRoot = new Root();

    PostgresImplModel() {
    }

    @Override
    @NotNull
    public PostgresRoot getRoot() {
        Root root = this.myRoot;
        if (root == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel", "getRoot"));
        }
        return root;
    }

    final class Trigger
    extends BaseModel.BaseRegularElement
    implements PostgresModTrigger {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private Set<TrigEvent> myEvent;
        @Nullable
        private String myCondition;
        @Nullable
        private String myCallRoutineName;
        @Nullable
        private String myCallArguments;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;

        private Trigger(BaseModel.BaseFamily<? extends Trigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTurn = null;
            this.myEvent = Collections.emptySet();
            this.myCondition = null;
            this.myCallRoutineName = null;
            this.myCallArguments = null;
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Trigger> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvent() {
            Set<TrigEvent> set = this.myEvent;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Trigger", "getEvent"));
            }
            return set;
        }

        @Override
        public void setEvent(@Nullable Set<TrigEvent> event) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = event != null ? ImmutableSet.copyOf(event) : Collections.emptySet();
            if (x.isEmpty() && this.myEvent.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvent = x;
        }

        @Override
        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public void setCondition(@Nullable String condition) {
            if (BaseModel.eq(this.myCondition, condition)) {
                return;
            }
            this.modifying();
            this.myCondition = condition;
        }

        @Override
        @Nullable
        public String getCallRoutineName() {
            return this.myCallRoutineName;
        }

        @Override
        public void setCallRoutineName(@Nullable String callRoutineName) {
            if (BaseModel.eq(this.myCallRoutineName, callRoutineName)) {
                return;
            }
            this.modifying();
            this.myCallRoutineName = callRoutineName;
        }

        @Override
        @Nullable
        public String getCallArguments() {
            return this.myCallArguments;
        }

        @Override
        public void setCallArguments(@Nullable String callArguments) {
            if (BaseModel.eq(this.myCallArguments, callArguments)) {
                return;
            }
            this.modifying();
            this.myCallArguments = callArguments;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }
    }

    final class Rule
    extends BaseModel.BaseRegularElement
    implements PostgresModRule {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private Set<TrigEvent> myEvent;
        @Nullable
        private String myCondition;
        @NotNull
        private List<String> myCommands;

        private Rule(BaseModel.BaseFamily<? extends Rule> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Rule", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTurn = null;
            this.myEvent = Collections.emptySet();
            this.myCondition = null;
            this.myCommands = Collections.emptyList();
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Rule", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Rule> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Rule", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Rule", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Rule", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Rule", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvent() {
            Set<TrigEvent> set = this.myEvent;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Rule", "getEvent"));
            }
            return set;
        }

        @Override
        public void setEvent(@Nullable Set<TrigEvent> event) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = event != null ? ImmutableSet.copyOf(event) : Collections.emptySet();
            if (x.isEmpty() && this.myEvent.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvent = x;
        }

        @Override
        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        @Override
        public void setCondition(@Nullable String condition) {
            if (BaseModel.eq(this.myCondition, condition)) {
                return;
            }
            this.modifying();
            this.myCondition = condition;
        }

        @Override
        @NotNull
        public List<String> getCommands() {
            List<String> list = this.myCommands;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Rule", "getCommands"));
            }
            return list;
        }

        @Override
        public void setCommands(@Nullable List<String> commands) {
            ImmutableList x;
            ImmutableList immutableList = x = commands != null ? ImmutableList.copyOf(commands) : Collections.emptyList();
            if (x.isEmpty() && this.myCommands.isEmpty()) {
                return;
            }
            this.modifying();
            this.myCommands = x;
        }
    }

    final class Operator
    extends BaseModel.BaseRegularElement
    implements PostgresModOperator {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private PostgresOperatorKind myOperatorKind;
        @Nullable
        private String myCallRoutineName;
        @NotNull
        private DataType myLeftType;
        @NotNull
        private DataType myRightType;
        @NotNull
        private DataType myResultType;

        private Operator(BaseModel.BaseFamily<? extends Operator> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Operator", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myOperatorKind = PostgresOperatorKind.UNKNOWN;
            this.myCallRoutineName = null;
            this.myLeftType = ModelConsts.NO_DATA_TYPE;
            this.myRightType = ModelConsts.NO_DATA_TYPE;
            this.myResultType = ModelConsts.NO_DATA_TYPE;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Operator> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Operator", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Operator", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public PostgresOperatorKind getOperatorKind() {
            PostgresOperatorKind postgresOperatorKind = this.myOperatorKind;
            if (postgresOperatorKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getOperatorKind"));
            }
            return postgresOperatorKind;
        }

        @Override
        public void setOperatorKind(@NotNull PostgresOperatorKind operatorKind) {
            if (operatorKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operatorKind", "com/intellij/database/model/impl/PostgresImplModel$Operator", "setOperatorKind"));
            }
            if (this.myOperatorKind.equals((Object)operatorKind)) {
                return;
            }
            this.modifying();
            this.myOperatorKind = operatorKind;
        }

        @Override
        @Nullable
        public String getCallRoutineName() {
            return this.myCallRoutineName;
        }

        @Override
        public void setCallRoutineName(@Nullable String callRoutineName) {
            if (BaseModel.eq(this.myCallRoutineName, callRoutineName)) {
                return;
            }
            this.modifying();
            this.myCallRoutineName = callRoutineName;
        }

        @Override
        @NotNull
        public DataType getLeftType() {
            DataType dataType = this.myLeftType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getLeftType"));
            }
            return dataType;
        }

        @Override
        public void setLeftType(@NotNull DataType leftType) {
            if (leftType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftType", "com/intellij/database/model/impl/PostgresImplModel$Operator", "setLeftType"));
            }
            if (this.myLeftType.equals(leftType)) {
                return;
            }
            this.modifying();
            this.myLeftType = leftType;
        }

        @Override
        @NotNull
        public DataType getRightType() {
            DataType dataType = this.myRightType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getRightType"));
            }
            return dataType;
        }

        @Override
        public void setRightType(@NotNull DataType rightType) {
            if (rightType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightType", "com/intellij/database/model/impl/PostgresImplModel$Operator", "setRightType"));
            }
            if (this.myRightType.equals(rightType)) {
                return;
            }
            this.modifying();
            this.myRightType = rightType;
        }

        @Override
        @NotNull
        public DataType getResultType() {
            DataType dataType = this.myResultType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Operator", "getResultType"));
            }
            return dataType;
        }

        @Override
        public void setResultType(@NotNull DataType resultType) {
            if (resultType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultType", "com/intellij/database/model/impl/PostgresImplModel$Operator", "setResultType"));
            }
            if (this.myResultType.equals(resultType)) {
                return;
            }
            this.modifying();
            this.myResultType = resultType;
        }
    }

    final class Argument
    extends BaseModel.BaseRegularElement
    implements PostgresModArgument {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private DasArgument.Direction myDirection;
        @NotNull
        private DataType myDataType;
        @Nullable
        private String myDefaultExpression;

        private Argument(BaseModel.BaseFamily<? extends Argument> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Argument", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDirection = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Routine getRoutine() {
            Routine routine = (Routine)this.myParentFamily.owner;
            if (routine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Argument", "getRoutine"));
            }
            return routine;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<Argument> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Argument", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Argument", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Argument", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Argument", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public DasArgument.Direction getDirection() {
            return this.myDirection;
        }

        @Override
        public void setDirection(@Nullable DasArgument.Direction direction) {
            if (BaseModel.eq(this.myDirection, direction)) {
                return;
            }
            this.modifying();
            this.myDirection = direction;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Argument", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/PostgresImplModel$Argument", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Routine
    extends BaseModel.BaseRegularElement
    implements PostgresModRoutine {
        private final Arguments myArguments;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private String mySourceText;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;
        @Nullable
        private String myLanguageName;

        private Routine(BaseModel.BaseFamily<? extends Routine> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Routine", "<init>"));
            }
            super(parentFamily);
            this.myArguments = new Arguments(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySourceText = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
            this.myLanguageName = null;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Routine", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Routine> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Routine", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Arguments getArguments() {
            Arguments arguments = this.myArguments;
            if (arguments == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Routine", "getArguments"));
            }
            return arguments;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Routine", "familyOf"));
            }
            if (kind == ObjectKind.ARGUMENT) {
                return this.myArguments;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Routine", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Routine", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getSourceText() {
            return this.mySourceText;
        }

        @Override
        public void setSourceText(@Nullable String sourceText) {
            if (BaseModel.eq(this.mySourceText, sourceText)) {
                return;
            }
            this.modifying();
            this.mySourceText = sourceText;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Routine", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        @Override
        @Nullable
        public String getLanguageName() {
            return this.myLanguageName;
        }

        @Override
        public void setLanguageName(@Nullable String languageName) {
            if (BaseModel.eq(this.myLanguageName, languageName)) {
                return;
            }
            this.modifying();
            this.myLanguageName = languageName;
        }

        private final class Arguments
        extends BaseModel.BasePositioningNamingFamily<Argument> {
            private Arguments(Routine owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Routine$Arguments", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Argument instantiate() {
                return new Argument(this);
            }
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements PostgresModCheck {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Check", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Check> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Check", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements PostgresModForeignKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;
        @NotNull
        private CascadeRule myOnDelete;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
            this.myOnDelete = CascadeRule.restrict;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<ForeignKey> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }

        @Override
        @NotNull
        public CascadeRule getOnDelete() {
            CascadeRule cascadeRule = this.myOnDelete;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "getOnDelete"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnDelete(@NotNull CascadeRule onDelete) {
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/model/impl/PostgresImplModel$ForeignKey", "setOnDelete"));
            }
            if (this.myOnDelete.equals((Object)onDelete)) {
                return;
            }
            this.modifying();
            this.myOnDelete = onDelete;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements PostgresModKey {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myUnderlyingIndexName;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myUnderlyingIndexName = null;
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Key> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Key", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getUnderlyingIndexName() {
            return this.myUnderlyingIndexName;
        }

        @Override
        public void setUnderlyingIndexName(@Nullable String underlyingIndexName) {
            if (BaseModel.eq(this.myUnderlyingIndexName, underlyingIndexName)) {
                return;
            }
            this.modifying();
            this.myUnderlyingIndexName = underlyingIndexName;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements PostgresModIndex {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myUnique;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myUnique = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Index", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Index> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Index", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }
    }

    final class MatViewColumn
    extends BaseModel.BaseRegularElement
    implements PostgresModMatViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private MatViewColumn(BaseModel.BaseFamily<? extends MatViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public MatView getMatView() {
            MatView matView = (MatView)this.myParentFamily.owner;
            if (matView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "getMatView"));
            }
            return matView;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<MatViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/PostgresImplModel$MatViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class MatView
    extends BaseModel.BaseRegularElement
    implements PostgresModMatView {
        private final Columns myColumns;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;
        @Nullable
        private String mySourceText;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;

        private MatView(BaseModel.BaseFamily<? extends MatView> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$MatView", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
            this.mySourceText = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<MatView> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$MatView", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$MatView", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        @Nullable
        public String getSourceText() {
            return this.mySourceText;
        }

        @Override
        public void setSourceText(@Nullable String sourceText) {
            if (BaseModel.eq(this.mySourceText, sourceText)) {
                return;
            }
            this.modifying();
            this.mySourceText = sourceText;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$MatView", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<Trigger> {
            private Triggers(MatView owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$MatView$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<MatViewColumn> {
            private Columns(MatView owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$MatView$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected MatViewColumn instantiate() {
                return new MatViewColumn(this);
            }
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements PostgresModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view = (View)this.myParentFamily.owner;
            if (view == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "getView"));
            }
            return view;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/PostgresImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements PostgresModView {
        private final Columns myColumns;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;
        @Nullable
        private String mySourceText;
        @NotNull
        private List<SourceError> myErrors;
        private boolean myInvalid;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
            this.mySourceText = null;
            this.myErrors = Collections.emptyList();
            this.myInvalid = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<View> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        @Nullable
        public String getSourceText() {
            return this.mySourceText;
        }

        @Override
        public void setSourceText(@Nullable String sourceText) {
            if (BaseModel.eq(this.mySourceText, sourceText)) {
                return;
            }
            this.modifying();
            this.mySourceText = sourceText;
        }

        @Override
        @NotNull
        public List<SourceError> getErrors() {
            List<SourceError> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$View", "getErrors"));
            }
            return list;
        }

        @Override
        public void setErrors(@Nullable List<SourceError> errors) {
            ImmutableList x;
            ImmutableList immutableList = x = errors != null ? ImmutableList.copyOf(errors) : Collections.emptyList();
            if (x.isEmpty() && this.myErrors.isEmpty()) {
                return;
            }
            this.modifying();
            this.myErrors = x;
        }

        @Override
        public boolean isInvalid() {
            return this.myInvalid;
        }

        @Override
        public void setInvalid(boolean invalid) {
            if (this.myInvalid == invalid) {
                return;
            }
            this.modifying();
            this.myInvalid = invalid;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<Trigger> {
            private Triggers(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$View$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements PostgresModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/PostgresImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements PostgresModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        private final Rules myRules;
        private final Triggers myTriggers;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;
        private boolean myTemporary;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myRules = new Rules(this);
            this.myTriggers = new Triggers(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
            this.myTemporary = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Table> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @NotNull
        public Rules getRules() {
            Rules rules = this.myRules;
            if (rules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getRules"));
            }
            return rules;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            if (kind == ObjectKind.RULE) {
                return this.myRules;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        public boolean isTemporary() {
            return this.myTemporary;
        }

        @Override
        public void setTemporary(boolean temporary) {
            if (this.myTemporary == temporary) {
                return;
            }
            this.modifying();
            this.myTemporary = temporary;
        }

        private final class Triggers
        extends BaseModel.BaseNamingIdentifyingFamily<Trigger> {
            private Triggers(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Rules
        extends BaseModel.BaseNamingIdentifyingFamily<Rule> {
            private Rules(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Rules", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Rule instantiate() {
                return new Rule(this);
            }
        }

        private final class Checks
        extends BaseModel.BaseNamingIdentifyingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingIdentifyingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingIdentifyingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingIdentifyingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class DefTypeAttribute
    extends BaseModel.BaseRegularElement
    implements PostgresModDefTypeAttribute {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;

        private DefTypeAttribute(BaseModel.BaseFamily<? extends DefTypeAttribute> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
        }

        @Override
        @NotNull
        public DefType getDefType() {
            DefType defType = (DefType)this.myParentFamily.owner;
            if (defType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "getDefType"));
            }
            return defType;
        }

        @Override
        @NotNull
        public ModNamingFamily<DefTypeAttribute> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/PostgresImplModel$DefTypeAttribute", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }
    }

    final class DefType
    extends BaseModel.BaseRegularElement
    implements PostgresModDefType {
        private final Attributes myAttributes;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private PostgresDataTypeSubKind mySubKind;
        @NotNull
        private PostgresDataTypeSubCategory mySubCategory;

        private DefType(BaseModel.BaseFamily<? extends DefType> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$DefType", "<init>"));
            }
            super(parentFamily);
            this.myAttributes = new Attributes(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySubKind = PostgresDataTypeSubKind.NONE;
            this.mySubCategory = PostgresDataTypeSubCategory.NONE;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<DefType> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Attributes getAttributes() {
            Attributes attributes = this.myAttributes;
            if (attributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getAttributes"));
            }
            return attributes;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$DefType", "familyOf"));
            }
            if (kind == ObjectKind.OBJECT_ATTRIBUTE) {
                return this.myAttributes;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$DefType", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public PostgresDataTypeSubKind getSubKind() {
            PostgresDataTypeSubKind postgresDataTypeSubKind = this.mySubKind;
            if (postgresDataTypeSubKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getSubKind"));
            }
            return postgresDataTypeSubKind;
        }

        @Override
        public void setSubKind(@NotNull PostgresDataTypeSubKind subKind) {
            if (subKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subKind", "com/intellij/database/model/impl/PostgresImplModel$DefType", "setSubKind"));
            }
            if (this.mySubKind.equals((Object)subKind)) {
                return;
            }
            this.modifying();
            this.mySubKind = subKind;
        }

        @Override
        @NotNull
        public PostgresDataTypeSubCategory getSubCategory() {
            PostgresDataTypeSubCategory postgresDataTypeSubCategory = this.mySubCategory;
            if (postgresDataTypeSubCategory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$DefType", "getSubCategory"));
            }
            return postgresDataTypeSubCategory;
        }

        @Override
        public void setSubCategory(@NotNull PostgresDataTypeSubCategory subCategory) {
            if (subCategory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subCategory", "com/intellij/database/model/impl/PostgresImplModel$DefType", "setSubCategory"));
            }
            if (this.mySubCategory.equals((Object)subCategory)) {
                return;
            }
            this.modifying();
            this.mySubCategory = subCategory;
        }

        private final class Attributes
        extends BaseModel.BaseNamingFamily<DefTypeAttribute> {
            private Attributes(DefType owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$DefType$Attributes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected DefTypeAttribute instantiate() {
                return new DefTypeAttribute(this);
            }
        }
    }

    final class Sequence
    extends BaseModel.BaseRegularElement
    implements PostgresModSequence {
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private SequenceIdentity myIdentity;
        private boolean myCycled;

        private Sequence(BaseModel.BaseFamily<? extends Sequence> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "<init>"));
            }
            super(parentFamily);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIdentity = null;
            this.myCycled = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Sequence> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "familyOf"));
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Sequence", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public SequenceIdentity getIdentity() {
            return this.myIdentity;
        }

        @Override
        public void setIdentity(@Nullable SequenceIdentity identity) {
            if (BaseModel.eq(this.myIdentity, identity)) {
                return;
            }
            this.modifying();
            this.myIdentity = identity;
        }

        @Override
        public boolean isCycled() {
            return this.myCycled;
        }

        @Override
        public void setCycled(boolean cycled) {
            if (this.myCycled == cycled) {
                return;
            }
            this.modifying();
            this.myCycled = cycled;
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements PostgresModSchema {
        private final Sequences mySequences;
        private final DefTypes myDefTypes;
        private final Tables myTables;
        private final Views myViews;
        private final MatViews myMatViews;
        private final Routines myRoutines;
        private final Operators myOperators;
        private long myObjectId;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private long myIntrospectionStateNumber;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.mySequences = new Sequences(this);
            this.myDefTypes = new DefTypes(this);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myMatViews = new MatViews(this);
            this.myRoutines = new Routines(this);
            this.myOperators = new Operators(this);
            this.myObjectId = Long.MIN_VALUE;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myIntrospectionStateNumber = 0L;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Database getDatabase() {
            Database database = (Database)this.myParentFamily.owner;
            if (database == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getDatabase"));
            }
            return database;
        }

        @Override
        @NotNull
        public ModNamingIdentifyingFamily<Schema> getParentFamily() {
            ModNamingIdentifyingFamily modNamingIdentifyingFamily = (ModNamingIdentifyingFamily)((Object)this.myParentFamily);
            if (modNamingIdentifyingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getParentFamily"));
            }
            return modNamingIdentifyingFamily;
        }

        @Override
        @NotNull
        public Sequences getSequences() {
            Sequences sequences = this.mySequences;
            if (sequences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getSequences"));
            }
            return sequences;
        }

        @Override
        @NotNull
        public DefTypes getDefTypes() {
            DefTypes defTypes = this.myDefTypes;
            if (defTypes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getDefTypes"));
            }
            return defTypes;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @NotNull
        public MatViews getMatViews() {
            MatViews matViews = this.myMatViews;
            if (matViews == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getMatViews"));
            }
            return matViews;
        }

        @Override
        @NotNull
        public Routines getRoutines() {
            Routines routines = this.myRoutines;
            if (routines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getRoutines"));
            }
            return routines;
        }

        @Override
        @NotNull
        public Operators getOperators() {
            Operators operators = this.myOperators;
            if (operators == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getOperators"));
            }
            return operators;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.SEQUENCE) {
                return this.mySequences;
            }
            if (kind == ObjectKind.OBJECT_TYPE) {
                return this.myDefTypes;
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            if (kind == ObjectKind.MAT_VIEW) {
                return this.myMatViews;
            }
            if (kind == ObjectKind.ROUTINE) {
                return this.myRoutines;
            }
            if (kind == ObjectKind.OPERATOR) {
                return this.myOperators;
            }
            return null;
        }

        @Override
        public long getObjectId() {
            return this.myObjectId;
        }

        @Override
        public void setObjectId(long objectId) {
            if (this.myObjectId == objectId) {
                return;
            }
            this.modifying();
            this.myObjectId = objectId;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public long getIntrospectionStateNumber() {
            return this.myIntrospectionStateNumber;
        }

        @Override
        public void setIntrospectionStateNumber(long introspectionStateNumber) {
            if (this.myIntrospectionStateNumber == introspectionStateNumber) {
                return;
            }
            this.modifying();
            this.myIntrospectionStateNumber = introspectionStateNumber;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Operators
        extends BaseModel.BaseNamingIdentifyingFamily<Operator> {
            private Operators(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$Operators", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Operator instantiate() {
                return new Operator(this);
            }
        }

        private final class Routines
        extends BaseModel.BaseNamingIdentifyingFamily<Routine> {
            private Routines(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$Routines", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Routine instantiate() {
                return new Routine(this);
            }
        }

        private final class MatViews
        extends BaseModel.BaseNamingIdentifyingFamily<MatView> {
            private MatViews(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$MatViews", "<init>"));
                }
                super(owner);
            }

            @Override
            protected MatView instantiate() {
                return new MatView(this);
            }
        }

        private final class Views
        extends BaseModel.BaseNamingIdentifyingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingIdentifyingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }

        private final class DefTypes
        extends BaseModel.BaseNamingIdentifyingFamily<DefType> {
            private DefTypes(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$DefTypes", "<init>"));
                }
                super(owner);
            }

            @Override
            protected DefType instantiate() {
                return new DefType(this);
            }
        }

        private final class Sequences
        extends BaseModel.BaseNamingIdentifyingFamily<Sequence> {
            private Sequences(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Schema$Sequences", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Sequence instantiate() {
                return new Sequence(this);
            }
        }
    }

    final class Database
    extends BaseModel.BaseRegularElement
    implements PostgresModDatabase {
        private final Schemas mySchemas;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean myCurrent;
        private boolean myVisible;

        private Database(BaseModel.BaseFamily<? extends Database> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/PostgresImplModel$Database", "<init>"));
            }
            super(parentFamily);
            this.mySchemas = new Schemas(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root = (Root)this.myParentFamily.owner;
            if (root == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Database", "getRoot"));
            }
            return root;
        }

        @Override
        @NotNull
        public ModNamingFamily<Database> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Database", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Database", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Database", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Database", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/PostgresImplModel$Database", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = name;
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Schemas
        extends BaseModel.BaseNamingIdentifyingFamily<Schema> {
            private Schemas(Database owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Database$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements PostgresModRoot {
        private final Databases myDatabases = new Databases(this);

        private Root() {
        }

        @Override
        @NotNull
        public Databases getDatabases() {
            Databases databases = this.myDatabases;
            if (databases == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/PostgresImplModel$Root", "getDatabases"));
            }
            return databases;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/PostgresImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.DATABASE) {
                return this.myDatabases;
            }
            return null;
        }

        private final class Databases
        extends BaseModel.BaseNamingFamily<Database> {
            private Databases(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/PostgresImplModel$Root$Databases", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Database instantiate() {
                return new Database(this);
            }
        }
    }
}

