/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.mssql.MsModCustomType;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModAliasType
extends MsAliasType,
MsModCustomType {
    @Override
    @NotNull
    public MsModSchema getSchema();

    @Override
    @NotNull
    default public MsModSchema getDbParent() {
        MsModSchema msModSchema = this.getSchema();
        if (msModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModAliasType", "getDbParent"));
        }
        return msModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends MsModAliasType> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModAliasType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModAliasType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setTypeId(int var1);

    public void setDataType(@NotNull DataType var1);

    public void setNotNull(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModAliasType", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String typeId = properties.get("TypeId");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (typeId != null) {
            this.setTypeId(PropertyConverter.importInt(typeId));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
    }
}

