/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.mssql.MsModLikeColumn;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModTableType;
import com.intellij.database.model.mssql.MsTableTypeColumn;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModTableTypeColumn
extends MsTableTypeColumn,
MsModLikeColumn {
    @Override
    @NotNull
    public MsModTableType getTableType();

    @Override
    @NotNull
    default public MsModTableType getDbParent() {
        MsModTableType msModTableType = this.getTableType();
        if (msModTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTableTypeColumn", "getDbParent"));
        }
        return msModTableType;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends MsModTableTypeColumn> getParentFamily();

    @Override
    @NotNull
    default public MsModSchema getSchema() {
        MsModSchema msModSchema = this.getTableType().getSchema();
        if (msModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTableTypeColumn", "getSchema"));
        }
        return msModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTableTypeColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModTableTypeColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModTableTypeColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
    }
}

