/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraModCollectionType;
import com.intellij.database.model.oracle.OraModMatView;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModPack;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModSequence;
import com.intellij.database.model.oracle.OraModSingleRoutine;
import com.intellij.database.model.oracle.OraModSynonym;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModSchema
extends OraSchema,
BasicModSchema,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public OraModRoot getRoot();

    @Override
    @NotNull
    default public OraModRoot getDbParent() {
        OraModRoot oraModRoot = this.getRoot();
        if (oraModRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSchema", "getDbParent"));
        }
        return oraModRoot;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModSchema> getParentFamily();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModSequence> getSequences();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModTable> getTables();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModView> getViews();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModMatView> getMatViews();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModPack> getPacks();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModObjectType> getObjectTypes();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModCollectionType> getCollectionTypes();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModSingleRoutine> getRoutines();

    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModSynonym> getSynonyms();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getSequences(), this.getTables(), this.getViews(), this.getMatViews(), this.getPacks(), this.getObjectTypes(), this.getCollectionTypes(), this.getRoutines(), this.getSynonyms());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSequences()).append((Iterable)this.getTables()).append((Iterable)this.getViews()).append((Iterable)this.getMatViews()).append((Iterable)this.getPacks()).append((Iterable)this.getObjectTypes()).append((Iterable)this.getCollectionTypes()).append((Iterable)this.getRoutines()).append((Iterable)this.getSynonyms());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setIntrospectionTimestamp(@Nullable Date var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModSchema", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String introspectionTimestamp = properties.get("IntrospectionTimestamp");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (introspectionTimestamp != null) {
            this.setIntrospectionTimestamp(PropertyConverter.importDate(introspectionTimestamp));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

