/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModTrigger
extends PostgresTrigger,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModTable getTable();

    @Override
    @NotNull
    default public PostgresModTable getDbParent() {
        PostgresModTable postgresModTable = this.getTable();
        if (postgresModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTrigger", "getDbParent"));
        }
        return postgresModTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTrigger> getParentFamily();

    @Override
    @NotNull
    default public PostgresModSchema getSchema() {
        PostgresModSchema postgresModSchema = this.getTable().getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTrigger", "getSchema"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setEvent(@NotNull Set<TrigEvent> var1);

    public void setCondition(@Nullable String var1);

    public void setCallRoutineName(@Nullable String var1);

    public void setCallArguments(@Nullable String var1);

    public void setDeferrable(boolean var1);

    public void setInitiallyDeferred(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModTrigger", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String turn = properties.get("Turn");
        String event = properties.get("Event");
        String condition = properties.get("Condition");
        String callRoutineName = properties.get("CallRoutineName");
        String callArguments = properties.get("CallArguments");
        String deferrable = properties.get("Deferrable");
        String initiallyDeferred = properties.get("InitiallyDeferred");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (event != null) {
            this.setEvent(PropertyConverter.importSetOfTrigEvent(event));
        }
        if (condition != null) {
            this.setCondition(PropertyConverter.importString(condition));
        }
        if (callRoutineName != null) {
            this.setCallRoutineName(PropertyConverter.importString(callRoutineName));
        }
        if (callArguments != null) {
            this.setCallArguments(PropertyConverter.importString(callArguments));
        }
        if (deferrable != null) {
            this.setDeferrable(PropertyConverter.importBoolean(deferrable));
        }
        if (initiallyDeferred != null) {
            this.setInitiallyDeferred(PropertyConverter.importBoolean(initiallyDeferred));
        }
    }
}

