/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresMatView;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresSchema
extends BasicSchema,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SCHEMA;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresSchema", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PostgresDatabase getDatabase();

    @Override
    @Nullable
    default public PostgresDatabase getDbParent() {
        return this.getDatabase();
    }

    @Override
    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresSchema> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresSequence> getSequences();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresDefType> getDefTypes();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresTable> getTables();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresView> getViews();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresMatView> getMatViews();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresRoutine> getRoutines();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends PostgresOperator> getOperators();

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getSequences(), this.getDefTypes(), this.getTables(), this.getViews(), this.getMatViews(), this.getRoutines(), this.getOperators());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getSequences()).append(this.getDefTypes()).append(this.getTables()).append(this.getViews()).append(this.getMatViews()).append(this.getRoutines()).append(this.getOperators());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresSchema", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getIntrospectionTimestamp() {
        return null;
    }

    default public long getIntrospectionStateNumber() {
        return 0L;
    }

    @Override
    default public boolean isCurrent() {
        return false;
    }

    @Override
    default public boolean isVisible() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean visible;
        boolean current;
        long introspectionStateNumber;
        Date introspectionTimestamp;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresSchema", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((introspectionTimestamp = this.getIntrospectionTimestamp()) != null) {
            consumer.accept("IntrospectionTimestamp", PropertyConverter.export(introspectionTimestamp));
        }
        if ((introspectionStateNumber = this.getIntrospectionStateNumber()) != 0L) {
            consumer.accept("IntrospectionStateNumber", PropertyConverter.export(introspectionStateNumber));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", PropertyConverter.export(current));
        }
        if (visible = this.isVisible()) {
            consumer.accept("Visible", PropertyConverter.export(visible));
        }
    }
}

