/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import java.util.Locale;

public enum PostgresDataTypeSubCategory {
    NONE('\u0000'),
    ARRAY('A'),
    BOOLEAN('B'),
    COMPOSITE('C'),
    DATE_TIME('D'),
    ENUM('E'),
    GEOMETRIC('G'),
    NETWORK('I'),
    NUMERIC('N'),
    PSEUDO('P'),
    STRING('S'),
    TIME_SPAN('T'),
    USER_DEFINED('U'),
    BIT_STRING('V'),
    UNKNOWN('X');

    public final char code;

    private PostgresDataTypeSubCategory(char code) {
        this.code = code;
    }

    static PostgresDataTypeSubCategory of(char c) {
        switch (Character.toUpperCase(c)) {
            case '\u0000': {
                return NONE;
            }
            case 'A': {
                return ARRAY;
            }
            case 'B': {
                return BOOLEAN;
            }
            case 'C': {
                return COMPOSITE;
            }
            case 'D': {
                return DATE_TIME;
            }
            case 'E': {
                return ENUM;
            }
            case 'G': {
                return GEOMETRIC;
            }
            case 'I': {
                return NETWORK;
            }
            case 'N': {
                return NUMERIC;
            }
            case 'P': {
                return PSEUDO;
            }
            case 'S': {
                return STRING;
            }
            case 'T': {
                return TIME_SPAN;
            }
            case 'U': {
                return USER_DEFINED;
            }
            case 'V': {
                return BIT_STRING;
            }
        }
        return UNKNOWN;
    }

    public String human_readable_name() {
        return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
    }
}

