/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SQLiteModLikeColumn;
import com.intellij.database.model.sqlite.SQLiteModSchema;
import com.intellij.database.model.sqlite.SQLiteModTable;
import com.intellij.database.model.sqlite.SQLiteTableColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SQLiteModTableColumn
extends SQLiteTableColumn,
SQLiteModLikeColumn {
    @Override
    @NotNull
    public SQLiteModTable getTable();

    @Override
    @NotNull
    default public SQLiteModTable getDbParent() {
        SQLiteModTable sQLiteModTable = this.getTable();
        if (sQLiteModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTableColumn", "getDbParent"));
        }
        return sQLiteModTable;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SQLiteModTableColumn> getParentFamily();

    @Override
    @NotNull
    default public SQLiteModSchema getSchema() {
        SQLiteModSchema sQLiteModSchema = this.getTable().getSchema();
        if (sQLiteModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTableColumn", "getSchema"));
        }
        return sQLiteModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTableColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTableColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    public void setDefaultExpression(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sqlite/SQLiteModTableColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        String defaultExpression = properties.get("DefaultExpression");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
    }
}

