/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseModCheck;
import com.intellij.database.model.sybase.SybaseModForeignKey;
import com.intellij.database.model.sybase.SybaseModIndex;
import com.intellij.database.model.sybase.SybaseModKey;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTableColumn;
import com.intellij.database.model.sybase.SybaseModTrigger;
import com.intellij.database.model.sybase.SybaseTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseModTable
extends SybaseTable,
SybaseModLikeTable {
    @Override
    @NotNull
    public SybaseModSchema getSchema();

    @Override
    @NotNull
    default public SybaseModSchema getDbParent() {
        SybaseModSchema sybaseModSchema = this.getSchema();
        if (sybaseModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTable", "getDbParent"));
        }
        return sybaseModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SybaseModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModKey> getKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends SybaseModCheck> getChecks();

    @NotNull
    public ModNamingFamily<? extends SybaseModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sybase/SybaseModTable", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
    }
}

