/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sybase;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMinorObject;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sybase.SybaseArgument;
import com.intellij.database.model.sybase.SybaseProcedureGroup;
import com.intellij.database.model.sybase.SybaseSchema;
import com.intellij.database.model.sybase.SybaseSourceAware;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SybaseProcedure
extends BasicRoutine,
BasicMinorObject,
SybaseSourceAware,
BasicArrangedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseProcedure", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public SybaseProcedureGroup getProcedureGroup();

    @Override
    @Nullable
    default public SybaseProcedureGroup getDbParent() {
        return this.getProcedureGroup();
    }

    @Override
    @Nullable
    default public SybaseProcedureGroup getMajorObject() {
        return this.getProcedureGroup();
    }

    default public @Nullable PositioningFamily<@NotNull ? extends SybaseProcedure> getParentFamily() {
        return null;
    }

    @Nullable
    default public SybaseSchema getSchema() {
        SybaseProcedureGroup procedureGroup = this.getProcedureGroup();
        return procedureGroup != null ? procedureGroup.getSchema() : null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends SybaseArgument> getArguments();

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Iterable> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseProcedure", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sybase/SybaseProcedure", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public short getPosition() {
        return 0;
    }

    @Override
    @Nullable
    default public String getSourceText() {
        return null;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/sybase/SybaseProcedure", "exportProperties"));
        }
        short position = this.getPosition();
        if (position != 0) {
            consumer.accept("Position", PropertyConverter.export(position));
        }
    }
}

