/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableImpl
extends DbElementImpl<DasTable, DbElement>
implements DbTable {
    protected DbTableImpl(DbElement parent, DasTable delegate) {
        super(parent, delegate);
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        ObjectKind kind;
        StringBuilder sb = super.getDocumentation();
        DdlBuilder.Colored colored = this.createDocBuilder(sb);
        String remarks = this.getComment();
        if (StringUtil.isNotEmpty((String)remarks)) {
            colored.plain("<br>").comment(remarks);
        }
        if ((kind = this.getKind()) != ObjectKind.SYNONYM && kind != ObjectKind.SEQUENCE) {
            sb.append("<br>").append("<!-- async-doc-cut -->").append("<code><pre>");
            colored.comment("auto-generated definition").newLine();
            colored.element((DasObject)this);
            sb.append("</pre></code>");
        }
        if (DbImplUtil.canConnectTo(this) && (DbImplUtil.isDataTable((DasTable)this) || DatabaseEditorHelper.isRawDefinitionAvailable(this))) {
            this.scheduleAsyncDocumentationUpdate(sb);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbTableImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadSlowDocumentationInner(@NotNull CharOut sb, @NotNull ConnectionProvider provider) throws Exception {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/psi/DbTableImpl", "loadSlowDocumentationInner"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/psi/DbTableImpl", "loadSlowDocumentationInner"));
        }
        if (DbImplUtil.isDataTable((DasTable)this)) {
            Map<Object, Object> infoMap = Collections.emptyMap();
            try {
                infoMap = DbImplUtil.tryLoadTableInfo(provider, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int previewRows = DatabaseSettings.getSettings().getPreviewRows();
            String tableQuery = DbImplUtil.createSelectAllQuery((DasTable)this, DbImplUtil.getDatabaseDialect(this), previewRows).getStatement();
            sb.append("<b>Rows:</b> ~").append(ObjectUtils.notNull((Object)infoMap.get("rows"), (Object)"0").toString()).append(DataGridDocumentationProvider.getCountCommand(false)).append("<br>");
            for (String string : infoMap.keySet()) {
                Object obj = infoMap.get(string);
                String s = obj == null ? null : String.valueOf(obj);
                if (StringUtil.isEmptyOrSpaces((String)s) || "rows".equals(string)) continue;
                sb.append("<b>" + string + ":</b> " + s + "<br>");
            }
            if (previewRows > 0) {
                sb.append("<br>");
                long curLength = sb.length();
                try {
                    if (provider.acquire()) {
                        DbImplUtil.tryLoadFirstNRows("<b>First %d rows:</b><br>", provider.getConnection(), tableQuery, sb, previewRows);
                    }
                }
                finally {
                    provider.release();
                }
                if (sb.length() == curLength) {
                    sb.append("<b>").append(StringUtil.capitalize((String)this.getTypeName())).append(" is empty</b><br>");
                }
            }
        }
        if (DatabaseEditorHelper.isRawDefinitionAvailable(this)) {
            sb.append("<br>");
            sb.append("<b>Definition:</b><br><code><pre>");
            StringBuilder builder = new StringBuilder();
            DatabaseEditorHelper.loadDefinition(provider, this, builder);
            sb.append(DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), builder));
            sb.append("</pre></code>");
        }
    }

    public boolean isSystem() {
        return ((DasTable)this.myDelegate).isSystem();
    }

    public boolean isTemporary() {
        return ((DasTable)this.myDelegate).isTemporary();
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set set = ((DasTable)this.myDelegate).getColumnAttrs(columnInfo instanceof DbColumn ? (DasColumn)((DbColumn)columnInfo).getDelegate() : columnInfo);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbTableImpl", "getColumnAttrs"));
        }
        return set;
    }
}

