/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.Color;
import java.util.EventObject;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanEditorFactory
implements GridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        switch (ExtractorsUtil.guessJdbcType(c)) {
            case -7: 
            case 16: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "createEditor"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "createEditor"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "createEditor"));
        }
        Object value = grid.getDataModel().getValueAt(row, column);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column);
        BooleanCellEditor booleanCellEditor = new BooleanCellEditor(grid, value, nullValue);
        if (booleanCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory", "createEditor"));
        }
        return booleanCellEditor;
    }

    private static class BooleanCellEditor
    extends GridCellEditor.Adapter {
        private final ReservedCellValue myNullValue;
        private final ThreeStateCheckBox myComponent;

        private BooleanCellEditor(final @NotNull DataGrid grid, @Nullable Object value, @Nullable ReservedCellValue nullValue) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor", "<init>"));
            }
            this.myNullValue = nullValue;
            this.myComponent = new ThreeStateCheckBox(){

                public Color getBackground() {
                    Color background = super.getBackground();
                    return background != null ? new JBColor(background.darker(), background.brighter()) : null;
                }
            };
            this.myComponent.setHorizontalAlignment(0);
            this.myComponent.setThirdStateEnabled(this.myNullValue != null);
            this.myComponent.setState(BooleanCellEditor.getCheckboxState(value, nullValue));
            this.myComponent.setRequestFocusEnabled(true);
            this.myComponent.addItemListener(e -> this.fireEditing(this.getValue()));
            new DumbAwareAction("Stop Editing"){

                public void actionPerformed(AnActionEvent e) {
                    grid.stopEditing();
                }
            }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), (JComponent)this.myComponent, (Disposable)this);
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            ThreeStateCheckBox threeStateCheckBox = this.myComponent;
            if (threeStateCheckBox == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor", "getComponent"));
            }
            return threeStateCheckBox;
        }

        @Override
        @Nullable
        public Object getValue() {
            ThreeStateCheckBox.State state = this.myComponent.getState();
            switch (state) {
                case NOT_SELECTED: {
                    return Boolean.FALSE;
                }
                case SELECTED: {
                    return Boolean.TRUE;
                }
            }
            return this.myNullValue;
        }

        @Override
        public boolean isColumnSpanAllowed() {
            return false;
        }

        @NotNull
        private static ThreeStateCheckBox.State getCheckboxState(Object value, ReservedCellValue nullValue) {
            Boolean b = (Boolean)ObjectUtils.tryCast((Object)value, Boolean.class);
            if (value instanceof Number) {
                b = ((Number)value).intValue() == 1;
            } else if (value == null) {
                Boolean bl = b = nullValue != null ? null : Boolean.FALSE;
            }
            ThreeStateCheckBox.State state = Boolean.TRUE.equals(b) ? ThreeStateCheckBox.State.SELECTED : (Boolean.FALSE.equals(b) ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultBooleanEditorFactory$BooleanCellEditor", "getCheckboxState"));
            }
            return state;
        }
    }
}

