/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.mysql;

import com.intellij.database.dialects.MysqlDialect;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlReorderColumnsOperation
extends DasDdlOperations.ReorderColumnsOperation {
    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeTable table, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/mysql/MysqlReorderColumnsOperation", "generate"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/operations/mysql/MysqlReorderColumnsOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/mysql/MysqlReorderColumnsOperation", "generate"));
        }
        List columns = (List)FROM_ORDER.get(data);
        TIntArrayList insertions = (TIntArrayList)REORDER_INSERTIONS.get(data);
        if (columns == null || insertions == null || insertions.isEmpty()) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mysql/MysqlReorderColumnsOperation", "generate"));
            }
            return ddlBuilder;
        }
        columns = ContainerUtil.newArrayList((Iterable)columns);
        builder.keywords("ALTER", "TABLE").space().qualifiedRef(table).newLine();
        int i = 0;
        while (i + 1 < insertions.size()) {
            if (i != 0) {
                builder.symbol(",").newLine();
            }
            int from = insertions.get(i);
            int to = insertions.get(i + 1);
            DeColumn after = to == 0 ? null : (DeColumn)columns.get(to - 1);
            DeColumn column = (DeColumn)columns.remove(from);
            columns.add(to < from ? to : to - 1, column);
            builder.space(2).keywords("MODIFY", "COLUMN").space().columnRef(column).space();
            MysqlDialect.INSTANCE.sqlAppendColumnDefinition(builder, column).space();
            if (after == null) {
                builder.keyword("FIRST");
            } else {
                builder.keyword("AFTER").space().columnRef(after);
            }
            i += 2;
        }
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/mysql/MysqlReorderColumnsOperation", "generate"));
        }
        return ddlBuilder;
    }
}

